<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */


/**
 * A Dom messaging object. Use this to send xml based templates.
 * 
 * @package Mail
 */
class Dk_Mail_HtmlMessage extends Dk_Mail_DomMessage 
{
    
    /**
     * Create a dom template based email message.
     * 
     * @param array $addressList
     */
    function __construct($addressList)
    {
        $exFile = Dk_Config::getInstance()->getHtmlTemplates() . '/mail/Message.html';
        if (is_file($exFile)) {
            $this->setTemplate(Dom_Template::load($exFile));
            $template = $this->getTemplate();
        } else {
            $template = $this->__makeTemplate();
        }
        parent::__construct($addressList, $template);
    }
    
    /**
     * A null show function for the renderer interface
     */
    function show($template = null) 
    {
        $request = Dk_Request::getInstance();
        
        $template->replaceText('requestUri', $request->getRequestUri()->toString());
        $template->replaceAttr('requestUri', 'href', $request->getRequestUri()->toString());
        $template->replaceText('remoteIp', $request->getRemoteAddr());
        $template->replaceText('userAgent', $request->getUserAgent());
        $template->replaceText('subject', $this->getSubject());
    }
    
    /**
     * Set the message html content
     *
     * @param string $html
     */
    function setContent($html)
    {
        $this->getTemplate()->replaceHTML('content', $html);
    }
    
    /**
     * Make the template
     *
     * @return Dom_Template
     */
    function __makeTemplate()
    {
        $xmlStr = '
<html>
<head>
  <title>Email</title>
  
  <style type="text/css">
  
  
body,div,p,ul,li,blockquote
{
  padding: 0;
  margin: 0;
}

body {
  font-family: arial,sans-serif;
  font-size: 80%;
  padding: 5px;
  background-color: #FFF;
}

p {
  font-size: 90%;
  margin: 2px 0px;
  padding: 0px;
}

.list {
}
.list th {
  padding: 2px 10px;
  font-size: 13px;
}
.list td {
  padding: 2px 15px;
  font-size: 11px;
}
.list .field {
  text-align: left;
  vertical-align: top;
}
.list .data {
  text-align: left;
}

  </style>
</head>
<body>
  
  <h2 var="subject"></h2>
  <hr/>
  <p>&#160;</p>
  <div class="content" var="content"></div>
  <p>&#160;</p>
  <div class="footer">
      <hr />
      <p>Sent From Page: <a href="#" var="requestUri"></a></p>
      <p>
        <b>User Stats:</b><br/>
        <i>IP Address:</i> <span var="remoteIp"></span><br/>
        <i>User Agent:</i> <span var="userAgent"></span>
      </p>
  </div>
</body>
</html>';
        
        return Dom_Template::loadXml($xmlStr);
    }
}
?>