<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */


/**
 * A Dom messaging object. Use this to send xml based templates.
 * 
 * @package Mail
 */
abstract class Dk_Mail_DomMessage extends Dk_Mail_MimeMessage implements Dom_RendererInterface 
{
    /**
     * @var Dom_Template
     */
    protected $template = null;
    

    /**
     * Create a dom template based email message.
     *
     * @param array $addressList
     * @param Dom_Template $template
     */
    function __construct($addressList, Dom_Template $template)
    {
        parent::__construct($addressList);
        $this->template = $template;
    }
    
    /**
     * getTemplate
     *
     * @return Dom_Template
     */
    function getTemplate()
    {
        return $this->template;
    }
    
    /**
     * Set the template
     *
     * @param Dom_Template $template
     */
    function setTemplate(Dom_Template $template)
    {
        $this->template = $template;
    }
    
    /**
     * Returns the message body.
     * 
     * @return string
     */
    function getBody()
    {
        if ($this->body == null) {
            $this->show($this->getTemplate());
            $doc = $this->getTemplate()->getDocument();
            if ($this->isHtml()) {
                $this->body = $doc->saveXML();
            } else {
                $this->body = $doc->documentElement->textContent;
            }
        }
        return $this->body;
    }
    
}
?>