<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * The address base class, used for electronic messaging
 * 
 * For multiple recipients use:<br>
 *   "email1@home.com, email2@home.com, ..."
 * 
 * @package Mail
 */
class Dk_Mail_Address 
{
    /**
     * @var string
     */
    protected $to = '';
    /**
     * @var string
     */
    protected $from = '';
    /**
     * @var string
     */
    protected $bcc = '';
    /**
     * @var string
     */
    protected $cc = '';
    
    
    /**
     * __construct
     * 
     * @param string The to address.
     */
    function __construct($to) 
    {
        $this->setTo($to);
    }
    
    /**
     * Returns the to arress array.
     * 
     * @return string
     */
    function getTo() 
    {
        return $this->to;
    }
    
     /**
      * Sets the recipient address.
      * 
      * @param string
      */
    function setTo($email) 
    {
        Dk_Mail_Gateway::validateField($email);
        $this->to = $email;
    }
    
    /**
     * Returns the from address.
     * 
     * @return string
     */
    function getFrom() 
    {
        return $this->from;
    }
    
     /**
     * Sets the from address.
     * 
     * @param string $email
     */
    function setFrom($email) 
    {
        Dk_Mail_Gateway::validateField($email);
        $this->from = $email;
    }
    
    /**
     * Returns the Bcc address.
     * 
     * @return string
     */
    function getBcc() 
    {
        return $this->bcc;
    }
    
     /**
     * Sets the Bcc address.
     * 
     * @param string $email 
     */
    function setBcc($email) 
    {
        Dk_Mail_Gateway::validateField($email);
        $this->bcc = $email;
    }
    
    /**
     * Returns the Cc address.
     * 
     * @return string
     */
    function getCc() 
    {
        return $this->cc;
    }
    
     /**
     * Sets the Cc address.
     * 
     * @param string $email
     */
    function setCc($email) 
    {
        Dk_Mail_Gateway::validateField($email);
        $this->cc = $email;
    }
}
?>