<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/* 
 *  The auto loader will look for the classname (array key)
 *  then load the file given in the array value. 
 */
if(!isset($autoloadAliases)) {
    $autoloadAliases = array();
}

/**
 * Autoload any classes not included manualy.
 * This is why we have named the classes
 * by using the path. Replace '_' with '/' and add a '.php'
 * and we should have the include path.
 * 
 * @param string $className
 */
function __autoload($className)
{
    global $autoloadAliases;
    
    $file = str_replace('_', '/', $className).'.php';
    if (array_key_exists($className, $autoloadAliases)) {
        $file = $autoloadAliases[$className];
    }
    // Include the class file
    if (defined('IS_WEBSERVICE')) {
        include_once($file);
    } else {
        include_once($file);
    }
}

?>