<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * Renders a form and its fields.
 * 
 * @package Form
 */
class Dk_Form_Renderer extends Dk_Web_Renderer 
{
    
    /**
     * @var Dk_Form_Object
     */
    private $form = null;
    
    
    /**
     * __construct
     * 
     * @param Dom_Template $template
     * @param Dk_Form_Object $form The form to renderer. 
     */
    function __construct(Dk_Form_Object $form)
    {
        $this->form = $form;
    }
    
    /**
     * Show
     *
     */
    function show($template = null) 
    {
        $formName = $this->form->getId();
        $domForm = $template->getForm($formName);
        if ($domForm == null) {
            error_log('Cannot find form: ' . $formName);
            return;
        }
        $action = $this->form->getAction();
        if ($action != null) {
            $domForm->setAction($action);
        }

        $this->showFields($template, $domForm);
        
        // Render form error
        $msg = '';
        foreach ($this->form->getErrors() as $m) {
            $msg .= $m . '<br />';
        }
        
        if ($msg != null || count($this->form->getErrors()) > 0) {
            $var = $choice = 'form-error';
            if ($msg != '' && $template->keyExists('var', $var)) {
                $template->replaceHtml($var, $msg);
            }
            if ($template->keyExists('choice', $choice)) { 
                $template->setChoice($choice);
            }
        }
    }
    
    /**
     * Render the form fields
     *
     * @param Dom_Template $template
     * @param Dom_Form $domForm
     * @return boolean
     */
    private function showFields($template, $domForm)
    {
        $hasErrors = false;
        /* @var $field Dk_Form_Field */
        foreach ($this->form->getFields() as $field) {
            $values = $field->getDomValues();
            foreach ($values as $name => $value) {
                if (is_Array($value)) {
	                $elList = $domForm->getFormElementList($name.'[]');
                } else {
                    $elList = $domForm->getFormElementList($name);
                }
	            foreach ($elList as $el) {
    	            if ($el != null) {
    	                $type = $el->getType();
    	                switch (get_class($el)) {
    	                    case 'Dom_FormInput':
                                if ($type == 'file') {
                                    break;
                                }
    	                        if ($type == 'checkbox' || $type == 'radio') {
    	                            if (is_array($value) && $type == 'checkbox') {
    	                                foreach ($value as $v) {
    	                                    $domForm->setCheckedByValue($name . '[]', $v);
    	                                }
    	                            } else {
    	                                $domForm->setCheckedByValue($name, $value);
    	                            }
    	                        } else {
    	                            $el->setValue($value); 
    	                        }
    	                        break;
    	                    case 'Dom_FormTextarea':
    	                        $el->setValue($value);
    	                        break;
    	                    case 'Dom_FormSelect':
    	                        $el->setValue($value);
    	                        break;
    	                }
    	            }
	            }
            }
            // Render Errors
            if ($field->hasErrors()) {
                $msg = '';
                foreach ($field->getErrors() as $i => $m) {
                    $msg .= $m;
                    if ($i < count($field->getErrors())-1) {
                        $msg .= '<br/>';
                    }
                }
                if ($msg != null) {
                    $var = $choice = $field->getName() . '-error';
                    $template->setChoice($choice);
                    $el = $domForm->getFormElement($name);
                    if ($el == null) {
                        throw new Dk_ExceptionNullPointer('No form element: `' . $name . '` found. Check your validation field name parameters.');
                    }
                    $node = $el->getNode();
                    if ($node->parentNode && (strstr($node->parentNode->getAttribute('class'), 'required') ||
                            $node->parentNode->getAttribute('class') == 'optional'))
                    {
                        $node->parentNode->setAttribute('class', $node->parentNode->getAttribute('class') . ' error');
                    }
                    if ($template->keyExists('var', $var)) {
                        if ($template->getText($var) == null) {
                            $template->replaceHTML($var, $msg);
                        }
                    }
                    $hasErrors = true;
                }
            }
        }
        return $hasErrors;
    }
}
?>
