<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * Base class for all Dk exceptions.
 * 
 * @package Exception
 */
class Dk_Exception extends Exception 
{
    /**
     * @var string
     */
    private $dump = '';
    
    
    /**
     * redefine the constructor, make the message required
     *
     * @param string $message
     * @param integer $code
     */
    function __construct($message, $code = 0) 
    {
        parent::__construct($message, $code);
    }
    
    /**
     * Set the dump test.
     *
     * @param string $dump
     */
    function setDump($dump)
    {
        $this->dump = $dump;
    }
    
    /**
     * Redefine if toString()
     *
     * @return string
     */
    function __toString($hideTrace = false) 
    {
        $str = '';
        if (isset($_SERVER['REQUEST_URI'])) {
            $str .= "Request URI: " . $_SERVER['REQUEST_URI'] . "\n";
        }
        if (isset($_SERVER['HTTP_REFERER'])) {
            $str .= "Referrer: " . $_SERVER['HTTP_REFERER'] . "\n";
        }
        if (isset($_SERVER['SERVER_NAME']) && isset($_SERVER['SERVER_ADDR'])) {
            $str .= "Server: " . 
                ($_SERVER['SERVER_NAME'] != '' ? $_SERVER['SERVER_NAME'] : $_SERVER['SERVER_ADDR']) . "\n";
        }
        if (isset($_SERVER['HTTP_USER_AGENT'])) {
            $str .= "User Agent: " . $_SERVER['HTTP_USER_AGENT'] . "\n";
        }
        if (isset($_SERVER['REMOTE_ADDR'])) {
            $str .= "Client: " . $_SERVER['REMOTE_ADDR'] . "\n";
        }
        $str .= "\nLocation: " . $this->getFile() ."(".$this->getLine().")" . "\n";
        $str .= "Exception: '". get_class($this) . "' [{$this->code}]: ";
        if ($this->message != null) {
            $str .= $this->message . "\n\n";
        }
        if (!$hideTrace) {
            if ($this->dump != null) {
                $str .= $this->dump . "\n\n";
            }
            $str .= $this->getTraceAsString() . "\n";
        }
        return $str;
    }
}

/**
 * RuntimeException is the superclass of those exceptions that can be thrown
 * during normal operation.
 *
 * @package Exception
 */
class Dk_ExceptionRuntime extends Dk_Exception { }

/**
 * An Illegal Argument Exception.
 *
 * Thrown to indicate that a method has been passed an illegal or 
 * inappropriate argument.
 * @package Exception
 */
class Dk_ExceptionIllegalArgument extends Dk_ExceptionRuntime { }

/**
 * Thrown to indicate that an index of some sort of variable is out of range.
 *   (Such as to an array, to a string, or to a vector)
 * 
 * @package Exception
 */
class Dk_ExceptionIndexOutOfBounds extends Dk_ExceptionRuntime { }


/**
 * Thrown to indicate that an index of some sort of variable is out of range.
 *   (Such as to an array, to a string, or to a vector)
 * 
 * @package Exception
 */
class Dk_ExceptionNullPointer extends Dk_ExceptionRuntime { }



/**
 * RuntimeException is the superclass of those exceptions that can be thrown
 * during normal operation.
 *
 * @package Exception
 */
class Dk_ExceptionLogic extends Dk_Exception { }

/**
 * Thrown if an error occurs when processing a dom template object
 *
 * @package Exception
 */
class Dk_ExceptionDomTemplate extends Dk_ExceptionLogic { }

/**
 * SqlException, Thrown for all database errors
 * 
 * @package Exception
 */
class Dk_ExceptionSql extends Dk_ExceptionRuntime
{
}
?>
