<?php
/*
 * WdkLib - Tropotek Web Development Library.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2005 Michael Mifsud
 */

/**
 * The base order by mapper object that controls 
 *   the mapping of orderd database objects.
 *
 * @package Db
 */
class Dk_Db_OrderMapper extends Dk_Db_Mapper
{


    /**
     * Insert this new object into the database
     *
     * @return integer
     */
    function insert($obj)
    {
        $id = parent::insert($obj);
        $this->updateValue($id, 'orderBy', $id);
        return $id;
    }

    /**
     * Swap the order of 2 records
     *
     * @param Dk_Object $fromObj
     * @param Dk_Object $toObj
     */
    function orderSwap($fromObj, $toObj)
    {
        $idFields = $this->getMapper()->getDataMap()->getIdColumns();
        $idField = current($idFields);
        
        $query = sprintf("UPDATE `%s` SET `orderBy` = '%s' WHERE `%s` = %d",
                 $this->getTable(), $toObj->getOrderBy(),
                 $idField->getColumnName(), $fromObj->getId());
        $this->getDb()->query($query);
        $query = sprintf("UPDATE `%s` SET `orderBy` = '%s' WHERE `%s` = %d",
                 $this->getTable(), $fromObj->getOrderBy(),
                 $idField->getColumnName(), $toObj->getId());
        $this->getDb()->query($query);
        
        return $this->getDb()->getAffectedRows();
    }

    /**
     * Reset the order values to id values.
     *
     */
    function resetOrder()
    {
        $query = sprintf("UPDATE `%s` SET `orderBy` = `id`", $this->getTable());
        $this->getDb()->query($query);
        return $this->getDb()->getAffectedRows();
    }

}
?>