<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */


/**
 * This is a base DB object usful for mapper functionality
 * to DB classes.
 * 
 * @package Db
 */
abstract class Dk_Db_Object extends Dk_Object 
{
    
    /**
     * Insert the object into storage.
     * By default this is a database
     *
     * @return integer The object insert ID
     */
    function insert()
    {
        return $this->getDbMapper()->insert($this);
    }
    
    /**
     * Update the object in storage
     * By default this is a database
     *
     * @return integer
     */
    function update()
    {
        return $this->getDbMapper()->update($this);
    }
    
    
    /**
     * Update the object in storage
     * By default this is a database
     *
     * @return integer
     */
    function delete()
    {
        return $this->getDbMapper()->delete($this);
    }
    
    /**
     * Returns the object id if it is greater than 0 or the nextInsertId if is 0
     *
     * @return integer
     */
    function getVolitileId()
    {
        return $this->getDbMapper()->getVolitileId($this);
    }
    
    

    /**
     * Get the object's DB mapper
     *
     * @return Dk_Db_Mapper
     * @deprecated Will be removed in Ver 2.0
     */
    function getMapper()
    {
        return $this->getDbMapper();
    }
    
    /**
     * Get the object's DB mapper
     *
     * @return Dk_Db_Mapper
     */
    function getDbMapper()
    {
        return Dk_Db_ObjectFactory::getDbMapper($this);
    }
}
?>
