<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 *  Holds MySQL Results from a query.
 * 
 * <code>
 * <?php
 *   $result = $db->query($sql);
 *   while($row = $result->getRow()) {
 *       foreach($row as $k => $e) {
 *           echo $e.", ";
 *       }
 *   }
 * ?>
 * </code>
 * 
 * @package Db
 */
class Dk_Db_MyResult implements Dk_Db_ResultInterface
{
    
    /**
     * @var Dk_Db_MyDao
     */
    private $db = null;
    
    /**
     * @var resource
     */
    private $queryRes = null;

    /**
     * @var integer
     */
    private $idx = 0;
    
    /**
     * @var boolean
     */
    private $isValid = true;
    
    /**
     * @var integer
     */
    private $total = 0;
    
    
    
    /**
     * __construct
     * 
     * @param Dk_Db_MyDao $da
     * @param resource $query
     * @param integer $total 
     */
    function __construct(Dk_Db_MyDao $db, $queryRes, $total = null) 
    {
        $this->db = $db;
        $this->queryRes = $queryRes;
        $this->total = $total;
        if ($this->total === null && is_resource($this->queryRes)) {
            $this->total = $this->count();
        }
    }
    
    /**
     * Reset/clear this result esouce fom memory
     *
     */
    function free() 
    {
        mysql_free_result($this->queryRes);
        $this->isValid = false;
        $this->queryRes = null;
        $this->idx = 0;
        $this->total = 0;
    }
    
    /**
     * Get the total posible results from this query
     *
     */
    function getTotal() 
    {
        return $this->total;
    }
    
    /**
     * Return the current result 
     * 
     * @return array
     */
    function current() 
    {
        if ($this->idx >= $this->count()) {
            $this->isValid = false;
            return false;
        }
        mysql_data_seek($this->queryRes, $this->idx);
        $row = mysql_fetch_assoc($this->queryRes);
        if (!$row) {
            if ($this->db->getError()) {
                throw new Dk_ExceptionSql($this->db->getError());
            }
            $this->isValid = false;
            return false;
        }
        return $row;
    }
    
    /**
     * Get the key value for the current result
     *
     * @return integer
     */
    function key() 
    {
        return $this->idx;
    }
    
    /**
     * return the next result, if first call, returns the first result.
     *
     * @return array
     */
    function next() 
    {
        $this->idx++;
    }
    
    /**
     * Rewind the internal pointer
     * 
     * @todo Use the offset value...
     */
    function rewind() 
    {
        $this->isValid = ($this->count() > 0);
        $this->idx = 0;
    }
    
    /**
     * Returns false if no errors or returns a MySQL error message.
     * 
     * @return boolean Returns false if there are no error messages.
     */
    function valid() 
    {
        return ($this->idx < $this->count());
    }
    
     
    /**
     * Returns the number of rows in result set.
     * 
     * @return int
     */
    function count() 
    {
        $rows = mysql_num_rows($this->queryRes);
        if ($rows === false) {
            throw new Dk_ExceptionSql($this->db->getError());
        }
        return $rows;
    }
}
?>