<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * Base data access object for MySQL database.<br>
 *
 * usage:<br>
 * <code>
 * <?php
 *   $db = new Dk_Db_MyDao('user', 'pass', 'db', 'host');
 *   $sql = "SELECT * FROM table";
 *   $result = $db->query($sql);
 *   while($row = $result->getRow()) {
 *       foreach($row as $k => $e) {
 *           echo $e.", ";
 *       }
 *   }
 * ?>
 * </code>
 *
 * @package Db
 */
class Dk_Db_MyDao implements Dk_Db_DaoInterface
{

    /**
     * This holds a php database resource returned by mysql_pconnect()
     *
     * @var resource $db
     */
    private $db = null;
    
    private $dbName = '';
    
    /**
     *
     *
     * @param string $user The db server user
     * @param string $pass The db server user password
     * @param string $dbName The database name
     * @param string $host (optional)The hostname for db server, default = 'localhost
     * @throws Dk_Db_ExceptionSql
     */
    function __construct($user, $pass, $dbName, $host = 'localhost')
    {
        if(!$this->db = mysql_connect($host,$user,$pass) ) {
            throw new Dk_ExceptionSql("Could not connect to database server.");
        }
        $this->selectDb($dbName);
    }

    /**
     * Clean up database.
     *
     */
    function __destruct()
    {
        mysql_close($this->db);
    }

    /**
     * For SELECT queries.
     *
     * @param string $sql The SQL query string.
     * @return Dk_Db_MyResult
     * @throws Dk_Db_ExceptionSql
     */
    function query($sql)
    {
        $total = null;
        if (eregi('^SELECT', $sql)) {
            $cSql = ereg_replace('(LIMIT [0-9]+(( )?, [0-9]+)?)?', '', $sql); 
            $countSql = "SELECT COUNT(*) as i FROM ($cSql) as t";
            $res = mysql_query($countSql, $this->db);
            if ($res) {
                $row = mysql_fetch_assoc($res);
                $total = $row['i'];
            }
        }
        
        $queryResource = mysql_query($sql, $this->db);
        if (!$queryResource) {
            $e = new Dk_ExceptionSql($this->getError());
            $e->setDump($sql);
            throw $e;
        }
        
        $result = new Dk_Db_MyResult($this, $queryResource, $total);
        return $result;
    }

    
    /**
     * Execute multiple queries in one string
     *
     * @param string $sqlString
     * @return Dk_Db_MyResult[]
     */
    function multiQuery($sqlString)
    {
        $resultList = array();
        $sqlString = preg_replace("(--.*)", '', $sqlString);
        //$queryList = explode( ";", $sqlString );
        $queryList = preg_split('/\.*;\s*\n\s*/', $sqlString);
        vd($queryList);
        
        if (!is_array($queryList) || count($queryList) == 0) {
            throw new Dk_ExceptionSql('Invalid sql data.');
        }
        foreach ($queryList as $query) {
          $query = trim($query);
          if (!$query) {
              continue;
          }
          $resultList[] = $this->query($query);
        }
        return $resultList;
    }
    
    /**
     * Get an array containing all the table names for this DB
     *
     * @return array
     */
    function getTableList()
    {
        $sql = "SHOW TABLES";
        $result = $this->query($sql);
        $list = array();
        foreach ($result as $row) {
            $list[] = $row['Tables_in_' . $this->getDbName()];
        }
        return $list;
    }
    
    
    /**
     * Select a new Db
     *
     * @param string $dbName
     */
    function selectDb($dbName)
    {
        if(!mysql_select_db($dbName, $this->db) ) {
            throw new Dk_ExceptionSql("Could not find database: '$dbName'.");
        }
        $this->dbName = $dbName;
    }
    
    /**
     * Get the current selected DB name
     *
     * @return string
     */
    function getDbName()
    {
        return $this->dbName;
    }

    /**
     * Get the ID generated from the previous INSERT opertation
     *
     * @return integer
     */
    function getInsertID()
    {
        return mysql_insert_id($this->db);
    }

    /**
     * Get the number of modified rows with last query.
     * NOTE:
     *   Not always correct due to mysql update bug/feature
     *
     * @return integer
     */
    function getAffectedRows()
    {
        return mysql_affected_rows($this->db);
    }

    /**
     * Get any MySQL errors.
     *
     * @return string Returns a MySQL server error
     */
    function getError()
    {
        return mysql_error($this->db);
    }

    /**
     * Encode characters to avoid sql injections.
     *
     * @param string $str
     */
    static function escapeString($str)
    {
        $str = mysql_real_escape_string($str, Dk_Db_ObjectFactory::getDb()->db);
        return $str;
    }
}
?>