<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * Data Access Object Interface
 * 
 * 
 * @package Db
 */
interface Dk_Db_DaoInterface
{
    
    /**
     * For SQL queries.
     * 
     * @param string $sql
     * @return Dk_Db_ResultInterface
     */
    function query($sql);
    
    /** 
     * Get the insert id of the last added record.
     * 
     * @return integer 
     */
    function getInsertID();
    
    /**
     * Return the number of modified rows with last query.
     * 
     * @return integer
     */
    function getAffectedRows();
    
    /**
     * Returns any SQL errors.
     * 
     * @return string
     */
    function getError();
    
    /**
     * Encode quote characters, make strings safe from sql injection.
     *
     * @param string $str
     */
    static function escapeString($str);
    
}
?>