<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @author Darryl Ross <darryl.ross@aot.com.au>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * A wrapper around a PHP array.
 *
 * @package Util
 */
class Dk_Db_Array extends ArrayObject 
{
    
    /**
     * @var Dk_Util_Loo
     */
    private $loo = 0;
    
    /**
     * @var integer
     */
    private $total = 0;
    
    
    
    /**
     * Set the loo (limit, offset, orderBy) object
     *
     * @param Dk_Util_Loo $loo
     */
    function setLoo(Dk_Util_Loo $loo)
    {
        $this->loo = $loo;
    }
    
    /**
     * Get the loo (limit, offset, orderBy) object
     *
     * @return Dk_Util_Loo
     */
    function getLoo()
    {
        return $this->loo;
    }
    
    
    
    /**
     * Get the total possible row count for a query with no limits
     *
     * @param integer $i
     */
    function setTotal($i)
    {
        $this->total = intval($i);
    }
    
    /**
     * Get the total possible row count for a query with no limits
     *
     * @return integer
     */
    function getTotal()
    {
        return $this->total;
    }
    
    /**
     * return the first object on the list or null
     * 
     * @return mixed
     */
    function getFirst()
    {
        if (isset($this[0])) {
            return $this[0];
        }
    }
    
}
?>
