<?php
require_once(dirname(__FILE__) . '/prepend.php');
?>
<html><!-- InstanceBegin template="/Templates/install.dwt.php" codeOutsideHTMLIsLocked="false" -->
<head>
  <title>DkWiki Installer</title>
  
  <script type="text/javascript" src="../lib/Jdk/_prepend.js"></script>
  <script type="text/javascript" src="../lib/Jdk/plugins/jquery.flash.js"></script>
  <link rel="stylesheet" type="text/css" href="media/base.css" />

  <!-- InstanceBeginEditable name="head" --><!-- InstanceEndEditable -->
</head>
<body> 
  
  <div id="container">
    
    <div id="header"> 
      <h1>DkWiki Installer</h1>
      <div class="advert">
        <script type="text/javascript" src="../js/advertBox.js" id="advertBox"></script>
      </div>
      <div class="clear" />
    </div> 
    
    <div id="wrapper">
      <div id="content">
      <!-- InstanceBeginEditable name="content" -->
      
      <div choice="error">
        <p class="error" var="ex">Upgrade Error: Cannot upgrade. Please upgrade manually, see the README file.</p>
        <button onClick="window.open('../index.html', '_blank');">Launch DkWiki</button>
      </div>
      
      <div choice="noError">
      
        <p>
          Previous Version: <span var="fromVer" /> <br/>
          New Version: <span var="toVer" />
        </p>  
        
        <p class="uComplete">Ugrade Complete!</p>
        
        <p><button onClick="window.location.href='index4.php';">Finish</button></p>
      
      </div>
      <!-- InstanceEndEditable -->
      </div>
    </div>
    <div id="navigation"></div>
    <div id="extra"></div>
    <div id="footer">
      <p class="copyright">
        <a href="http://www.domtemplate.com/" title="domtemplate.com" target="_blank">DkWiki</a> <br/>
        <a href="http://www.domtemplate.com/" title="domtemplate.com" target="_blank">Copyright &#169; 2009 Tropotek</a>
      </p>
    </div>
  </div>  

</body>
<!-- InstanceEnd --></html>
<?php
// Create a template from the html in the buffer
$buff = ob_get_clean();
$template = Dom_Template::loadXml($buff);

try {
    $fromVer = getFromVer();
    $toVer = getToVer();
    $template->replaceText('fromVer', $fromVer);
    $template->replaceText('toVer', $toVer);
    if ($fromVer > $toVer) {
        throw new Dk_ExceptionRuntime("Version Conflict. You are trying to install an older version. ($fromVer => $toVer)");
    }
    if ($fromVer == $toVer) {
        throw new Dk_ExceptionRuntime("No Upgrade required. ($fromVer => $toVer)");
    }
    
    upgrade($fromVer, $toVer);
    
    $template->setChoice('noError');
} catch (Exception  $e) {
    $template->setChoice('error');
    $template->replaceText('ex', $e->getMessage());
}

echo $template->toString('html');

/** FUNCTIONS */

function getFromVer()
{ 
    try {
        $db = Dk_Db_ObjectFactory::getDb();
        $list = $db->getTableList();
        if (!in_array('user', $list)) {
            return '1.1';
        }
        if (!in_array('version', $list)) {
            return '1.2';
        }
        if (in_array('version', $list)) {
            $sql = "SELECT * FROM `version` ORDER BY `id` DESC LIMIT 0, 1";
            $result = $db->query($sql);
            $row = $result->current();
            if (!$row || count($row) == 0) {
                throw new Dk_ExceptionRuntime();
            }
            return $row['version'];
        }
    } catch (Exception $e) {}
    throw new Dk_ExceptionRuntime('Cannot check previous DkWiki Version. Check your config.ini DB details.');
}

function getToVer()
{
    $file = Dk_Config::getInstance()->getFileRoot() . '/VERSION';
    if (!is_file($file)) {
        throw new Dk_ExceptionRuntime('Cannot detect current version. Please upgrade manually.');
    }
    $buf = file_get_contents($file);
    return trim($buf);
}

function upgrade($fromVer, $toVer) 
{
    $list = scandir(Dk_Config::getInstance()->getFileRoot() . '/lib/Ext/sql');
    $uList = array();
    foreach ($list as $file) {
        if (!ereg('^(upgrade-)', $file)) {
            continue;
        }
        $ver = getVerFromName($file);
        $uList[$ver] = $file;
    }
    
    // locate the position in the uList of the previouse version record
    if (array_key_exists($fromVer, $uList)) {
        foreach ($uList as $k => $v) {
            array_shift($uList);
            if ($k == $fromVer) {
                break;
            }
        }
    }
    $db = Dk_Db_ObjectFactory::getDb();
    foreach ($uList as $file) {
        $buff = file_get_contents(Dk_Config::getInstance()->getFileRoot() . '/lib/Ext/sql/'  . $file);
        $db->multiQuery($buff);
    }
}

/**
 * Get the version from the sql filename
 *
 * @param string $sqlFile
 * @return string
 */
function getVerFromName($sqlFile)
{
    $sqlFile = str_replace('_', '.', $sqlFile);
    $start = strpos($sqlFile, '-') +1;
    $end = strrpos($sqlFile, '.');
    if ($start === false || $end === false) {
        throw new Dk_ExceptionRuntime('Cannot get Sql upgrade version files');
    }
    return substr($sqlFile, $start, $end-$start);
}
?>