<?php
require_once(dirname(__FILE__) . '/prepend.php');
?>
<html><!-- InstanceBegin template="/Templates/install.dwt.php" codeOutsideHTMLIsLocked="false" -->
<head>
  <title>DkWiki Installer</title>
  
  <script type="text/javascript" src="../lib/Jdk/_prepend.js"></script>
  <script type="text/javascript" src="../lib/Jdk/plugins/jquery.flash.js"></script>
  <link rel="stylesheet" type="text/css" href="media/base.css" />

  <!-- InstanceBeginEditable name="head" --><!-- InstanceEndEditable -->
</head>
<body> 
  
  <div id="container">
    
    <div id="header"> 
      <h1>DkWiki Installer</h1>
      <div class="advert">
        <script type="text/javascript" src="../js/advertBox.js" id="advertBox"></script>
      </div>
      <div class="clear" />
    </div> 
    
    <div id="wrapper">
      <div id="content">
      <!-- InstanceBeginEditable name="content" -->
      
      <p>
        Fill in the fields below to configure your new DkWiki installation.
      </p>
			
      <form id="install" method="post" autocomplete="off">
      
        <h3>Config Options</h3>
        
        <p class="error" choice="form-error" var="form-error"></p>
        
        <h4>Admin User:</h4>
        <div class="block">
          
          <div class="req">
            <p class="error" choice="adminEmail-error" var="adminEmail-error">Invalid email address.</p>
            <label for="fid-adminEmail">Email:</label> 
            <input type="text" id="fid-adminEmail" name="adminEmail" value="email@example.com" />
          </div>
          
          <div class="req">
            <p class="error" choice="adminUser-error" var="adminUser-error">Invalid username.</p>
            <label for="fid-adminUser">Username:</label> 
            <input type="text" name="adminUser" id="fid-adminUser" value="admin"/>
					</div>
          <div class="req">          
            <p class="error" choice="adminPass-error" var="adminPass-error">Invalid password.</p>
            <label for="fid-adminPass">Password:</label> 
            <input type="password" id="fid-adminPass" name="adminPass" />
          </div>
          
          <div class="clear" />
        </div>
        
        <h4>Database:</h4>
        <p class="error" choice="DbHost-error" var="DbHost-error">Cannot connect to Database.</p>
        <div class="block">
          <div class="req">
            <label for="fid-DbHost">Host:</label> 
            <input type="text" name="DbHost" id="fid-DbHost" value="localhost"/>
          </div>
          <div class="req">
            <label for="fid-DbDatabase">Database:</label> 
            <input type="text" id="fid-DbDatabase" name="DbDatabase" />
          </div>
          <div class="req">
            <label for="fid-DbUser">Username:</label> 
            <input type="text" id="fid-DbUser" name="DbUser" />
          </div>
          <div class="req">
            <label for="fid-DbPassword">Password:</label> 
            <input type="password" id="fid-DbPassword" name="DbPassword" />
          </div>
          
          <div class="clear" />
        </div>
        
        <div class="submit">
          <input type="submit" name="process" value="Install" />
        </div>
      
      </form>
      
      
      <!-- InstanceEndEditable -->
      </div>
    </div>
    <div id="navigation"></div>
    <div id="extra"></div>
    <div id="footer">
      <p class="copyright">
        <a href="http://www.domtemplate.com/" title="domtemplate.com" target="_blank">DkWiki</a> <br/>
        <a href="http://www.domtemplate.com/" title="domtemplate.com" target="_blank">Copyright &#169; 2009 Tropotek</a>
      </p>
    </div>
  </div>  

</body>
<!-- InstanceEnd --></html>
<?php
// Create a template from the html in the buffer
$buff = ob_get_clean();
$template = Dom_Template::loadXml($buff);

$form = new Dk_Form_Object('install');
$form->addField('adminEmail');
$form->addField('adminUser');
$form->addField('adminPass');
$form->addField('DbHost');
$form->addField('DbDatabase');
$form->addField('DbUser');
$form->addField('DbPassword');
$form->loadFromObject($config);

if (!$config->getDbHost()) {
    $form->setFieldValue('DbHost', 'localhost');
}

if ($request->exists('process')) {
    $form->loadFromRequest();
    $form->loadObject($config);
    
    // Validate form information
    try {
        $db = Dk_Db_ObjectFactory::getDb();
    } catch (Exception $e) { 
        $form->addFieldError('DbHost', 'Cannot Connect To Database');
    }
    if (!ereg(Dk_Util_Validator::POSIX_EMAIL, $form->getFieldValue('adminEmail'))) {
        $form->addFieldError('adminEmail', 'Invalid Email');
    }
    if (!ereg('^[a-zA-Z0-9_\.@-]{3,64}$', $form->getFieldValue('adminUser'))) {
        $form->addFieldError('adminUser', 'Invalid Username (4-16 Alpha Numeric Chars)');
    }
    if (!eregi('^[a-zA-Z0-9_\. @-]{4,64}$', $form->getFieldValue('adminPass'))) {
        $form->addFieldError('adminPass', 'Invalid Password (4-16 Alpha Numeric Chars)');
    }
    if (!$form->hasErrors()) {
        try {
            install($form);
            $url = new Dk_Util_Url('/install/index4.php');
            $url->redirect();
        } catch (Exception $e) {
            // TODO: uninstall any executed sql
            $form->addError($e->getMessage());
            $form->addError('Unknown install error, try different install values. <br/>Make sure you database does not have conflicting table names.');
        }
    }
}

$formRenderer = new Dk_Form_Renderer($form);
$formRenderer->show($template);

echo $template->toString('html');


/**
 * install
 *
 * @param Dk_Form_Object $form
 */
function install($form)
{
    global $config;
    
    // write new config.ini
    $configFile = $config->getDataDir() . '/config.ini';
    $buff = "; This file is auto configured don't bother editing it. ";
    $buff .= "\n; Create one in the site root and edit that.";
    $buff .= "\n; ";
    $buff .= "\nDbHost       = " . $form->getFieldValue("DbHost");
    $buff .= "\nDbDatabase   = " . $form->getFieldValue("DbDatabase");
    $buff .= "\nDbUser       = " . $form->getFieldValue("DbUser");
    $buff .= "\nDbPassword   = " . $form->getFieldValue("DbPassword");
    file_put_contents($configFile, $buff);
    
    // install SQL
    $db = Dk_Db_ObjectFactory::getDb();
    $installFile = $config->getFileRoot() . '/lib/Ext/sql/install.sql';
    $sql = file_get_contents($installFile);
    $db->multiQuery($sql);
		
    // install-data SQL
    $dataFile = $config->getFileRoot() . '/lib/Ext/sql/install-data.sql';
    $sql = file_get_contents($dataFile);
    $sql = str_replace("'admin@example.com'", enquote($form->getFieldValue('adminEmail')), $sql);
    $sql = str_replace("'admin'", enquote($form->getFieldValue('adminUser')), $sql);
    $sql = str_replace("'password'", enquote($form->getFieldValue('adminPass')), $sql);
    $db->multiQuery($sql);
    
    return true;
}

?>