<?php
require_once(dirname(__FILE__) . '/prepend.php');
?>
<html><!-- InstanceBegin template="/Templates/install.dwt.php" codeOutsideHTMLIsLocked="false" -->
<head>
  <title>DkWiki Installer</title>
  
  <script type="text/javascript" src="../lib/Jdk/_prepend.js"></script>
  <script type="text/javascript" src="../lib/Jdk/plugins/jquery.flash.js"></script>
  <link rel="stylesheet" type="text/css" href="media/base.css" />

  <!-- InstanceBeginEditable name="head" --><!-- InstanceEndEditable -->
</head>
<body> 
  
  <div id="container">
    
    <div id="header"> 
      <h1>DkWiki Installer</h1>
      <div class="advert">
        <script type="text/javascript" src="../js/advertBox.js" id="advertBox"></script>
      </div>
      <div class="clear" />
    </div> 
    
    <div id="wrapper">
      <div id="content">
      <!-- InstanceBeginEditable name="content" -->
  <p>
    Thank you for choosing DkWiki. The following pages
    will guide you through the setup process. 
  </p>

  <div choice="statusFail">
    <h3>Preperation</h3>
    
    <p>
      Before you begin the installation process make sure you
      have done the following steps.
    </p>
    
    <ol>
      <li>Ensure the /data directory is writable:
    <pre>
    # cd /{project-path}/
    # chmod -R ugo+rw data
    </pre>
      </li>
      <li>If this is your first install create a new .htaccess file.
    <pre>
    # cd /{project-path}/
    # cp .htaccess.in .htaccess
    </pre>
      </li>
      <li>Have your database login details on hand.</li>
    </ol>
  </div>
  
<h3>Checking Requirements</h3>

<div>
  <div class="row">
    <div class="cell label">/data</div>
    <div class="cell" var="status1">OK</div>
  </div>
  <div class="row">
    <div class="cell label">/.htaccess</div>
    <div class="cell" var="status2">OK</div>
  </div>
  <div class="row">
    <div class="cell label">Linux <span var="s3" /></div>
    <div class="cell" var="status3">OK</div>
  </div>
  <div class="row">
    <div class="cell label">PHP5  <span var="s4" /></div>
    <div class="cell" var="status4">OK</div>
  </div>
  <div class="row">
    <div class="cell label">Apache (mod_rewrite)</div>
    <div class="cell" var="status5">OK</div>
  </div>
  <div class="clear" />
</div>
<div choice="statusFail">
  <div class="refresh"><button onClick="history.go(0)">Refresh</button></div>
</div>

<div choice="statusOK" class="license">
<form method="post" id="install">

<table border="0" width="400">
  <tr>
    <td>
      <textarea name="license" id="fid-license" readonly="readonly" rows="10" cols="80"> </textarea>
    </td>
  </tr>
  <tr>
    <td>
      <input type="checkbox" name="agree" id="fid-agree" onClick="document.getElementById('fid-install').disabled = !this.checked;" choice="install"/>
      <label for="fid-agree" choice="install">By clicking this you agree to the GPL license.</label>
      <input type="checkbox" name="agree" id="fid-agree" onClick="document.getElementById('fid-upgrade').disabled = !this.checked;" choice="upgrade"/>
      <label for="fid-agree" choice="upgrade">By clicking this you agree to the GPL license.</label>
    </td>
  </tr>
  <tr>
    <td style="text-align: right;padding-right: 50px;">
      <input type="submit" name="install" value="Install" id="fid-install" disabled="disabled" choice="install" />
      <input type="submit" name="upgrade" value="Upgrade" id="fid-upgrade" disabled="disabled" choice="upgrade"/>
      <button onClick="window.open('../index.html', '_blank');" choice="installed">Launch DkWiki</button>
    </td>
  </tr>
</table>

</form>


</div>
      <!-- InstanceEndEditable -->
      </div>
    </div>
    <div id="navigation"></div>
    <div id="extra"></div>
    <div id="footer">
      <p class="copyright">
        <a href="http://www.domtemplate.com/" title="domtemplate.com" target="_blank">DkWiki</a> <br/>
        <a href="http://www.domtemplate.com/" title="domtemplate.com" target="_blank">Copyright &#169; 2009 Tropotek</a>
      </p>
    </div>
  </div>  

</body>
<!-- InstanceEnd --></html>
<?php
// Create a template from the html in the buffer
$buff = ob_get_clean();
$template = Dom_Template::loadXml($buff);

$domForm = $template->getForm('install');
$domForm->setAction($request->getRequestUri());

if ($request->exists('install')) {
    $url = new Dk_Util_Url('/install/index2-1.php');
    $url->redirect();
} else if ($request->exists('upgrade')) {
    $url = new Dk_Util_Url('/install/index3-1.php');
    $url->redirect();
}


$license = file_get_contents($rootPath . '/LICENSE');
$el = $domForm->getFormElement('license');
$el->setValue($license);

$statusOK = true;
if (is_writable($dataDir)) {
    $template->replaceText('status1', 'OK');
    $template->replaceAttr('status1', 'class', $template->getAttr('status1', 'class') . ' ok');
} else {
    $template->replaceText('status1', 'FAIL');
    $template->replaceAttr('status1', 'class', $template->getAttr('status1', 'class') . ' fail');
    $statusOK = false;
}

if (is_file($rootPath . '/.htaccess')) {
    $template->replaceText('status2', 'OK');
    $template->replaceAttr('status2', 'class', $template->getAttr('status2', 'class') . ' ok');
} else {
    $template->replaceText('status2', 'FAIL');
    $template->replaceAttr('status2', 'class', $template->getAttr('status2', 'class') . ' fail');
    $statusOK = false;
}

$template->replaceText('s3', '(' . PHP_OS . ')');
if (PHP_OS != 'win') {
    $template->replaceText('status3', 'OK');
    $template->replaceAttr('status3', 'class', $template->getAttr('status3', 'class') . ' ok');
} else {
    $template->replaceText('status3', 'FAIL');
    $template->replaceAttr('status3', 'class', $template->getAttr('status3', 'class') . ' fail');
    $statusOK = false;
}

$ver = PHP_VERSION;
$pos = strpos($ver, '-');
if ($pos !== false) {
    $ver = substr($ver, 0, $pos);
}
$template->replaceText('s4', '(' . $ver . ')');
if ($ver >= '5') {
    $template->replaceText('status4', 'OK');
    $template->replaceAttr('status4', 'class', $template->getAttr('status4', 'class') . ' ok');
} else {
    $template->replaceText('status4', 'FAIL');
    $template->replaceAttr('status4', 'class', $template->getAttr('status4', 'class') . ' fail');
    $statusOK = false;
}


$mods = apache_get_modules();
if (in_array('mod_rewrite', $mods)) {
    $template->replaceText('status5', 'OK');
    $template->replaceAttr('status5', 'class', $template->getAttr('status5', 'class') . ' ok');
} else {
    $template->replaceText('status5', 'FAIL');
    $template->replaceAttr('status5', 'class', $template->getAttr('status5', 'class') . ' fail');
    $statusOK = false;
}


if ($statusOK) {
    $template->setChoice('statusOK');
} else {
    $template->setChoice('statusFail');
}

$url = $request->getRequestUri();
$template->replaceAttr('refresh', 'href', $url->toString());

// check if we are upgrading or if it is a new install 
$installed = false;
$verEq = false;
try {
    $db = Dk_Db_ObjectFactory::getDb();
    $sql = "SELECT * FROM `page` LIMIT 0, 1";
    $db->query($sql);
		$installed = true;
		
		$sql = "SELECT * FROM `version` ORDER BY `id` DESC LIMIT 0, 1";
		$result = $db->query($sql);
		$row = $result->current();
		if (!$row || count($row) == 0) {
				throw new Dk_ExceptionRuntime();
		}
		if ($row['version'] == trim(file_get_contents(Dk_Config::getInstance()->getFileRoot() . '/VERSION'))) {
		    $verEq = true;
		}
} catch (Exception $e) { }

if ($installed) {
    if ($verEq) {
		    $template->setChoice('installed');
		} else {
        $template->setChoice('upgrade');
	  }
} else {
    $template->setChoice('install');
}

echo $template->toString('html');
?>