<?php
$rootPath = dirname(__FILE__);
$libPath = $rootPath.'/lib';
ini_set('include_path', $libPath . (stristr(PHP_OS, "Win") ? ';' : ':') . ini_get('include_path'));
require_once('Ext/_prepend.php');
$dataDir = $config->getDataDir();

// User Config
if (is_file($dataDir.'/config.ini')) {
    $config->parseConfigFile($dataDir.'/config.ini');
}

// System Config
if (is_file($rootPath.'/config.ini')) {
    $config->parseConfigFile($rootPath.'/config.ini');
}

if (is_file(dirname(__FILE__) . '/prepend.php')) {
    include_once(dirname(__FILE__) . '/prepend.php');
}

$resourceMapper = new Ext_Web_ResourceMapper(new Dk_Util_Path($config->getHtmlTemplates()));
$controller = new Ext_Web_FrontController($resourceMapper);
$controller->addController(new Ext_Modules_User_FrontController());
$controller->execute();

?>