<?php
if (!isset($_REQUEST['sid'])) {
  throw new RuntimeException('Invalid Session Name ID');
}

$fileRoot = realpath(dirname(__FILE__).'/../../../../');
if (isset($_SESSION['mce-params']) && is_readable($_SESSION['mce-params']['FileRoot'])) {
    $fileRoot = $_SESSION['mce-params']['FileRoot'];
}
$libDir = $fileRoot.'/lib';
ini_set('include_path', $libDir.':'.ini_get('include_path'));

require_once("Dk/Functions/autoLoad.php");
$session = Dk_Session::getInstance($_REQUEST['sid']);
include('Dk/_prepend.php');

if(is_file($fileRoot.'/data/config.ini')) {
    $config->parseConfigFile($fileRoot.'/data/config.ini');
}
if(is_file($fileRoot.'/config.ini')) {
    $config->parseConfigFile($fileRoot.'/config.ini');
}


ob_start();

//*********//

$settings = $session->getParameter('mce-params');
if ($settings == null) {
    throw new Exception("No valid Session Data for the file manager exists.");
}

/* @var $sessionData Jdk_TinyMce_SessionData */
Dk_Util_Url::$pathPrefix = $settings['HtdocRoot'];
Dk_Util_Path::$pathPrefix = $settings['FileRoot'];


?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>

	<title>Find Wiki Page</title>
  <link rel="stylesheet" type="text/css" media="all" href="css/style.css" />
	<script type="text/javascript" src="../../tiny_mce_popup.js"></script>
	<script type="text/javascript" src="js/dialog.js"></script>
    
<style type="text/css">
th {
  text-align: center;
  padding: 1px 20px;
}
td {
  padding: 1px 4px;
}
td.modified {
  white-space: nowrap;
  text-align: right;
}


.Ui_Db_Pager {
  margin: 5px 0px;
  padding: 2px 10px 2px 10px;
  font-size: 90%;
  float: right;
}
  .Ui_Db_Pager ul {
    list-style-type: none;
  }
  .Ui_Db_Pager li {
    float: left;
    display: inline;
    margin: 0 5px 0 0;
    display: block;
  }
  .Ui_Db_Pager li.selected {
    font-weight: bold;
  }
  .Ui_Db_Pager li.off a {
    color: #000;
    text-decoration: none;
  }
  
.pageList{
  overflow: auto;
  height: 300px;
  border: 1px solid #333;
}
</style>
</head>

<body>
  
    <table border="0" cellpadding="0" cellspacing="0" width="100%">
      <tr>
        <th>Title</th>
        <th>Modified</th>
      </tr>
    </table>
  <div class="pageList">
    <table border="0" cellpadding="0" cellspacing="0">
      <tr repeat="row">
        <td width="100%"><a href="javascript:;" var="title"></a></td>
        <td class="modified" var="modified"></td>
      </tr>
    </table>
  </div>
  
  <div class="mceActionPanel">
    <div var="Ui_Db_Pager"></div>
    <div style="float: left;">
      <input type="button" id="cancel" name="cancel" value="Cancel" onclick="tinyMCEPopup.close();" />
    </div>
  </div>
  

</body>
</html>
<?php
$html = ob_get_clean();
$template = Dom_Template::loadXml($html);


$offset = 0;
$limit = 40;
if (Dk_Request::getInstance()->exists('offset')) {
    $offset = Dk_Request::getInstance()->getParameter('offset');
}

$pageList = Ext_Db_PageMapper::findAll('title', $limit, $offset);


$pager = Dk_Ui_Pager::makeFromList($pageList);
$pager->show();
$template->insertTemplate($pager->getInsertVar(), $pager->getTemplate());


/* @var $page Ext_Db_Page */
foreach ($pageList as $page) {
    $repeat = $template->getRepeat('row');
    $repeat->replaceText('title', $page->getTitle());
    $title = addslashes($page->getTitle());
    $repeat->replaceAttr('title', 'href', "javascript:WikiFindPageDialog.insert('{$page->getName()}', '$title');");
    $repeat->replaceText('modified', $page->getModified()->getLongDate(true));
    $repeat->append();
}


echo $template->getDocument()->saveHTML();

?>