<?php
if (!isset($_REQUEST['sid'])) {
  throw new RuntimeException('Invalid Session Name ID');
}

$fileRoot = realpath(dirname(__FILE__).'/../../../../');
if (isset($_SESSION['mce-params']) && is_readable($_SESSION['mce-params']['FileRoot'])) {
    $fileRoot = $_SESSION['mce-params']['FileRoot'];
}
$libDir = $fileRoot.'/lib';
ini_set('include_path', $libDir.':'.ini_get('include_path'));

require_once("Dk/Functions/autoLoad.php");
$session = Dk_Session::getInstance($_REQUEST['sid']);
include('Dk/_prepend.php');

$config->parseConfigFile($fileRoot.'/config.ini');

ob_start();

//*********//

$settings = $session->getParameter('mce-params');
if ($settings == null) {
    throw new Exception("No valid Session Data for the file manager exists.");
}

/* @var $sessionData Jdk_TinyMce_SessionData */
Dk_Util_Url::$pathPrefix = $settings['HtdocRoot'];
Dk_Util_Path::$pathPrefix = $settings['FileRoot'];

// Setup vars 
$selectedPath = '';
if ($request->exists('selectedPath')) {
    $selectedPath = $request->getParameter('selectedPath');
}

if ($settings['FileManagerPath'] == null) {
    throw new Exception("No valid data directory selected.");
}
if (!is_dir($settings['FileManagerPath'])) {
    if (!mkdir($settings['FileManagerPath'], 0777, true)) {
        throw new Exception('Cannot create directory, check permissions: ' . $settings['FileManagerPath']);
    }
}

$selectedPath = str_replace('..', '', $selectedPath);
$selectedPath = str_replace('//', '/', $selectedPath);
$currentPath = $settings['FileManagerPath'] . $selectedPath;
$dataHtdoc = str_replace($settings['FileRoot'], '', $settings['FileManagerPath']);

?>