<?php
if (!isset($_REQUEST['sid'])) {
  throw new RuntimeException('Invalid Session Name ID');
}

$fileRoot = realpath(dirname(__FILE__).'/../../../../');
if (isset($_SESSION['mce-params']) && is_readable($_SESSION['mce-params']['FileRoot'])) {
    $fileRoot = $_SESSION['mce-params']['FileRoot'];
}
$libDir = $fileRoot.'/lib';
ini_set('include_path', $libDir.':'.ini_get('include_path'));

require_once("Dk/Functions/autoLoad.php");
$session = Dk_Session::getInstance($_REQUEST['sid']);
include('Dk/_prepend.php');

$config->parseConfigFile($fileRoot.'/config.ini');

ob_start();

//*********//

$settings = $session->getParameter('mce-params');
if ($settings == null) {
    throw new Exception("No valid Session Data for the file manager exists.");
}

/* @var $sessionData Jdk_TinyMce_SessionData */
Dk_Util_Url::$pathPrefix = $settings['HtdocRoot'];
Dk_Util_Path::$pathPrefix = $settings['FileRoot'];


?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>

	<title>Find Page</title>
  <link rel="stylesheet" type="text/css" media="all" href="css/style.css" />
	<script type="text/javascript" src="../../tiny_mce_popup.js"></script>
	<script type="text/javascript" src="js/dialog.js"></script>
    
<style type="text/css">
th {
  text-align: center;
  padding: 1px 20px;
}
td {
  padding: 1px 4px;
}
td.modified {
  white-space: nowrap;
  text-align: right;
}

form.nav {
  margin: 10px 0px;
}
.Ui_Db_Pager {
  margin: 5px 0px;
  padding: 2px 10px 2px 10px;
  font-size: 90%;
  float: right;
}
  .Ui_Db_Pager ul {
    list-style-type: none;
  }
  .Ui_Db_Pager li {
    float: left;
    display: inline;
    margin: 0 5px 0 0;
    display: block;
  }
  .Ui_Db_Pager li.selected {
    font-weight: bold;
  }
  .Ui_Db_Pager li.off a {
    color: #000;
    text-decoration: none;
  }
  
.pageList{
  overflow: auto;
  height: 300px;
  border: 1px solid #333;
}
</style>
</head>
<body>
    <h2>Article List</h2>
    
    <!--
      TODO: Add a categroy select and an rticleId text field
    -->
    <form id="NavForm" method="post" class="nav">
      Category: <select name="categoryId" onchange="this.form.submit();"><option value="0">All</option></select>
      Article ID: <input type="text" name="articleId" size="4"/> <input type="submit" name="go" value="Go" /> 
    </form>
    <table border="0" cellpadding="0" cellspacing="0" width="100%">
      <tr>
        <th>Title</th>
        <th>Modified</th>
      </tr>
    </table>
  <div class="pageList">
    <table border="0" cellpadding="0" cellspacing="0">
      <tr repeat="row">
        <td width="100%"><a href="javascript:;" var="title"></a></td>
        <td class="modified" var="modified"></td>
      </tr>
    </table>
  </div>
  
  <div class="mceActionPanel">
    <div var="Ui_Db_Pager"></div>
    <div style="float: left;">
      <input type="button" id="cancel" name="cancel" value="Cancel" onclick="tinyMCEPopup.close();" />
    </div>
  </div>
  
</body>
</html>
<?php
$html = ob_get_clean();
$template = Dom_Template::loadXml($html);

$categoryId = 0;
$offset = 0;
$limit = 40;
if (Dk_Request::getInstance()->exists('offset')) {
    $offset = Dk_Request::getInstance()->getParameter('offset');
}
if (Dk_Request::getInstance()->exists('categoryId')) {
    $categoryId = Dk_Request::getInstance()->getParameter('categoryId');
}

$list = Ext_Db_ArticleMapper::findPublished($categoryId, new Dk_Util_Loo($limit, $offset, 'title'), false, true);
if (Dk_Request::getInstance()->getParameter('articleId') > 0) {
    $article1 = Ext_Db_ArticleMapper::find(Dk_Request::getInstance()->getParameter('articleId'));
    $list = new Dk_Db_Array();
    $list->setLoo(new Dk_Util_Loo($limit, $offset, 'title'));
    if ($article1) {
        $list[] = $article1;
        $list->setTotal(1);
    }
}

$pager = Dk_Ui_Pager::makeFromList($list);
$pager->show();
$template->insertTemplate($pager->getInsertVar(), $pager->getTemplate());

$catList = Ext_Db_CategoryMapper::findAll(new Dk_Util_Loo(0, 0, 'title'));
$el = $template->getForm('NavForm')->getFormElement('categoryId');
foreach ($catList as $cat) {
    $el->appendOption($cat->getTitle(), $cat->getId());
}
$el->setValue($categoryId);

/* @var $article Ext_Db_Article */
foreach ($list as $article) {
    $repeat = $template->getRepeat('row');
    $repeat->replaceText('title', $article->getTitle());
    
    $url = new Dk_Util_Url('/articleView.html');
    $url->setQueryField('articleId', $article->getId());
    
    $repeat->replaceAttr('title', 'href', 
        "javascript:CmsFindPageDialog.insert('{$article->getTitle()}', '{$url->toString()}');");
    
    $repeat->replaceText('modified', $article->getModified()->getLongDate(true));
    $repeat->append();
}

echo $template->getDocument()->saveHTML();

?>