<?php
    ///////////////////////////////////////////////////////////
    // razorCMS                                              //
    // core/public_func.php                                  //
    // GPLv3                                                 //
    // smiffy6969                                            //
    // www.razorcms.co.uk                                    //
    // www.burningfist.co.uk                                 //
    // 03/2008                                               //
    // ----------------------------------------------------- //
    // V0.1  -  03/2008  -  Version 0.1 first release        //
    //                                                       //
    //                      Some parts loosely based on      //
    //                      nanoCMS V0.3 - with thanks to    //
    //                      Kalyan Chakravarthy              //
    // ----------------------------------------------------- //
    // V0.2  -  06/2008  -  This file contains changes for   //
    //                      up issue to V0.2BETA and RC      //
    // ----------------------------------------------------- //
    // V0.2  -  08/2008  -  RC2 Bug fix release              //
    //                      Changes in this file             //
    // ----------------------------------------------------- //
    ///////////////////////////////////////////////////////////

    // find location and extention of slab //
    function findPageFile( $name, $locFlag='' ) {
        global $razorArray;
        $pages_Dir = '';
        if ($locFlag == 'admin') {
            $pages_Dir = getSystemRoot(RAZOR_ADMIN_FILENAME).RAZOR_PAGES_DIR;
        } elseif ($locFlag == 'home') {
            $pages_Dir = getSystemRoot(RAZOR_HOME_FILENAME).RAZOR_PAGES_DIR;
        }
        $ext = explode( ',', RAZOR_EXTENSIONS_ORDER );
        foreach( $ext as $ex ) {
            if( file_exists( $pages_Dir."$name.$ex" ) ) {
                return $pages_Dir."$name.$ex";
            }
            return $pages_Dir."$name.".$razorArray['settings']['default-page-ext'];
        }
    }
    // end ////////////////////////////////////////

    // clean up slab title //
    function cleanSlabTitle($title, $slabID=0) {
        //$slabTitle = $title;
        $slabTitle = urlencode($title);
        $slabTitle = strtolower( $slabTitle );
        if ( $slabID == 0 ) {
            $slabTitle = str_replace( array(',',"'",'?','/','*','(',')','@','!','&','='),'',$slabTitle );
            $slabTitle = str_replace( array('  ','   '),' ', $slabTitle );
            $slabTitle = str_replace( array(' ','+'),'-', $slabTitle );
        } else {
            if ( preg_match('!^[^%]+$!', $slabTitle) ) {
                $slabTitle = str_replace( array(',',"'",'?','/','*','(',')','@','!','&','='),'',$slabTitle );
                $slabTitle = str_replace( array('  ','   '),' ', $slabTitle );
                $slabTitle = str_replace( array(' ', '+'),'-', $slabTitle );
            } else {
                $slabTitle = 'slabid-'.$slabID;
            }
        }
        return $slabTitle;
    }
    // end //////////////////

    // sets current active page //
    function setActivePage() {
        global $razorArray,$cap,$slabFlag;
        $slab = $razorArray['homepage'];
        $cap = new SLAB();
        if (isset($_GET['slab'])) {
            $slab = $_GET['slab'];
        }
        BsocketB('url-in', array( &$slab ));
        if( !in_array($slab,$razorArray['slabs']) ) {
            $slab = $razorArray['homepage'];
        }
        if (isset($slab) && $slab != '') {
            $cap->loadSlab($slab);
            $slabFlag = $slab;
        }	
    }
    // end //////////////////////

    // load slab contents into page //
    function loadSlabContents() {
        global $cap, $razorArray;
        $slab = $cap->slab;
	$fileAsID = array_search($slab, $razorArray['slabs']);
        $contentFile = findPageFile( $fileAsID, 'home' );
        if( file_exists( $contentFile ) ) {
            $contentSlug = file_get_contents( $contentFile );
            BsocketB('scan-content-slug', array( &$contentSlug ));
            echo $contentSlug;
        } else {
            header("HTTP/1.0 404 Not Found");
            echo "404 : File Requested was Not Found";
        }
    }
    // end //////////////////////////

    // load page (slab) title //
    function loadPageTitle() {
        global $cap;
        echo $cap->title;
    }
    // end /////////////////////

    // load settings data into page //
    function loadSettings($areaName) {
        global $razorArray;
        switch ($areaName) {
        case "sitename":
            echo html_entity_decode($razorArray['settings']['site-name'], ENT_QUOTES);
            break;
        case 'siteslogan':
            echo html_entity_decode($razorArray['settings']['site-slogan'], ENT_QUOTES);
            break;
        case 'copyright':
            echo html_entity_decode($razorArray['settings']['copyright-footer'], ENT_QUOTES);
            break;
        }
    }
    // end //////////////////////////

    // load links from a given catagory //
    function loadLinks( $link_cat, $format='', $before='', $after='' ) {
        global $razorArray;
        $linklist = getLinksArray($link_cat);
        if ( $linklist != '' ) {
            if( $format == '' ) {
                $format = "<li>%s</li>";
            }
            if( $format == 'nolist' ) {
                $format = '%s';
            }
            if( $format == '<li>%s</li>' ){
                echo sprintf('<ul>');
            }
            foreach( $linklist as $slab=>$title ) {
                $extLinkFlag = false;
	            if ( isset( $razorArray['ext_links'] ) ) {
	                if ( in_array( $slab,array_keys($razorArray['ext_links']) ) ) {
	                    $extLinkFlag = true;
	                }
                }
                BsocketB( 'create-link-from-cat-before' );
                if ( $extLinkFlag ) {
                    if ( isset( $razorArray['ext_link_win'][$slab] ) ) {
                        if ( $razorArray['ext_link_win'][$slab] ) {
                             echo sprintf( $format, $before.makeLinkWin( 'http://'.$razorArray['ext_links'][$slab],$title ).$after );                           
                        } else {
                            echo sprintf( $format, $before.makeLink( 'http://'.$razorArray['ext_links'][$slab],$title ).$after );
                        }
                    } else {
                            echo sprintf( $format, $before.makeLink( 'http://'.$razorArray['ext_links'][$slab],$title ).$after );
                    }
                } else {
                    $slabUrlIn = slabUrl($slab);
                    if ($slabUrlIn == '?') {
                        $stripURL = explode(RAZOR_HOME_FILENAME,$_SERVER['PHP_SELF']);
                        echo sprintf( $format, $before.makeLink( $stripURL[0],$title ).$after );
                    } else {
                        echo sprintf( $format, $before.makeLink( $slabUrlIn,$title ).$after );
                    }
                }
                BsocketB( 'create-link-from-cat-after' );
            }
            if( $format == '<li>%s</li>' ){
                echo sprintf('</ul>');
            }
        }
    }
    // end //////////////////////////////

    // makes link from slab name and title //
    function makeLink($slab,$title) {
        $returnLink = "<a href='$slab'>$title</a>";
        BsocketB( 'edit-link-creation' , array( &$returnLink,$slab,$title ));
	    return $returnLink;
    }
    // end /////////////////////////////////

    // makes link from slab name and title with link appearing in new window //
    function makeLinkWin($slab,$title) {
        $returnLink = "<a href='$slab' target='_blank'>$title</a>";
        BsocketB( 'edit-link-creation' , array( &$returnLink,$slab,$title ));
        return $returnLink;
    }
    // end /////////////////////////////////

    // returns url for a slab //
    function slabUrl($slab) {
        global $razorArray; 
        $urlFormat = sprintf(RAZOR_URL_FORMAT,$slab);
        if ($slab == $razorArray['homepage']) {
            $urlFormat = '?';
        }
        BsocketB('url-out', array( &$urlFormat));
        return $urlFormat;
    }
    // end ////////////////////

    // fetch links array //
    function getLinksArray( $cat ) {
        global $razorArray;
        $cdt = $razorArray['links_cats'];
        if( in_array( $cat, array_keys($cdt) ) ) {
            $scids = $cdt[$cat];
            $slabs = $razorArray['slabs'];
            $titles = $razorArray['titles'];
            $dslabs = array();
            foreach( $scids as $sid ) {
                $dslabs[ $slabs[$sid] ] = $titles[$sid];
            }
            return $dslabs;
        } else {
            return '';
        }
    }
    // end ///////////////

    // find system root, specify what to chop off end of running script //
    function getSystemRoot($ignoreEnd) {
        $rootAddress = array();
        $rootAddress = explode($ignoreEnd, $_SERVER['PHP_SELF']);
        if ( $ignoreEnd == RAZOR_ADMIN_FILENAME ) {
             return '../';      
        } else {
            return '';
        }
    }
    // end ///////////////////////////////////////////////////////////////

    // Log Blade packs that have been added //
    function logBladePack( $tLocation, $tName ) {
        global $bladeList;
        $bladeList[ $tLocation ] = array_merge( (array)$bladeList[ $tLocation ], (array)$tName );
    }
    // end //////////////////////////////////

    // Socket function that blades load through //
    function BsocketB( $location, $data=array() ) {
        global $bladeList;
        $blades = $bladeList[ $location ];
        if( empty($blades) ) {
            return;
        }
        foreach( $blades as $tFunc ) {
            if( is_callable( $tFunc ) ) {
                call_user_func_array( $tFunc, $data );
            }
        }
    }
    // end ///////////////////////////////////////

    // Load page into info box //
    function loadInfoContents() {
        global $razorArray,$slabFlag;
        if (isset($razorArray['settings']['info-bar-cat'])) {
            if( isset( $_GET['slab'] ) ) {
                $infoKey = $_GET['slab'];                
            }
            BsocketB('url-in', array( &$infoKey ));
            if ( !$infoKey ) {
                $infoKey = $razorArray['homepage'];
            }

            // scan each infobar content and check if has page allocated against it
            foreach ($razorArray['links_cats']['infobar'] as $slabID) {
		if ( is_array($razorArray['info-bar-key']) && is_array($razorArray['info-bar-value']) ) {
                    if ( in_array($razorArray['slabs'][$slabID], $razorArray['info-bar-key']) ) {
			foreach ( $razorArray['info-bar-value'] as $key=>$value ) {
                            if ( $value == $infoKey && $razorArray['info-bar-key'][$key] == $razorArray['slabs'][$slabID] ) {
                                $infoName = $razorArray['slabs'][$slabID];
                                $fileAsID = array_search(strtolower($infoName), $razorArray['slabs']);
                                $infoFile = findPageFile($fileAsID, 'home' );
                                if( file_exists( $infoFile ) ){
                                   $contentInfo = file_get_contents( $infoFile );
                                   BsocketB('scan-content-info', array( &$contentInfo ));
                                   echo $contentInfo;
                                }
			    }
                        }
	            }
                }
            }
        }
    }
    // end /////////////////////

    // find css location (in case of sef url) //
    function cssLocation() {
        $splitAddress = explode(RAZOR_HOME_FILENAME, $_SERVER['PHP_SELF']);
        $css = $splitAddress[0].RAZOR_CSS_FILE;
        BsocketB('public-css-address', array(&$css));
        echo $css;
    }
    // end /////////////////////
?>
