<?php
    ///////////////////////////////////////////////////////////
    // razorCMS                                              //
    // core/public_config.php                                //
    // GPLv3                                                 //
    // smiffy6969                                            //
    // www.razorcms.co.uk                                    //
    // www.burningfist.co.uk                                 //
    // 03/2008                                               //
    // ----------------------------------------------------- //
    // V0.1  -  03/2008  -  Version 0.1 first release        //
    //                                                       //
    //                      Some parts loosely based on      //
    //                      nanoCMS V0.3 - with thanks to    //
    //                      Kalyan Chakravarthy              //
    // ----------------------------------------------------- //
    // V0.2  -  06/2008  -  This file contains changes for   //
    //                      up issue to V0.2RC               //
    // ----------------------------------------------------- //
    // V0.2  -  08/2008  -  RC2 Bug fix release              //
    //                      No changes to this file          //
    // ----------------------------------------------------- //
    ///////////////////////////////////////////////////////////

    ///////////////////////////////////////
    //   Optional System Configuration   //
    // EDIT LINES BELOW AT YOUR OWN RISK //
    ///////////////////////////////////////

    $RAZOR = array();

    // location of system data file razor_data.txt //
    $RAZOR['pages_info'] = 'datastore/razor_data.txt';

    // location of pages dir for stored content //
    $RAZOR['pages_dir'] = 'datastore/pages/';

    // location of areas dir for stored content //
    $RAZOR['areas_dir'] = 'datastore/areas/';

    // location of media dir for stored content //
    $RAZOR['media_dir'] = 'datastore/media/';

    // location of blade packs //
    $RAZOR['bladepack_dir'] = 'blade_packs/';

    // name of homepage filename //
    $RAZOR['index_filename'] = 'index.php';

    // name and location of admin filename //
    $RAZOR['admin_filename'] = 'admin/index.php';

    // name and location of default public CSS file //
    $RAZOR['css_file_name'] = 'theme/default_css.css';

    ///////////////////////////////////////////////
    //  Assigning variables into data constants  //
    //          DO NOT EDIT THESE LINES          //
    ///////////////////////////////////////////////

    define( 'RAZOR_DATA' , $RAZOR['pages_info'] );
    define( 'RAZOR_EXTENSIONS_ORDER' , "php,html,htm,txt" );
    define( 'RAZOR_PAGES_DIR' , $RAZOR['pages_dir'] );
    define( 'RAZOR_AREAS_DIR' ,  $RAZOR['areas_dir'] );
    define( 'RAZOR_MEDIA_DIR' ,  $RAZOR['media_dir'] );
    define( 'RAZOR_URL_FORMAT' , $RAZOR['index_filename'].'?slab=%s' );
    define( 'RAZOR_ADMIN_FILENAME' , $RAZOR['admin_filename'] );
    define( 'RAZOR_HOME_FILENAME' , $RAZOR['index_filename'] );
    define( 'RAZOR_BLADEPACK_DIR' , $RAZOR['bladepack_dir'] );
    define( 'RAZOR_CSS_FILE' , $RAZOR['css_file_name'] );

?>