<?php
    ///////////////////////////////////////////////////////////
    // razorCMS                                              //
    // core/public_class.php                                 //
    // GPLv3                                                 //
    // smiffy6969                                            //
    // www.razorcms.co.uk                                    //
    // www.burningfist.co.uk                                 //
    // 03/2008                                               //
    // ----------------------------------------------------- //
    // V0.1  -  03/2008  -  Version 0.1 first release        //
    //                                                       //
    //                      Some parts loosely based on      //
    //                      nanoCMS V0.3 - with thanks to    //
    //                      Kalyan Chakravarthy              //
    // ----------------------------------------------------- //
    // V0.2  -  06/2008  -  No changes in this file          //
    //                      up issue to V0.2BETA or RC       //
    // ----------------------------------------------------- //
    // V0.2  -  08/2008  -  RC2 Bug fix release              //
    //                      Changes in this file             //
    // ----------------------------------------------------- //
    ///////////////////////////////////////////////////////////

    /////////////////////////
    // core public classes //
    /////////////////////////

    ////////////////
    // slab class //
    ////////////////
    class SLAB {
        var $cats = array();
        var $slab;
        var $slabId;
        var $title;
        var $isEdited=false;

        // Initialize new blank page //
        function newSlabInit() {
            global $razorArray;
            $cnt = $razorArray['slab_count'];
            $razorArray['slab_count'] = ++$cnt;
            $this->slabId = $cnt;
        }
        // end ///////////////////////

        // create slab name from title  //
        function editTitle($s) {
            if( $s != $this->slab ) {
                $this->isEdited=true;
            }
            $this->title = $s;
            $this->slab = cleanSlabTitle( $s,$this->slabId );
        }
        // end /////////////

        // check if the page is present in the test category //	
        function isInCat($c) { 
            if( array_search($c,$this->cats) ) {
                return true;
            } else {
                return false;
            }
        }
        // end ////////////////////////////////////////////////

        // add the current page to a category //
        function addToCat($cat) {
            // check for admin access to this function // 
            if( !($_SESSION['adminLogIn'] == sha1(session_id().RAZOR_ADMIN_PASS.$_SESSION['loginTimeStamp']))) {
                die("Access Denied");
            }
            // end - if no access granted - do not continue /////
            if( !$this->isInCat($cat) ) {
                $this->isEdited=true;
                $this->cats[] = $cat;
            }
        }
        // end ////////////////////////////////

        // reset the catetory listing //
        function catReset() {
            $this->cats = array();
        }
        // end /////////////////////////

        // remove catagory //
        function removeCat($ca) {
            $catInd = array_flip( $this->cats );
            unset( $this->cats[ $catInd[$ca] ] );
        }
        // end //////////////

        // laod slab details //
        function loadSlabDetails() {
            global $razorArray;
            $tt = $razorArray['titles'];
            $oCats = $razorArray['links_cats'];
            $sid = $this->slabId;
            $this->title = $tt[ $this->slabId ];
            foreach( $oCats as $oCat=>$oCatC ) {
                if( in_array($sid,$oCatC) ) {
                    $this->cats[] = $oCat;
                }
            }
        }
        // end /////////////////

        // load page details from a slab //
        function loadSlab($slab) {
            global $razorArray;
            $slabs = $razorArray['slabs'];
            $sids = array_flip($slabs);
            if( !in_array($slab,$slabs) ) {
                return false;
            }	
            $this->slab = $slab;
            $this->slabId = $sids[$slab];
            $this->loadSlabDetails();
        }
        // end ///////////////////////////

        // commit changes made //
        function commitChanges() {
            // check for admin access to this function // 
            if( !($_SESSION['adminLogIn'] == sha1(session_id().RAZOR_ADMIN_PASS.$_SESSION['loginTimeStamp']))) {
                die("Access Denied");
            }
            // end - if no access granted - do not continue /////
            global $razorArray;
            $catList = $razorArray['links_cats'];
            $sd = $razorArray['slabs'];
            $tt = $razorArray['titles'];
            $tt[ $this->slabId ] = $this->title;
            $sd[ $this->slabId ] = $this->slab;
            foreach($catList as $catName=>$catslabs) {
                $isCategoryInOurList = in_array( $catName ,$this->cats );
                $isslabInMasterCategory = in_array( $this->slabId, $catslabs );
                if(  $isCategoryInOurList and !$isslabInMasterCategory ) {
                    array_push($catList[$catName],$this->slabId);
                    echo '<br>'.lt('Added');
                }
                if(  !$isCategoryInOurList and $isslabInMasterCategory ) {
                    $catslabsIndexes = array_flip( $catList[$catName] );
                    array_splice( $catList[$catName], $catslabsIndexes[$this->slabId],1 );
                    echo "<br>".lt('Deleted from list')." - $catName";
                }
            }
            $razorArray['links_cats'] = $catList;
            $razorArray['slabs'] = $sd;
            $razorArray['titles'] = $tt;
        }
        // end ///////////////////
    }
    ////////////////////
    // end page class //
    ////////////////////

    //////////////////////
    // Blade Pack class //
    //////////////////////
    class BLADEPACK {
        var $packName;
        var $packActive = false;

        // Default function to run when initialising class //
        function BLADEPACK( $bTitle ) {
            global $bladeData, $razorArray;
            $activePacks = $razorArray['active-bladepack'];
            $this->packName = cleanSlabTitle($bTitle);
            $bladeData[ $this->packName ][ 'name' ] = $bTitle;
            if( in_array( $this->packName, $activePacks ) ) {
                $this->packActive = true;
            }
        }
        // end /////////////////////////////////////////////

        // loads individual blades in the pack and logs them //
        function addBlade( $location, $callFunction ) {
            if( !$this->packActive ) {
                return;
            }
            global $bladeData;
            $bladeData[ $this->packName ][ 'blades' ][] = array( 'location'=>$location , 'callFunction'=>$callFunction );
            logBladePack( $location, $callFunction );
        }
        // end ///////////////////////////////////////////////

        // loads the blade pack author //   
        function Author( $auth ) {
            global $bladeData;
            $bladeData[ $this->packName ][ 'author' ] = $auth;
        }
        // end //////////////////////////   

        // loads the blade pack description //        
        function Description( $desc ) {
            global $bladeData;
            $bladeData[ $this->packName ][ 'desc' ] = $desc;
        }
        // end ///////////////////////////////
    }
    //////////////////////////
    // end blade pack class //
    //////////////////////////
?>