<?php
    ///////////////////////////////////////////////////////////
    // razorCMS                                              //
    // admin/theme/adminhome.php                             //
    // GPLv3                                                 //
    // smiffy6969                                            //
    // www.razorcms.co.uk                                    //
    // www.burningfist.co.uk                                 //
    // 03/2008                                               //
    // ----------------------------------------------------- //
    // V0.1  -  03/2008  -  Version 0.1 first release        //
    //                                                       //
    //                      Some parts loosely based on      //
    //                      nanoCMS V0.3 - with thanks to    //
    //                      Kalyan Chakravarthy              //
    // ----------------------------------------------------- //
    // V0.2  -  06/2008  -  This file was altered for V0.2RC //
    // ----------------------------------------------------- //
    // V0.2  -  08/2008  -  RC2 Bug fix release              //
    //                      Changes in this file             //
    // ----------------------------------------------------- //
    ///////////////////////////////////////////////////////////

// check for admin access to this function library // 
if( !($_SESSION['adminLogIn'] == sha1(session_id().RAZOR_ADMIN_PASS.$_SESSION['loginTimeStamp']))) {
    die("Access Denied");
}
?>
<h1>razorCMS - Administration</h1>
<h2>System Information</h2>
<?php
    $currentVersion = "core v0.2 RC2";
    print "<div class='split50'><h3>Version Check</h3>";
    print "<ul><li>Current installed version : $currentVersion</li>";
    print "<li>Latest available version : "; 
    $versionUrl = "http://www.razorcms.co.uk/version/latestversion.txt";
    ini_set('default_socket_timeout', 2); 
    $versionData = @file_get_contents($versionUrl, FALSE);
    $versionData = preg_replace('/[^a-zA-Z0-9\.\s\,\-\_]/', '', $versionData);
    if ( isset($versionData)) { 
        if ($versionData == $currentVersion) {
            print "<span class='greentext'>".$versionData."</span>";
        } else if ($versionData == '') {
            $versionData = 'connection failure';
            print "<span class='bluetext'>".$versionData."</span>";
        } else {
            print "<span class='redtext'>".$versionData."</span>";
        }
    } else {
        $versionData = 'connection failure';
        print "<span class='bluetext'>".$versionData."</span>";
    }
    print '</li></ul>';
    if ($versionData == $currentVersion) {
        print '<p class="greentext">Your installation is up to date, please check back regularly for updates</p>';
    } else if ( $versionData == 'connection failure' ) {
        print '<p class="bluetext">There appears to be an error connecting to the remote version check file, please check back later.</p>';
    } else {
        print '<p class="redtext">Your installation is out of date, please visit the <a href="http://www.razorcms.co.uk" target="_blank">official razorCMS website</a> for core updates</p>';
    }
    print "<h3>Environment Check</h3>";
    if ( ini_get('register_globals') ) {
        echo '<p>Register globals is set to : <span class="redtext">on</span></p>';
        echo '<p><span class="redtext">Environment is not secure, register globals is switched on, this is a severe security hazard, please consult your host supplier for information on switching it off</span></p>';
    } else {
        echo '<p>Register globals is set to : <span class="greentext">off</span></p>';
        echo '<p>Environment is OK, register globals is switched off</p>';
    }
    print "</div><div class='split50'><h3>System Messages</h3>";
    $sysMessUrl = "http://www.razorcms.co.uk/version/sysmess.txt";
    ini_set('default_socket_timeout', 2); 
    $messageData = @file_get_contents($sysMessUrl, FALSE);
    $messageData = preg_replace('/[^a-zA-Z0-9\.\s\,\-\_\<\>\/]/', '', $messageData);
    if ( isset($messageData)) { 
        print "<p class='bluetext'>".$messageData."</p>";
    } else {
        $messageData = 'connection failure, please check back later....';
        print "<p class='bluetext'>".$messageData."</p>";
    }
    print "</div>";
?>
<h2>Using razorCMS</h2>
<p>For detailed information on using razorCMS, please consult the user manual, which can be found
in the documents section of the <a href="http://www.razorcms.co.uk" target="_blank">official razorCMS website</a>.</p>
<h2>Developement</h2>
<p>If you wish to develope blade pack add on's, write guides or even create new themes for razorCMS, why not
visit the documents section of the <a href="http://www.razorcms.co.uk" target="_blank">official razorCMS website</a>
for more help and advice on where to start. Here you will be able to find development guides, sample code
and lots lots more.</p>
<h2>Extra Functionality</h2>
<p>If you require more functionality than the core install can offer, why not visit the <a href="http://www.razorcms.co.uk" target="_blank">official razorCMS website</a>
for a whole array of blade packs from functional, in-page and theme blade packs</p>
<h2>Need Help</h2>
<p>If your having trouble using the system, you have two places to solve your problems, try reading the guides and manuals listed
on the <a href="http://www.razorcms.co.uk" target="_blank">official razorCMS website</a>, failing this ask a question or look for answers in our dedicated support forum.</p>
<h2>Links</h2>
<p><ul><li>razorCMS core author : <a href="mailto:smiffy6969@razorcms.co.uk">smiffy6969</a></li>
<li>razorCMS support forum : <a href="http://www.razorcms.co.uk/support">razorCMS support forum</a></li>
<li>razorCMS official website : <a href="http://www.razorcms.co.uk">www.razorcms.co.uk</a></li>
<li>Conceptual web design : <a href="http://www.burningfist.co.uk">www.burningfist.co.uk</a></li></ul></p>

