<?php
    ///////////////////////////////////////////////////////////
    // razorCMS v0.1                                         //
    // admin/index.php                                       //
    // GPLv3                                                 //
    // smiffy6969                                            //
    // www.razorcms.co.uk                                    //
    // www.burningfist.co.uk                                 //
    // 03/2008                                               //
    // ----------------------------------------------------- //
    // V0.1  -  03/2008  -  Version 0.1 first release        //
    //                                                       //
    //                      Some parts loosely based on      //
    //                      nanoCMS V0.3 - with thanks to    //
    //                      Kalyan Chakravarthy              //
    // ----------------------------------------------------- //
    // V0.2  -  06/2008  -  No changes in this file          //
    //                      up issue to V0.2BETA or RC       //
    // ----------------------------------------------------- //
    // V0.2  -  08/2008  -  RC2 Bug fix release              //
    //                      Changes in this file             //
    // ----------------------------------------------------- //
    ///////////////////////////////////////////////////////////

    // start a new login session and fetch admin configuration //
    session_start();
    $oldSessionId = session_id();
    session_regenerate_id();
    include_once("core/admin_config.php");
    include_once("../core/public_config.php");
    include_once("../core/public_func.php");
    include_once("../core/public_class.php");
    /////////////////////////////////////////////////////////////

    BsocketB('admin-pre-login-logout');

    //  login  //
    if( !isset( $_SESSION['adminLogIn'] ) ) {
        if( isset($_POST['user']) ) {
            if( $_POST['user'] == RAZOR_ADMIN_USER and $_POST['pass'] == RAZOR_ADMIN_PASS ) {
                $_SESSION['loginTimeStamp'] = $ts = time();
                $_SESSION['adminLogIn'] = sha1(session_id().RAZOR_ADMIN_PASS.$ts);
                unset($oldSessionId);
            }
        }
    } else {
        if($_SESSION['adminLogIn'] == sha1($oldSessionId.RAZOR_ADMIN_PASS.$_SESSION['loginTimeStamp'])) {
            $_SESSION['loginTimeStamp'] = $ts = time();
            $_SESSION['adminLogIn'] = sha1(session_id().RAZOR_ADMIN_PASS.$ts);
            unset($oldSessionId);
        }
    }
    // end //////

    //  logout  //
    if( isset( $_GET['logout'] ) )  {
        unset( $_SESSION['adminLogIn'] );
    }
    // end ///////

    //  login form  //
    if( $_SESSION['adminLogIn']!=sha1(session_id().RAZOR_ADMIN_PASS.$_SESSION['loginTimeStamp']) or !isset( $_SESSION['adminLogIn'] ) ) {
        session_destroy();
	BsocketB('admin-pre-login-form');
        $form = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">';
        $form.= '<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">';
        $form.= '<head><title>razorCMS Administration login</title><link rel="stylesheet" type="text/css" href="theme/default_css.css" /></head>';
        $form.= '<body>';
        $form.= '<h1>Administration Login</h1>';
        $form.= '<div id="loginbox"><form id="loginform" action="?" method="post">username <input type=text name="user"><br />password <input type=password name="pass"><br /><input type="submit" value="Login"></div>';
        $form.= '</body>';
        $form.= '</html>';
        BsocketB('admin-login-form', array( &$form ));
	echo $form;
        exit();
    }
    // end ///////////
    
    // if authenticated, continue ////////////////////////

    // Load core config and core libraries ////////////////////
    include_once("core/admin_func.php");
    ///////////////////////////////////////////////////////////

    // set variables //////////////////////////////////////////
    $razorArray = array();
    $cap;
    $bladeList = array();
    $bladeData = array();
    $spareVar1;
    $spareVar2;
    $spareVar3;
    $spareArray1 = array();
    $spareArray2 = array();
    $spareArray3 = array();
    ///////////////////////////////////////////////////////////

    // Load razor data file  //////////////////////////////////
    $razorArray = unserialize( file_get_contents( getSystemRoot(RAZOR_ADMIN_FILENAME).RAZOR_DATA ) );
    BsocketB('admin-edit-razorarray', array( &$razorArray ));
    ///////////////////////////////////////////////////////////

    // Search for installed blades ////////////////////////////
    $bladePackSearch = glob( getSystemRoot(RAZOR_ADMIN_FILENAME).RAZOR_BLADEPACK_DIR.'*.php' );
    foreach( $bladePackSearch as $bladePack ) {
        require_once( $bladePack );
    }
    ///////////////////////////////////////////////////////////

    // set page contents to display ///////////////////////////
    setActivePage();
    ///////////////////////////////////////////////////////////

    // socket load points /////////////////////////////////////
    BsocketB('admin-index-socket1');
    BsocketB('admin-index-socket2');
    BsocketB('admin-index-socket3');
    ///////////////////////////////////////////////////////////

    // Load default theme for admin ////////////////////////// 
    $theme = "theme/default_admin_xhtml.php";
    BsocketB('admin-change-theme', array( &$theme ));
    include_once($theme);
    //////////////////////////////////////////////////////////

?> 
