<?php 
    ///////////////////////////////////////////////////////////
    // razorCMS                                              //
    // admin/core/admin_func.php                             //
    // GPLv3                                                 //
    // smiffy6969                                            //
    // www.razorcms.co.uk                                    //
    // www.burningfist.co.uk                                 //
    // 03/2008                                               //
    // ----------------------------------------------------- //
    // V0.1  -  03/2008  -  Version 0.1 first release        //
    //                                                       //
    //                      Some parts loosely based on      //
    //                      nanoCMS V0.3 - with thanks to    //
    //                      Kalyan Chakravarthy              //
    // ----------------------------------------------------- //
    // V0.2  -  06/2008  -  This file contains changes for   //
    //                      up issue to V0.2BETA and RC      //
    // ----------------------------------------------------- //
    // V0.2  -  08/2008  -  RC2 Bug fix release              //
    //                      Changes in this file             //
    // ----------------------------------------------------- //
    ///////////////////////////////////////////////////////////

    // check for admin access to this function library // 
    if( !($_SESSION['adminLogIn'] == sha1(session_id().RAZOR_ADMIN_PASS.$_SESSION['loginTimeStamp']))) {
        die("Access Denied");
    }
    // end - if no access granted - do not continue /////

    // ftp check - display ftp symbol if usinf ftp //
    function ftpCheck($show) {
        if ($show == 'show') {
            if( RAZOR_FTP_SERVER && RAZOR_FTP_USER && RAZOR_FTP_PASS && RAZOR_FTP_PATH ) {
                echo '<a class="ftp">FTP</a>';
            }
        }
    }
    // end ////////

    // message system for process messages //
    function MsgBox($msg,$class='yellowbox',$style='',$echo=true) {
        $t = "<div class='$class' style=\"$style\">$msg</div>";
        if( $echo ) {
            echo $t;
        } else {
            return $t;
        }
    }
    // end //////////////////////////////////

    // delete file via ftp or file write mode //
    function deleteFile($remote_file) {
        if( RAZOR_FTP_SERVER && RAZOR_FTP_USER && RAZOR_FTP_PASS && RAZOR_FTP_PATH ) {
            $ftpConnect = ftp_connect(RAZOR_FTP_SERVER);
            if (!$login_result = ftp_login($ftpConnect, RAZOR_FTP_USER, RAZOR_FTP_PASS)) {
                MsgBox( lt("ftp login failed"), 'redbox' );
                ftp_close($ftpConnect);
                return false;
            } else {
                if ( @ftp_delete($ftpConnect, RAZOR_FTP_PATH.$remote_file)) {
                    MsgBox( lt("file deleted"), 'yellowbox' );
                    ftp_close($ftpConnect);
                    return true;
                } else {
                    MsgBox( lt("file not deleted"), 'redbox' );
                    ftp_close($ftpConnect);
                    return false;
                }
            }
        } else {
            if ( @unlink(getSystemRoot(RAZOR_ADMIN_FILENAME).$remote_file) ) {
                MsgBox( lt("file deleted"), 'yellowbox' );
                return true;
            } else {
                MsgBox( lt("file not deleted"), 'redbox' );
                return false;  
            }
        }
    }
    // end ///////////

    // write to file via ftp or file write mode //
    function put2file($remote_file,$contents) {
        $filename = getSystemRoot(RAZOR_ADMIN_FILENAME).$remote_file;
        $pagesDir = getSystemRoot(RAZOR_ADMIN_FILENAME).RAZOR_PAGES_DIR;
        if( RAZOR_FTP_SERVER && RAZOR_FTP_USER && RAZOR_FTP_PASS && RAZOR_FTP_PATH ) {
            $ftpConnect = ftp_connect(RAZOR_FTP_SERVER);
            if (!$login_result = ftp_login($ftpConnect, RAZOR_FTP_USER, RAZOR_FTP_PASS)) {
                MsgBox( lt("ftp login failed"), 'redbox' );
                ftp_close($ftpConnect);
                return false;
            } else {
                $tmp = tmpfile();
                fwrite($tmp, $contents);
                rewind($tmp);
                $result = ftp_fput($ftpConnect, RAZOR_FTP_PATH.$remote_file, $tmp, FTP_ASCII);
                fclose($tmp);
                $perms = sprintf('%o', fileperms($filename));
                if ( $perms != '100644') {
                    ftp_site($ftpConnect, 'CHMOD 0644 '.RAZOR_FTP_PATH.$remote_file);
                }
                ftp_close($ftpConnect);
                return $result;
            }
        } else {
            $filename = getSystemRoot(RAZOR_ADMIN_FILENAME).$remote_file;
            $f=@fopen($filename,"w");
            if (!$f) {
                return false;
            } else {
                fwrite($f,$contents);
                fclose($f);
                $perms = sprintf('%o', fileperms($filename));
                if ( $perms != '100644') {
                    $paDirContents = opendir($pagesDir);
                    chmod($filename, 0644);
                    closedir($paDirContents);
                }
                return true;
            }
        }
    }
    // end ///////////

    // upload file via ftp or file write mode //
    function uploadFile($remoteFile, $uploadFile, $mode = FTP_ASCII) {
        $filename = getSystemRoot(RAZOR_ADMIN_FILENAME).$remoteFile;
        $mediaDir = getSystemRoot(RAZOR_ADMIN_FILENAME).RAZOR_MEDIA_DIR;
        if( RAZOR_FTP_SERVER && RAZOR_FTP_USER && RAZOR_FTP_PASS && RAZOR_FTP_PATH ) {
            $ftpConnect = ftp_connect(RAZOR_FTP_SERVER);
            if (!$login_result = ftp_login($ftpConnect, RAZOR_FTP_USER, RAZOR_FTP_PASS)) {
                MsgBox( lt("ftp login failed"), 'redbox' );
                ftp_close($ftpConnect);
                return false;
            } else {
                $result = ftp_put($ftpConnect, RAZOR_FTP_PATH.$remoteFile, $uploadFile, $mode);
                $perms = sprintf('%o', fileperms($filename));
                if ( $perms != '100644') {
                    ftp_site($ftpConnect, 'CHMOD 0644 '.RAZOR_FTP_PATH.$remoteFile);
                }
                ftp_close($ftpConnect);
                return $result;
            }
        } else {
            if (move_uploaded_file($uploadFile, $filename)) {
                $perms = sprintf('%o', fileperms($filename));
                if ( $perms != '100644') {
                    $paDirContents = opendir($mediaDir);
                    chmod($filename, 0644);
                    closedir($paDirContents);
                }
                MsgBox( lt("File successfully uploaded"), 'yellowbox' );
                return true;
            } else {
                MsgBox( lt("File upload error"), 'redbox' );
                return false;
            }
        }
    }
    // end ///////////

    // save changes serialise data and write to file//
    function saveRazorArray() {
        global $razorArray;
        $pagesdata = serialize( $razorArray );
        if( !put2file( RAZOR_DATA, $pagesdata ) ) {
            MsgBox( lt("file writing error"), 'redbox' );
        }
    }
    // end ///////////////////////////////////////////

    // reorder slabs //
    function reorder($cat,$pos1,$pos2) {
        global $razorArray;
        $cats = $razorArray['links_cats'];
        $cc = $cats[$cat][$pos1];
        $cats[$cat][$pos1] = $cats[$cat][$pos2];
        $cats[$cat][$pos2] = $cc;
        $razorArray['links_cats'] = $cats;
    }
    // end ////////////

    // perform reorder slabs //
    function performMove() {
        if( $_GET['action']=='reorder' ) {
            $par = explode(',',$_GET['param']);
            $par[0] = (int)$par[0];
            $par[1] = (int)$par[1];
            reorder( $_GET['cat'], $par[0], $par[1] );
            saveRazorArray();
            $_SESSION['opencat']=$_GET['cat'];
        }
    }
    // end ////////////////////

    // create checkbox list for forms //
    function checkBoxList($checkList,$selected=array() ,$return=true) {
        $op='';
        if ( is_array($checkList) ) {
            foreach( $checkList as $key=>$ele ) {
                $keyname = $key;
                $checked = ( in_array($key,$selected)?" checked=checked ":'' );
                $val = "<span class='caps'>$key</span>";
                $op.= "<input type='checkbox' id='check_$keyname' name='check_$keyname' value='$key' $checked><label for='check_$keyname'>$val</label>";
                $op.= "&nbsp; &nbsp; &nbsp;";
            }
        } else {
            $checked = ( in_array($checkList,$selected)?" checked=checked ":'' );
            $val = "<span class='caps'>$checkList</span>";
            $op.= "<input type='checkbox' id='check_$checkList' name='check_$checkList' value='$checkList' $checked><label for='check_$checkList'>$val</label>";
            $op.= "&nbsp; &nbsp; &nbsp;";
        }
        if($return) {
            return $op;
        } else {
            echo $op;
        }
    }
    // end ////////////////////////////

    // language interface function //
    function lt( $defaultText ) {
        $text = $defaultText;
        BsocketB('language-select', array(&$text));
        return $text;
    }
    // end /////////////////////////

    // slab creation function // 
    function addPage() {
        global $razorArray;
        $addtErrMsg = array();
        $catlist = $razorArray['links_cats'];
       	$newp = new SLAB();
        $newp->newSlabInit();
        $tempCatArray = array();
        $title = stripslashes($_POST['title']);
        foreach( $catlist as $tempCat=>$tempcc ) {
            if( isset( $_POST[ 'check_'.$tempCat ] ) ) {
                $tempCatArray[$tempCat] = $tempCat;
            }
        }

        // save data if form button clicked //
        if( isset( $_POST['save'] ) ) {
            $isFormSubmitted = true;
            $content = stripslashes($_POST['content']);
            $newp->editTitle( $title );
            $slab = $newp->slab;
            $newp->catReset();
            foreach( $catlist as $cat=>$cc ) {
                if( isset( $_POST[ 'check_'.$cat ] ) ) {
                    $newp->addToCat( $cat );
                }
            }
            if( $title != '' and $content !='' ) {
                $newPageFile = findPageFile($slab, 'admin');
                if( !in_array($slab, $razorArray['slabs']) ) {
                    BsocketB('admin-xpage-info-input', array($slab));
                    $newp->commitChanges();
                    $fileAsID = array_search($slab, $razorArray['slabs']);
                    if( put2file( RAZOR_PAGES_DIR.findPageFile($fileAsID), $content ) ) {
                        saveRazorArray();
                    }
                    $m = lt("The page was created successfully"). '<br />';
                    $m .= lt("File Created") ." : ".$fileAsID."<br />";
                    $m .= lt("Content")." : ".substr( strip_tags($content), 0, 100 ).( strlen($content)>100 ? '...' : '' )."<br />";
                    MsgBox( $m );
                    return; // return to main switch function
    		    } else {
                    $addtErrMsg[] = lt("Save Failed");
                    if( in_array($slab, $razorArray['slabs']) ) {
                        $addtErrMsg[] = lt("A link item with similar Title already exists");
                    }
                }
            } else {
                $addtErrMsg[] = lt("One of the input fields is empty, Please check your input");
            }
        }
        // end //
        
        // output any messages created during save data //
        if( count($addtErrMsg)!=0 and isset($title) ) {
            $em = '';
            foreach( $addtErrMsg as $msg ) {
                $em .= "<li>$msg</li>";
            }
            MsgBox( lt('Errors Occured')." : <ul>$em</ul>", 'redbox' );
        }
        // end //
        
        // set up data for input form //
        $submitButton = lt('Add Page');
        $filteredCats = array();
        if ( $_GET['action'] == 'addinfo' ) {
            $chkboxs = "<input type='hidden' name='check_".$razorArray['settings']['info-bar-cat']."' value='".$razorArray['settings']['info-bar-cat']."'><label for='check_".$razorArray['settings']['info-bar-cat']."'>".$razorArray['settings']['info-bar-cat']."</label>";
            $addnewpageLabel = lt('Infobar Content Details');
            $formAction = "?action=addinfo";
        } else {
            foreach ( $razorArray['links_cats'] as $linksCats=>$contents ) {
                if ( $linksCats != $razorArray['settings']['info-bar-cat'] ) {
                    $filteredCats[$linksCats] = $linksCats;
                }
            }
            $addnewpageLabel = lt('Page Details');
            $chkboxs = checkBoxList( $filteredCats, $tempCatArray );
            $formAction = "?action=addpage";
        }
        $pageTitleLabel = lt('Page Title');
        $catsLabel = lt('Categories');
        $contentLabel = lt('Content');
        $contentManager = lt('Content Manager - New Content');
        // end //
        
        // form sockets for adding output or functions to form //
        $extraInfo;
        $addFunction;
        if ( $_GET['action'] == 'addinfo' ) {
            BsocketB('admin-xinfo-info-output',array(&$extraInfo));
            BsocketB('admin-add-info-function',array(&$addFunction,&$content));
        } else {
            BsocketB('admin-xpage-info-output',array(&$extraInfo));
            BsocketB('admin-add-page-function',array(&$addFunction,&$content));
        }
        // end //
        
        // display form for data input //
        $te[1]=<<<TET
            <h1>$contentManager</h1>
            <form action='$formAction' method=post class='pagemod_form'>
                <h2>$addnewpageLabel</h2>
                $extraInfo
                <table width='98%' border='0'>
                    <tr>
                        <td width='20%'>$pageTitleLabel</td>
                        <td><input type='text' value='$title' name='title'></td>
                        <td align='right'></td>
                    </tr>
                    <tr>
                        <td>$catsLabel</td>
                        <td colspan=2>$chkboxs</td>
                    </tr>
                </table>
                <h2>$contentLabel</h2>
                <table width="98%">
		$addFunction
                    <tr><td colspan=2>
TET;
        $te[2] = "<textarea name='content' rows=20 cols=70 id='editbox' class='editbox'>$content</textarea>";
        $te[3]=<<<TET
                    </td>
                    </tr>
                    <tr>
                        <td colspan=2>
                            <br /><input id='button' type='submit' value='$submitButton' name='save'>
                        </td>
                    </tr>
                </table>
            </form>
TET;
        $te[4] = $content;
        echo $te[1];
        BsocketB( 'editor' , array( &$te ) );
        echo $te[2];
        echo $te[3];
        // end //
    }
    // end /////////////////////////

    // New external link creation function // 
    function addExtLink() {
        global $razorArray;
        $extLinkFlag = false;
        $addtErrMsg = array();
        $catlist = $razorArray['links_cats'];
        $newp = new SLAB();
        $newp->newSlabInit();
        $tempCatArray = array();
        $title = stripslashes($_POST['title']);
        foreach( $catlist as $tempCat=>$tempcc ) {
            if( isset( $_POST[ 'check_'.$tempCat ] ) ) {
                $tempCatArray[$tempCat] = $tempCat;
            }
        }
        
        // save external link data from form if save button clicked // 
        if( isset( $_POST['save'] ) ) {
            $isFormSubmitted = true;
            $externalLink = stripslashes($_POST['externallink']);
            $newp->editTitle( $title );
            $slab = $newp->slab;
            $newp->catReset();
            foreach( $catlist as $cat=>$cc ) {
                if( isset( $_POST[ 'check_'.$cat ] ) ) {
                    $newp->addToCat( $cat );
                }
            }
            if ($title != '' and $externalLink !='') {   
                if( !in_array($slab, $razorArray['slabs']) ) {
                    BsocketB('admin-xlink-info-input', array($slab));
                    $newp->commitChanges();
                    if ( isset($_POST['new-win']) ) {
                        if ( $_POST['new-win'] == 'show' ) {
                            $razorArray['ext_link_win'][$slab] = true;
                        }
                    }
                    $razorArray['ext_links'][$slab] = $externalLink;
                    saveRazorArray();
                    $m = lt("The link was created successfully"). '<br />';
                    $m .= lt("Content")." : ".substr( strip_tags($externalLink), 0, 100 ).( strlen($externalLink)>100 ? '...' : '' )."<br />";
                    MsgBox( $m );
                    return;  // return to main switch function
                } else {
                    $addtErrMsg[] = lt("Save Failed");               
                    if ( in_array($slab,$razorArray['slabs'] )) {
                        $addtErrMsg[] = lt("A link item with similar Title already exists");
                    }
                }
            } else {
                $addtErrMsg[] = lt("One of the input fields is empty, Please check your input");
            }
        }
        // end //
        
        // output any messages collected //
        if( count($addtErrMsg)!=0 and isset($title) ) {
            $em = '';
            foreach( $addtErrMsg as $msg ) {
                $em .= "<li>$msg</li>";
            }
            MsgBox( lt('Errors Occured')." : <ul>$em</ul>", 'redbox' );
        }
        // end //
        
        // set up form data //
        $formAction = "?action=extlink";
        $submitButton = lt('Add Link');
        $pageTitleLabel = lt('External Link Title');
        $urlLable = lt('URL');
        $addnewpageLabel = lt('External Link Details');
        $filteredCats = array();
        foreach ( $razorArray['links_cats'] as $linksCats=>$contents ) {
	        if ( $linksCats != $razorArray['settings']['info-bar-cat'] ) {
	            $filteredCats[$linksCats] = $linksCats;
	        }
        }
        $chkboxs = checkBoxList( $filteredCats, $tempCatArray );
        $newWinLabel = lt('Display in New Window');
        $newWinChkbox = "<input type='checkbox' name='new-win' value='show'>";
        $catsLabel = lt('Categories');
        $contentManager = lt('Content Manager - New Content');
        // end //
        
        // sockets for extra output and function output //
        $extraInfo;
        BsocketB('admin-xlink-info-output',array(&$extraInfo));
        $addFunction;
        BsocketB('admin-add-link-function',array(&$addFunction,&$content));
        // end //
        
        // ouput form for data input //
        $te[1]=<<<TET
            <h1>$contentManager</h1>
            <form action='$formAction' method=post class='pagemod_form'>
                <h2>$addnewpageLabel</h2>
                $extraInfo
                <table width='98%' border='0'>
                    <tr>
                        <td width='20%'>$pageTitleLabel</td>
                        <td><input type='text' value='$title' name='title'></td>
                        <td align='right'></td>
                    </tr>
                    <tr>
                        <td>$catsLabel</td>
                        <td colspan=2>$chkboxs</td>
                    </tr>
                    <tr>
                        <td>$newWinLabel</td>
                        <td>$newWinChkbox</td>
                    </tr>
                </table>
                <table width="98%">
        $addFunction
                    <tr><td colspan=2>
TET;
        $te[2] = "</td></tr><td width='20%'>$urlLable</td><td>http:// <input type='externallink' value='$externalLink' name='externallink'></td>";
        $te[3]=<<<TET
                        </td>
                    </tr>
                    <tr>
                        <td colspan=2>
                            <br /><input id='button' type='submit' value='$submitButton' name='save'>
                        </td>
                    </tr>
                </table>
            </form>
TET;
        echo $te[1];
        echo $te[2];
        echo $te[3];
        // end //
        
    }
    // end /////////////////////////
    
    // content manager function //
    function contentManager() {
        global $razorArray;
        $cdt = $razorArray['links_cats'];
        $slabs = $razorArray['slabs'];
        $titles = $razorArray['titles'];
        $musthaveCats = explode( ',', $razorArray['settings']['must-have-cats'] );
        $selectedCat = 1;
        $toggStat = 'false';
        
        // add new category process //
        if( isset($_GET['addcat']) ) {
            $newCatName = strtolower( stripslashes($_POST['catname']) );
            $newCatName = cleanSlabTitle( $newCatName );
            if( in_array( $newCatName, array_keys($cdt) ) ) {
                $msg = sprintf( lt( "Cannot add duplicate catagory, name already in use"), "<b>$newCatName</b>" );
                MsgBox( $msg );
            } else {
                $cdt[$newCatName] = array();
                $msg = sprintf( lt( "Category added successfully"), "<b>$newCatName</b>" );
                MsgBox( $msg,'greenbox' );
                $razorArray['links_cats'] = $cdt;
                saveRazorArray();
            }
        }
        // end //
        
        // remove category process //
        if( isset($_GET['removecat']) ) {
            $catN = $_GET['removecat'];
            if( !in_array($catN,array_keys($cdt) ) ) {
                MsgBox( lt("Category to be deleted does not exist"), 'redbox' );
            } else {
                if( in_array( $catN, $musthaveCats ) ) {
                    MsgBox( "<b>$catN</b> : ".lt('Cannot be deleted'), 'redbox' );
                } else {
                    unset( $cdt[ $catN ] );
                    $msg = sprintf( lt( "Category removed successfully"), "<b>$catN</b>" );
                    MsgBox( $msg,'greenbox' );
                    if ( $catN == $razorArray['settings']['info-bar-cat'] ) {
                    	$razorArray['settings']['info-bar-cat'] = '';
                    }
                    $razorArray['links_cats'] = $cdt;
                    saveRazorArray();
                }
            }			
        }
        // end //
        
        // allocate infobar content to page process //
        if( isset( $_GET['addInfo'] ) ) {
            $infoData = array();
            $infoKey = array();
            $infoValue = array();
            if ( isset($_POST['infoBarDes']) ) {
                foreach ($_POST['infoBarDes'] as $key=>$infoMixedData) {
                    $infoData = explode( ',', $infoMixedData );
                    array_push($infoKey,$infoData[0]);
                    array_push($infoValue,$infoData[1]); 
                }
            }
            $razorArray['info-bar-key'] = $infoKey;
            $razorArray['info-bar-value'] = $infoValue;
            saveRazorArray();
        }
        // end //
        
        // set up data to display on content manager page //
        $catSelectList = array();
        foreach( $cdt as $cN=>$cSC ) {
            $catSelectList[$cN] = $cN;
        }
        $pagesAndOpt = lt( 'Navigation Category Options' );
        $pagesListing = lt( 'Navigation Categories' );
        $infoBarTitle = lt( 'Infobar Content Allocation' );
        $addNewCat = lt( 'Add new category' );
        $addToAnotherCat = lt( 'Add link item to another category' );
        $addLabel = lt( 'Add' );
        echo '<h1>'.lt('Content Manager').'</h1>';
        $createNewLinkItem = lt('Create New Link Item');
        $createNewPage = lt('Create new page');
        $createNewXLink = lt('Create new external link');
        $createNewInfoCont = lt('Create new infobar content');
        // end //
        
        // output to content manager page - create new items //
        echo "<h2>$createNewLinkItem</h2><div id='createPage'><a href='?action=addpage'>$createNewPage</a><br /><a href='?action=extlink'>$createNewXLink</a><br />";
        if ( $razorArray['settings']['info-bar-cat'] != '' ) {
            echo "<a href='?action=addinfo'>$createNewInfoCont</a></div>";
        } else {
            echo "$createNewInfoCont</div>";
        }
        // end //
        
        // check if infobar is set //
        if ( isset($razorArray['settings']['info-bar-cat']) ) {
            if ( isset($razorArray['links_cats'][$razorArray['settings']['info-bar-cat']]) ) {
                $infobarFlag = true;
            }
        } else {
            $infobarFlag = false;
        }
        // end //
        
        // output pages only //
        echo '<h2>'.lt('Manage Link Item').'</h2>';
        echo "<div id='linkitems'>";
        echo "<table class='editPageTable'>";
        echo "<tr><th>ID </th><th>Page</th><th>Options</th></tr>";
        foreach($razorArray['slabs'] as $slabID=>$slabName) {
            if ( $infobarFlag ) {
                if (  !in_array( $slabID,$razorArray['links_cats'][$razorArray['settings']['info-bar-cat']]) and !in_array( $slabName,array_keys($razorArray['ext_links']))) {
                    $deleteConfirmMsg = lt( "Are you sure you want to delete this page, Remember Once you delete you cannot retreive again, Proceed?");
                    $delTxt = lt('Delete');
                    $s = "<tr>
                           <td>$slabID </td>
                           <td>".$titles[$slabID]."</td>
                           <td>
                             <a href='?action=edit&slab=".$slabName."'>Edit</a> | 
                             <a href='?action=delete&slab=".$slabName."' onclick='return confirm(\"$deleteConfirmMsg\");'>$delTxt</a>
                           </td>
                          </tr>";
                    echo $s;
                }
            } else {
                if ( !in_array( $slabName,array_keys($razorArray['ext_links']))) {
                    $deleteConfirmMsg = lt( "Are you sure you want to delete this page, Remember Once you delete you cannot retreive again, Proceed?");
                    $delTxt = lt('Delete');
                    $s = "<tr>
                            <td>$slabID </td>
                            <td>".$titles[$slabID]."</td>
                            <td>
                              <a href='?action=edit&slab=".$slabName."'>Edit</a> | 
                              <a href='?action=delete&slab=".$slabName."' onclick='return confirm(\"$deleteConfirmMsg\");'>$delTxt</a>
                            </td>
                          </tr>";
                    echo $s;
                }
            }
        }
        echo "</table>";
        // end //

        // output external links only //
        echo "<table class='editPageTable'>";
        echo "<tr><th>ID </th><th>X-Link</th><th>Options</th></tr>";
        foreach($razorArray['slabs'] as $slabID=>$slabName) {
            if (  in_array( $slabName,array_keys($razorArray['ext_links'])) ) {
                $deleteConfirmMsg = lt( "Are you sure you want to delete this external link, Remember Once you delete you cannot retreive again, Proceed?");
                $delTxt = lt('Delete');
                $s = "<tr>
                   <td>$slabID </td>
                   <td class='edittablerow'>".$titles[$slabID]."</td>
                   <td>
                    <a href='?action=editextlink&slab=".$slabName."'>Edit</a> | 
                    <a href='?action=delete&slab=".$slabName."' onclick='return confirm(\"$deleteConfirmMsg\");'>$delTxt</a>
                   </td>
                  </tr>";
                echo $s;
            }
        }
        echo "</table>";
        // end //

        // output infobar contents only //
        echo "<table class='editPageTable'>";
        echo "<tr><th>ID </th><th>Infobar</th><th>Options</th></tr>";
        foreach($razorArray['slabs'] as $slabID=>$slabName) {
            if ( $infobarFlag ) {
                if (  in_array( $slabID,$razorArray['links_cats'][$razorArray['settings']['info-bar-cat']]) ) {
                    $deleteConfirmMsg = lt( "Are you sure you want to delete this infobar content, Remember Once you delete you cannot retreive again, Proceed?");
                    $delTxt = lt('Delete');
                    $s = "<tr>
                       <td>$slabID </td>
                       <td>".$titles[$slabID]."</td>
                       <td>
                        <a href='?action=editinfo&slab=".$slabName."'>Edit</a> | 
                        <a href='?action=delete&slab=".$slabName."' onclick='return confirm(\"$deleteConfirmMsg\");'>$delTxt</a>
                       </td>
                      </tr>";
                    echo $s;
                }
            }
        }
        echo "</table></div>";
        // end //

        // output category options //
        echo "<div class='catoption'>";
        echo "<h2>$pagesAndOpt</h2>
            <table id='cat_options'>
                <tr>
                    <form action='?action=showpages&addcat=true' method='post'>
                        <td>$addNewCat</td><td><input type='text' name='catname'><input id='button' type='submit' value='$addLabel'></td>
                    </form>
                </tr>
            </table></div>";
        // end //
        
        $v=0;
        
        // output navigation category listings //
        echo "<div class='linkcats-div'>";
        echo "<h2>$pagesListing</h2>";
        foreach($cdt as $catname=>$catslabs) {
            if ($catname != $razorArray['settings']['info-bar-cat']) {
                $v++;
                $slabids = array_values($catslabs);
                $n = count($slabids)-1;
                if( !in_array( $catname, $musthaveCats )) {
                    $removeOpt = "( <a href='?action=showpages&removecat=$catname'>remove</a> )";
                } else {
                    $removeOpt = '';
                }
                echo "<table class='pageListTable'>";
                echo "<h3>$catname $removeOpt</h3>";
                echo "<tr><th>Page</th><th>Page Order</th><th>Page Order</th></tr>";
                if( count($slabids) == 0 ) {
                    echo "<tr><td>".lt('No pages are added under this category')."</td></tr></table>";
                    continue;
                }
                foreach($slabids as $pos=>$ids) {
                    $ul = makeLink("?action=reorder&cat=$catname&param=".$pos.','.($pos-1),'up');
                    $dl = makeLink("?action=reorder&cat=$catname&param=".$pos.','.($pos+1),'down');
                    if( $pos==0 ) {
                        $ul='up';
                    }
                    if( $pos==$n ) {
                        $dl='down';
                    }
                    $deleteConfirmMsg = lt( "Are you sure you want to delete this page, Remember Once you delete you cannot retreive again, Proceed?");
                    $delTxt = lt('Delete');
                    $s = "<tr>
                            <td>".$titles[$ids]."</td>
                            <td>$ul</td>
                            <td>$dl</td>
                          </tr>";
                    echo $s;
                }
                echo "</table>";
            }
        }
        echo "</div>";
        // end //

        // output infobar listing //
        if ( $infobarFlag ) {
            echo "<div class='linkcats-div'>";
            echo "<h2 class='infobarh'>$infoBarTitle</h2>";
            $catname = $razorArray['settings']['info-bar-cat'];
            echo "<h3>$catname</h3>";
            echo "<table class='infoListTable'>";
            echo "<tr><th>Info</th><th>Page Order</th><th>Page Order</th><th>Show on</th><th>Apply Info</th></tr>";
            echo "<form action='?action=showpages&addInfo=true' method='post'>";
            $slabids = array();
            if ( $infobarFlag ) {
                $slabids = array_values($razorArray['links_cats'][$razorArray['settings']['info-bar-cat']]);
            }
            if( count($slabids) == 0 ) {
                echo "<tr><td>".lt('No pages are added under this category')."</td></tr></form></table></div>";
            } else {
                foreach($slabids as $pos=>$ids) {
                    $ul = makeLink("?action=reorder&cat=$catname&param=".$pos.','.($pos-1),'up');
                    $dl = makeLink("?action=reorder&cat=$catname&param=".$pos.','.($pos+1),'down');
                    if( $pos==0 ) {
                        $ul='up';
                    }
                    if( $pos==$n ) {
                        $dl='down';
                    }          
                    $readSlabs = $razorArray['slabs'];
                    $readInfoKey = $razorArray['info-bar-key'];
                    $readInfoBarCat = $razorArray['settings']['info-bar-cat'];
                    $infoChkBox = '';
                    $sentName = $slabs[$ids];
                    $notShow = $razorArray['links_cats'][$readInfoBarCat];
                    foreach( $readSlabs as $slabKey=>$slabName ) {
                        if (!in_array($slabKey,$notShow) and !in_array( $slabName,array_keys($razorArray['ext_links']))) {
                            $checked = '';
                            foreach( $readInfoKey as $infoKey=>$tempInfoKey ) {
                                if ($tempInfoKey == $slabs[$ids] && $razorArray['info-bar-value'][$infoKey] == $slabName) {
                                    $checked = 'checked';
                                }
                            }
                            $infoChkBox.= "<input type='checkbox' name='infoBarDes[]' value='$sentName".","."$slabName' $checked ><label for='infobardes'>".$razorArray['titles'][$slabKey]." </label>";
                        } 
                    }
                    $s = "<tr>
		            <td>".$titles[$ids]."</td>
		            <td>$ul</td>
		            <td>$dl</td>
		            <td>".$infoChkBox."</td>
		            <td><input id='button' type='submit' value='Add Info'></td>
                          </tr>
                          <tr></tr>";
                    echo $s;
                }
	        echo "</form></table></div>";
            }
        }
        // end //
        
    }
    // end ///////////////////////

    // selection box in html forms //
    function pagesList($fieldname,$list,$selected=1) {
        $t = "<select name='$fieldname'>";
        foreach( $list as $slabid=>$title ) {
            if( $slabid == $selected ) {
                $chk = " selected='selected' ";
            } else {
                $chk = '';
            }
            $t .= "<option value='$slabid' $chk>$title</option>";
        }
        $t .= "</select>";
        return $t;
    }
    // end //////////////////////////

    // delete slab from system //
    function doDelete() {
        global $razorArray;
        $slab = $_GET['slab'];
        $slabList = $razorArray['slabs'];
        $titleList = $razorArray['titles'];
        $hp = $razorArray['homepage'];
        $delpg = new SLAB();
        $delpg->loadslab($slab);
        $title = $titleList[ $delpg->slabId ];
        if( $slab == $hp ) {
            $msg = sprintf( lt("Cannot Delete, Your homepage cannot be deleted"),$title );
            MsgBox( $msg, 'redbox' );
            return;
        }
        $delpg->catReset();
        $delpg->commitChanges();
        unset( $slabList[ $delpg->slabId ] );
        unset( $titleList[ $delpg->slabId ] );
        $fileAsID = array_search($delpg->slab, $razorArray['slabs']);
        if ( isset( $razorArray['ext_links']) ) {
            if ( in_array( $slab,array_keys($razorArray['ext_links']) ) ) {
                unset($razorArray['ext_links'][$slab]);
                if ( isset( $razorArray['ext_link_win']) ) {
                    if ( in_array( $slab,array_keys($razorArray['ext_link_win']) ) ) {
                        unset($razorArray['ext_link_win'][$slab]);
		    }
                }
            } else {
                deleteFile( RAZOR_PAGES_DIR.findPageFile( $fileAsID ) );
            }
        } else {
            deleteFile( RAZOR_PAGES_DIR.findPageFile( $fileAsID ) );
        }   
        $razorArray['slabs'] = $slabList;
        $razorArray['titles'] = $titleList;
        BsocketB('admin-on-page-delete', array($slab));   
        saveRazorArray();
        $msg = sprintf( "<strong>".lt("Link item successfully deleted").'</strong>',"<b>$title</b>" );
        echo '<br />';
        MsgBox( $msg, 'greenbox' );
    }
    // end /////////////////////


    // edit external link detials // 
    function performEditLink() {
        global $editErrMsg, $razorArray;
        $slab = $_GET['slab'];
        $addtErrMsg = array();
        $catlist = $razorArray['links_cats'];

        // process form data if clicked //
        if( isset( $_POST['save'] ) ) {
            $newp = new SLAB();
            $newp->loadSlab($slab);
            $oldSlab = $slab;
            $newSlab = cleanSlabTitle( $_POST['title'],$newp->slabId);
            $externalLink = stripslashes($_POST['externallink']);
            $title = stripslashes($_POST['title']);
            if( $title=='' ) {
                $addtErrMsg[]= lt("Title cannot be empty");
            } else {
                $newp->catReset();
                foreach( $catlist as $cat=>$cc ) {
                    if( isset( $_POST[ 'check_'.$cat ] ) ) {
                        $newp->addToCat( $cat );
                    }
                }
                $renameErr = false;
                if( $newSlab!=$oldSlab ) {	
                    if( in_array($newSlab,$razorArray['slabs'] ) ) { 
                        $addtErrMsg[] = lt("Cannot Rename Title, Another page with similar title already exists");
                        $renameErr = true;
                    } else {
                        $slab = $newSlab;
                    }
                    if( !$renameErr ) {
                        $newp->editTitle( $title );
                        unset($razorArray['ext_links'][$oldSlab]);
                    }
                }
                if ( !$renameErr ) {
                    $razorArray['ext_links'][$slab] = $externalLink;
                    if ( isset($_POST['new-win']) ) {
                        if ( $_POST['new-win'] == 'show' ) {
                            $razorArray['ext_link_win'][$slab] = true;
                        } else {
                            if ( isset($razorArray['ext_link_win'][$slab] )) {
                                unset($razorArray['ext_link_win'][$slab]);
                            }
			}
                    } else {
                        if ( isset($razorArray['ext_link_win'][$slab] )) {
                            unset($razorArray['ext_link_win'][$slab]);
                        }
                    }
                }
            }
        }
        // end //

        // output message if failed or save changes if worked //
        if( count($addtErrMsg) != 0) {
            $em = '';
            foreach( $addtErrMsg as $msg ) {
                $em .= "<li>$msg</li>";
            }
            MsgBox( lt('Errors Occured')." : <ul>$em</ul>", 'redbox' );
        } elseif ( isset($newp) && count($addtErrMsg) == 0 ) { 
            BsocketB('admin-xpage-info-input', array($slab));
            $newp->commitChanges();
            saveRazorArray();
            $em = ''; $gmsg = array();
            echo "<h2>".lt( 'Edit Content' )."</h2>";
            $gmsg[] = lt("Content Edited Successfully");
            foreach( $gmsg as $msg ) {
                $em .= "<li>$msg</li>";
            }
            MsgBox( "<ul>$em</ul>" );
            return;  // return to main switch function
        }
        // end //

        // filter categories //
        $filteredCats = array();
        foreach ( $razorArray['links_cats'] as $linksCats=>$contents ) {
            if ( $linksCats != $razorArray['settings']['info-bar-cat'] ) {
                $filteredCats[$linksCats] = $linksCats;
            }
        }
        // end //

        // set up form data //
        $ep = new SLAB();
        $ep->loadSlab($slab);
        $externalLink = $razorArray['ext_links'][$slab];
        $title = $ep->title;
        $formAction = "?action=editextlink&slab=$slab";
        $submitButton = lt('Edit Link');
        $pageTitleLabel = lt('External Link Title');
        $contentLabel = lt('');
        $urlLable = lt('URL');
        if ( isset($razorArray['ext_link_win']) ) {
            if ( in_array($slab,$razorArray['ext_link_win']) ) {
                if ( $razorArray['ext_link_win'][$slab] ) {
                    $nwchecked = 'checked';
		}
            }
	}
        $newWinLabel = lt('Display in New Window');
        $newWinChkbox = "<input type='checkbox' name='new-win' value='show' $nwchecked>";
        $addnewpageLabel = lt('External Link Details');
        $chkboxs = checkBoxList( $filteredCats, $ep->cats );
        $catsLabel = lt('Categories');
        $contentManager = lt('Content Manager - Edit Content');
        // end //        

        // sockets for extra ouput and add function //
        $extraInfo;
        BsocketB('admin-xlink-info-output',array(&$extraInfo));
        $addFunction;
        BsocketB('admin-add-link-function',array(&$addFunction,&$content));
        // end //

        // output form for data input //
        $te[1]=<<<TET
            <h1>$contentManager : $ep->title</h1>
            <form action='$formAction' method=post class='pagemod_form'>
                <h2>$addnewpageLabel</h2>
                $extraInfo
                <table width='98%' border='0'>
                    <tr>
                        <td width='20%'>$pageTitleLabel</td>
                        <td><input type='text' value='$title' name='title'></td>
                        <td align='right'></td>
                    </tr>
                    <tr>
                        <td>$catsLabel</td>
                        <td colspan=2>$chkboxs</td>
                    </tr>
                    <tr>
                        <td>$newWinLabel</td>
                        <td>$newWinChkbox</td>
                    </tr>
                </table>
                <h2>$contentLabel</h2>
                <table width="98%">
        $addFunction
                    <tr><td colspan=2>
TET;
        $te[2] = "</td></tr><td width='20%'>$urlLable</td><td>http:// <input type='externallink' value='$externalLink' name='externallink'></td>";
        $te[3]=<<<TET
                        </td>
                    </tr>
                    <tr>
                        <td colspan=2>
                            <br /><input id='button' type='submit' value='$submitButton' name='save'>
                        </td>
                    </tr>
                </table>
            </form>
TET;
        $te[4] = $content;
        echo $te[1];
        echo $te[2];
        echo $te[3];
        // end //

    }      
    // end ///////////////////////

    // edit slab and or detials // 
    function performEdit() {
        global $editErrMsg, $razorArray;
        $slab = $_GET['slab'];
        $fileAsID = array_search($slab, $razorArray['slabs']);
        $addtErrMsg = array();
        $catlist = $razorArray['links_cats'];

        // process form data //
        if( isset( $_POST['save'] ) ) {
            $newp = new SLAB();
            $newp->loadSlab($slab);
            $oldSlab = $slab;
            $title = stripslashes($_POST['title']);
            $newSlab = cleanSlabTitle( $_POST['title'],$newp->slabId );
            if( $title=='' ) {
                $addtErrMsg[]= lt("Title cannot be empty");
            } else {
                $fileName = findPageFile($slab);
                $newFileName = $newName = findPageFile( $newSlab );
                $newp->catReset();
                foreach( $catlist as $cat=>$cc ) {
                    if( isset( $_POST[ 'check_'.$cat ] ) ) {
                        $newp->addToCat( $cat );
                    }
                }
                $renameErr = false;
                if( $newSlab!=$oldSlab ) {	
                    if( in_array($newSlab,$razorArray['slabs'] ) ) { 
                        $addtErrMsg[] = lt("Cannot Rename Title, Another link item with similar title already exists");
                        $renameErr = true;
                    } else {
                   	    if ( $razorArray['homepage'] == $slab ) {  //if was homepage change to new name
                   	        $razorArray['homepage'] = $newSlab;
                   	    }
                   	    $slab = $newSlab;
                    }
                    if( !$renameErr ) {
                        $newp->editTitle( $title );
                    }
                    $fileName = $newName;
                }
                if ( !$renameErr ) {
                    if( !put2file( RAZOR_PAGES_DIR.findPageFile($fileAsID), stripslashes( $_POST['content'] ) ) ) {
                        $addtErrMsg[]=lt("Error writing to file");
                    }
                }
            }
        }
        // end //

        // ouput error message if failed or save changes if passed //
        if( count($addtErrMsg) != 0 ) {
            $em = '';
            foreach( $addtErrMsg as $msg ) {
                $em .= "<li>$msg</li>";
            }
            MsgBox( lt('Errors Occured')." : <ul>$em</ul>", 'redbox' );
        } elseif( isset($newp) && count($addtErrMsg) == 0 ) { 
            BsocketB('admin-xpage-info-input', array($slab));
            $newp->commitChanges();
            saveRazorArray();
            $em = ''; $gmsg = array();
            echo "<h2>".lt( 'Edit Content' )."</h2>";
            $gmsg[] = lt("Content Edited Successfully");
            foreach( $gmsg as $msg ) {
                $em .= "<li>$msg</li>";
            }
            MsgBox( "<ul>$em</ul>" );
            return;  // return to main switch function
        }
        // end //

        // set up form data //
        $ep = new SLAB();
        $ep->loadSlab($slab);
        $fileName = findPageFile( $fileAsID, 'admin' );
        $fileContent = file_exists( $fileName )? file_get_contents( $fileName ) : lt("no content yet");
        $submitButton = lt('Save Page Content');
        $editLabel = lt('Edit Content');
        $catLabel = lt('Categories');
        $contentLabel = lt('Content');
        $title = $ep->title;
        $contentManager = lt('Content Manager - Edit Content');
        // end //
        
        // page and infobar filter to change form data //
        $filteredCats = array();
        if ( $_GET['action'] == 'editinfo' ) {
            $chkboxs = "<input type='hidden' name='check_".$razorArray['settings']['info-bar-cat']."' value='".$razorArray['settings']['info-bar-cat']."'><label for='check_".$razorArray['settings']['info-bar-cat']."'>".$razorArray['settings']['info-bar-cat']."</label>";
            $addnewpageLabel = lt('Infobar Content Details');
            $formAction = "?action=editinfo&slab=$slab";
        } else {
            foreach ( $razorArray['links_cats'] as $linksCats=>$contents ) {
                if ( $linksCats != $razorArray['settings']['info-bar-cat'] ) {
                    $filteredCats[$linksCats] = $linksCats;
                }
            }
            $addnewpageLabel = lt('Page Details');
            $chkboxs = checkBoxList( $filteredCats, $ep->cats );
            $formAction = "?action=edit&slab=$slab";
        }
        // end //
        
        // sockets for extra output and add function //
        $extraInfo;
        $addFunction;
        if ( $_GET['action'] == 'editinfo' ) {
            BsocketB('admin-xinfo-info-output-ed',array(&$extraInfo,$slab));
            BsocketB('admin-add-info-function',array(&$addFunction,&$fileContent));
        } else {
            BsocketB('admin-xpage-info-output-ed',array(&$extraInfo,$slab));
            BsocketB('admin-add-page-function',array(&$addFunction,&$fileContent));
        }
        // end //

        // output form for data input //
        $te[1]=<<<TET
            <form action='$formAction' method=post class='pagemod_form'>
            <h1>$contentManager : $ep->title</h1>
            $extraInfo
            <table width='98%' border='0'>
                <tr>
                    <td width='20%'>Page Title</td>
                    <td><input type='text' value='$title' name='title'></td>
                    <td align='right'></td>
                </tr>
                <tr>
                    <td>$catLabel</td>
                    <td colspan=2>$chkboxs</td>
                </tr>
            </table>
            <h2>$contentLabel</h2>
            <table width="98%">
	    $addFunction
                <tr><td colspan=2>
TET;
        $te[2] = "<textarea name='content' rows=20 cols=70 id='editbox' class='editbox'>$fileContent</textarea>";
        $te[3]=<<<TET
                    </td>
                </tr>
                <tr>
                    <td colspan=2><br /><input id='button' type='submit' value='$submitButton' name='save'></td>
                </tr>
            </table>
        </form>           
TET;
        $te[4] = $fileContent;
        echo $te[1];
        BsocketB( 'editor' , array( &$te ) );
        echo $te[2];
        echo $te[3];
        // end //

    }
    // end ///////////////////////

    // admin master function switch //
    function adminFuncSwitch() {
        if( isset($_GET['action']) ) {
            switch ($_GET['action']) {
            case "addpage":
                addPage();
            break;
            case "extlink":
                addExtLink();
            break;
            case "addinfo":
                addPage();
            break;
            case 'delete':
                doDelete();
                contentManager();
            break;
            case 'edit':
                performEdit();
            break;
            case 'editinfo':
	            performEdit();
            break;
            case 'editextlink':
	    	    performEditLink();
            break;
            case 'showpages':
                contentManager();
            break;
            case 'mediaman':
                mediaManager();
            break;
            case 'securityman':
                securityManager();
            break;
            case 'reorder':
                performMove();
                contentManager();
            break;
            case 'blademan':
                showBladePacks();
            break;
            case 'settingsman':
                settingsManager();
            break;
            default:
                $defaultPage = 'theme/adminhome.php';
                BsocketB('admin-select-page', array( &$defaultPage ));
                include_once $defaultPage;
            }
        } else {
            include_once 'theme/adminhome.php';
        }
    }
    // end ///////////////////////////

    // media manager controller //
    function mediaManager() {
        $mediaFiles = array();
        $mediaDir = getSystemRoot(RAZOR_ADMIN_FILENAME).RAZOR_MEDIA_DIR;
        $mediaFiles = readDirContents($mediaDir);
        BsocketB('admin-media-data', array( &$mediaDir, &$mediaFiles ));
        if (isset($_GET['selected'])) {
            $delSuccess = delFileFromDir($mediaFiles, $mediaDir);
    	    if ($delSuccess) {
                $mediaFiles = readDirContents($mediaDir);
    	    }
        }
        if (isset($_POST['upload'])) {
            $delSuccess = uploadMedia();
    	    if ($delSuccess) {
                $mediaFiles = readDirContents($mediaDir);
    	    }
        }
        displayDirContents($mediaFiles);
    }
    // end ///////////////////////

    // upload media to server //
    function uploadMedia() {
        if (isset($_POST['upload'])) {
            $filename = basename($_FILES['file-upload']['name']);
            $stripFileName = explode( '.', $filename );
            if ( $stripFileName[1] == 'jpg' || $stripFileName[1] == 'png' || $stripFileName[1] == 'gif' || $stripFileName[1] == 'swf') {
                $mediaDir = getSystemRoot(RAZOR_ADMIN_FILENAME).RAZOR_MEDIA_DIR;
                $mediaFiles = readDirContents($mediaDir);
                $counter = 0;
                while ( in_array( $filename, $mediaFiles ) ) {
                    $counter++;
                    $filename = $stripFileName[0].'('.$counter.')'.'.'.$stripFileName[1];
                }
                $result = uploadFile(RAZOR_MEDIA_DIR.$filename, $_FILES['file-upload']['tmp_name'], FTP_BINARY);
                return $result;
            } else {
                MsgBox( lt("Wrong file type, only jpg, png, gif or swf file types allowed"), 'redbox' );
                return false;
            }
        } else {
            return false;
        }
    }
    // end /////////////////////

    // read dir contents //
    function readDirContents($dir) {
        $imageFiles = array();
        $imageContents = opendir($dir);
        if (! $imageContents) {
            die('Cannot list files for ' . $dir);
        }
        while ($imageFilename = readdir($imageContents)) {
            if ($imageFilename == '.' || $imageFilename == '..') {
                continue;
            }
            $imageFiles[$imageFilename] = $imageFilename;
        }
        closedir($imageContents);
        return $imageFiles;
    }
    // end read dir contents //

    // delete file from media dir //
    function delFileFromDir($fileArray, $dir) {
        $selected = '';
        if (isset($_GET['selected'])) {
            $fileflag = false;
            $selected = $_GET['selected'];
            foreach($fileArray as $key => $imageFilename) {
                if ($selected == $imageFilename) {
                    $fileflag = true;
                }
            }
            if ($fileflag == true) {
                $imageContents = opendir($dir);
                deleteFile(RAZOR_MEDIA_DIR.$selected);
                $selected = '';
                $success = true;
            } else {
                echo lt('File does not exist, deletion aborted');
                $selected = '';
                $success = false;
            }
            return $success;
        }
    }
    // end ////////////////

    // output media dir contents //
    function displayDirContents($filesArray) {
        sort( $filesArray );
        echo '<h1>'.lt('Media Manager').'</h1>';
        echo '<p>'.lt('To upload media in either jpg, gif, png or swf formats, please use the file upload function below. Please note that file upload is limited to 200kb per file, if you try to upload a file bigger than this, the upload will fail.').'</p>';
        echo '<form enctype="multipart/form-data" action="?action=mediaman" method="POST">
            <input type="hidden" name="MAX_FILE_SIZE" value="200000" />
            '.lt('File to upload').' : <input name="file-upload" type="file" />
            <input id="button" type="submit" value="upload file" name="upload"/>
            </form>';
        echo '<p>'.lt('To delete an upload permenantly from the server, please click on delete next to the filename. In addition to deleting a fle, you can also view the file by clicking view next to the files name.').'</p><table class="mediaListTable">';
        foreach($filesArray as $key => $imageFilename) {
            echo '<tr><td class="media">'.$imageFilename.'</td>
                <td class="media"><a href="../'.RAZOR_MEDIA_DIR.$imageFilename.'" target="_blank">'.lt('VIEW').'</a></td>
                <td class="media"><a href="?action=mediaman&selected='.$imageFilename.'" onclick="return confirm(\"'.lt('Are you sure you want to permenantly delete ').$imageFilename.'?\");">'.lt('DELETE').'</a></td></tr>';
        }
        echo '</table>';
    }
    // end //////////////////

    // security manager main screen //
    function securityManager() {
        if( RAZOR_FTP_SERVER && RAZOR_FTP_USER && RAZOR_FTP_PASS && RAZOR_FTP_PATH ) {
            echo '<h1>'.lt('Security Manager').'</h1><p>'.lt('You are currently running under ftp mode, please set file permissions using a seperate ftp client, this tool is primarily for interacting with apache owned files and is not needed under ftp mode, However if you do not see green below, use your ftp client to set your permission correctly.').'</p><br />';
        } else {
            echo '<h1>'.lt('Security Manager').'</h1><p>'.lt('Use the links below to set or unset permissions of apache owned files contained within the datastore directory. This tool is used to ensure apache owned files have safe permissions set.').'</p>';
            echo '<p>'.lt('If you wish to uninstall razorCMS from your server, you must unset all apache owned files, failure to do this may mean you cannot fully delete the system from your server. If at any point you see red below, use the set link to set your apache owned files safe again.').'</p>';
            echo '<p>'.lt('PLEASE NOTE : This feature only supported by unix type servers.').'</p>';
            echo "<p><a href='?action=securityman&permissions=unset' onclick='return confirm(\"".lt('Are you sure you want to unset all permissions of apache owned files THIS IS A SECURITY RISK')."?\");'>".lt('Unset all apache owned files')."</a></p>";
            echo "<p><a href='?action=securityman&permissions=set' onclick='return confirm(\"".lt('Are you sure you want to set all permissions of apache owned files')."?\");'>".lt('Set all apache owned files')."</a></p>";
        }
    
        // set directories and files //
        $pages_Dir = getSystemRoot(RAZOR_ADMIN_FILENAME).RAZOR_PAGES_DIR;
        $media_Dir = getSystemRoot(RAZOR_ADMIN_FILENAME).RAZOR_MEDIA_DIR;
        $razor_Data = getSystemRoot(RAZOR_ADMIN_FILENAME).RAZOR_DATA;
        // end //

        // change permissions //
        if (isset($_GET['permissions'])) {
            changePermissions($pages_Dir, $media_Dir, $razor_Data);
        }
        // end //

        $permSetting = readApacheFilePerm($pages_Dir, $media_Dir, $razor_Data); // read permissions
        displayPerm($permSetting); // display permissions
    }
    // end //////////////////////////

    // chmod dir contents //
    function chmodDirContents($dir, $perm) {
        $paDirContents = opendir($dir);
        if (! $paDirContents) {
            die('Cannot list files for ' . $dir);
        }
        while ($paDirFilename = readdir($paDirContents)) {
            if ($paDirFilename == '.' || $paDirFilename == '..') {
                continue;
            }
            chmod($dir.$paDirFilename, $perm);
        }
        closedir($paDirContents);
    }
    // end ////////////////	

    // change setting //
    function changePermissions($pages_Dir, $media_Dir, $razor_Data) {
        $permissionsTemp = $_GET['permissions'];
        if ($permissionsTemp == 'unset' || $permissionsTemp == 'set') {
            if ($permissionsTemp == 'set') {
                chmod($media_Dir, 0755);
                chmodDirContents($media_Dir, 0644);
                chmod($pages_Dir, 0755);
                chmodDirContents($pages_Dir, 0644);
                chmod($razor_Data, 0644);
            } else {
                chmod($media_Dir, 0777);
                chmodDirContents($media_Dir, 0777);
                chmod($pages_Dir, 0777);
                chmodDirContents($pages_Dir, 0777);
                chmod($razor_Data, 0777);
            }
        }
    }
    // end /////////////

    // read dir contents //
    function readDirContentsPerm($dir) {
        $permArray = array();
        $dirContents = opendir($dir);
        if (! $dirContents) {
            die('Cannot list files for ' . $dir);
        }
        while ($dirFilename = readdir($dirContents)) {
            if ($dirFilename == '.' || $dirFilename == '..') {
                continue;
            }
            $permArray[$dirFilename] = sprintf('%o', fileperms($dir.$dirFilename));
        }
        closedir($dirContents);
        return $permArray;
    }
    // end ////////////////

    // display outcome of permissions check //
    function displayPerm($permissions) {
        if ($permissions == 'set') {
            echo '<div id="safe"><p>'.lt('Security - safe').'</p>';
            echo '<p>'.lt('All files are currently safe').'<br /><br />D-0755 F-0644</p></div>';  
        } else {
            echo '<div id="unsafe"><p>'.lt('Security - WARNING NOT SAFE').'</p>';
            echo '<p>'.lt('A file is currently unsafe').'<br /><br />'.lt('Please make all files safe using link above.').'</p></div>';  
        }
    }
    // end ///////////////////////////////////

    // read apache owned file permissions //
    function readApacheFilePerm($pages_Dir, $media_Dir, $razor_Data) {
        $permArray[1] = sprintf('%o', fileperms($media_Dir));
        $permArray[1] = $permArray[1].'D';
        $permArray[2] = sprintf('%o', fileperms($pages_Dir));
        $permArray[2] = $permArray[2].'D';
        $permArray[3] = sprintf('%o', fileperms($razor_Data));
        $permArray[3] = $permArray[3].'F';
        $permArrayImages = readDirContentsPerm($media_Dir);
        $permArrayPages = readDirContentsPerm($pages_Dir);
        $permissions = '';    
        foreach ($permArray as $tempValue) {
            if (($permissions == '' || $permissions == 'set') && ($tempValue == '40755D' || $tempValue == '100644F')) {
                $permissions = 'set';
            } else {
                $permissions = 'unset';
            }
        }
        foreach ($permArrayImages as $tempValue) {
            if (($permissions == '' || $permissions == 'set') && ($tempValue == '100644')) {
                $permissions = 'set';
            } else {
                $permissions = 'unset';
            }
        }
        foreach ($permArrayPages as $tempValue) {
            if (($permissions == '' || $permissions == 'set') && ($tempValue == '100644')) {
                $permissions = 'set';
            } else {
                $permissions = 'unset';
            }
        }
        return $permissions;
    }
    // end /////////////////////////////////

    // show blade packs installed //
    function showBladePacks() {
        global $bladeInterfaceList, $bladeList, $bladeData, $razorArray;
        $activeBlades = $razorArray['active-bladepack'];
        $descTxt = lt('Description');
        $optTxt = lt('Options');
        
        // process form data //
        if( isset( $_GET['do'] ) ) {
            $do = $_GET['do'];
            $blade = $_GET['blade'];
            if( $do == 'activate' && !in_array( $blade, $activeBlades ) ) {
                $activeBlades[] = $blade;
                echo MsgBox( lt('Blade Pack Activated'));
            }
            if( $do == 'deactivate' && in_array( $blade, $activeBlades ) ) {
                $activeBlades = array_diff( $activeBlades, (array)$blade );
                echo MsgBox( lt( 'Blade Pack Deactivated' ) );
            }
            $razorArray['active-bladepack'] = $activeBlades;
            saveRazorArray();
        }
        // end //

        // output text and table for blades installed //
        $bladeerDescTxt = lt("Blade Packs are sets of blades, each blade can be allocated to a socket to add extra functionality to the base system.<br>The base system is capable of using many blades, even allocating more than one to a single slot.<br /><br />Use the manager to activate and deactivate your blade packs.");
        echo "<h1>Blade Manager</h1>";
        echo "<p>$bladeerDescTxt<br></p>";
        echo "<h2>".lt('Installed Blade Packs')."</h2>";
        $t = "<table class='pageListTable'>";
        $t.= "<tr class='th'><th>Blade Pack $nameTxt</th><th>$descTxt</th><th>Blades</th><th>Control</th></tr>";
        foreach( $bladeData as $bladeName=>$bladeInfo ) {
            if( in_array( $bladeName , $activeBlades ) ) {
                $Lable = makeLink( "?action=blademan&do=deactivate&blade=$bladeName", lt('Deactivate') );
            } else {
                $Lable = makeLink( "?action=blademan&do=activate&blade=$bladeName",lt('Activate') );
            }
            $desc = $bladeData[ $bladeName ][ 'desc' ];
            $name = $bladeData[ $bladeName ][ 'name' ];
            $twk = $bladeData[ $bladeName ][ 'blades' ];
            $tcnt = count( $twk );
            $t.= "<tr><td>$name</td><td> $desc</td><td class='center'>$tcnt</td><td>$Lable</td></tr>";
        }
        $t.= "</table>";
        echo $t;
        // end //

    }
    // end /////////////////////////

    // new settings management //
    function settingsManager() {
        global $razorArray;

        // process settings changed //
        if (isset($_GET['savesettings'])) {
            if ($_GET['savesettings'] == 'true') {
                $razorArray['settings']['site-name'] = htmlspecialchars(stripslashes($_POST['sitename']), ENT_QUOTES);
                $razorArray['settings']['site-slogan'] = htmlspecialchars(stripslashes($_POST['siteslogan']), ENT_QUOTES);
                $razorArray['settings']['copyright-footer'] = htmlspecialchars(stripslashes($_POST['copyright']), ENT_QUOTES);
                $razorArray['settings']['default-page-ext'] = $_POST['defPageExt'];
                $razorArray['homepage'] = $_POST['homepage'];
                foreach ($_POST['catselect'] as $key=>$selected) {
                    $result = $result.','.$selected; 
                }
                $razorArray['settings']['must-have-cats'] = $result;
                saveRazorArray();
            } else {
                die("cannot save settings");
            }
        }
        // end //

        // sockets for processing new settings //
        BsocketB('admin-settings-add1');
        BsocketB('admin-settings-add2');
        BsocketB('admin-settings-add3');
        // end //

        // load settings //
        $siteName = $razorArray['settings']['site-name'];
        $siteSlogan = $razorArray['settings']['site-slogan'];
        $copyrightFooter = $razorArray['settings']['copyright-footer'];
        $defPageExt = $razorArray['settings']['default-page-ext'];
        // end //

        // read in catagories protected //
        $readCats = $razorArray['links_cats'];
        $selectedCats = explode( ',', $razorArray['settings']['must-have-cats'] );
        foreach( $readCats as $singleCat=>$contents ) {
            if ( $singleCat != $razorArray['settings']['info-bar-cat'] ) {
                $checked = '';
                if (in_array($singleCat, $selectedCats)) {
                    $checked = 'checked';
                }
                $outcome.= "<input type='checkbox' name='catselect[]' value='$singleCat' $checked ><label for='catselect'>$singleCat</label><br />";
            }
        }
        // end //

        // read in default ext //
        $phpFlag = '';
        $txtFlag = '';
        $htmFlag = '';
        $htmlFlag = '';
        switch ($defPageExt) {
            case "php":
                $phpFlag = 'checked';
            break;
            case 'txt':
                $txtFlag = 'checked';
            break;
            case 'htm':
                $htmFlag = 'checked';
            break;
            case 'html':
                $htmlFlag = 'checked';
            break;
        }
        $output2 = "<input type='radio' name='defPageExt' value='php' $phpFlag ><label for='catselect'>.php</label><br />";
        $output2.= "<input type='radio' name='defPageExt' value='txt' $txtFlag ><label for='catselect'>.txt</label><br />";
        $output2.= "<input type='radio' name='defPageExt' value='htm' $htmFlag ><label for='catselect'>.htm</label><br />";
        $output2.= "<input type='radio' name='defPageExt' value='html' $htmlFlag ><label for='catselect'>.html</label><br />";
        // end //
        
        // check if infobar cat is set //
        if ( isset($razorArray['settings']['info-bar-cat']) ) {
            if ( isset($razorArray['links_cats'][$razorArray['settings']['info-bar-cat']]) ) {
                $infobarFlag = true;
            }
        } else {
            $infobarFlag = false;
        }
        // end //
        
        // filter slabs and output homepage radio buttons //
        $slabTitles = $razorArray['titles'];
        foreach($razorArray['slabs'] as $slabID=>$slabName) {
            $checked = '';
            if ( $infobarFlag ) {
                if (  !in_array( $slabID,$razorArray['links_cats'][$razorArray['settings']['info-bar-cat']]) and !in_array( $slabName,array_keys($razorArray['ext_links']))) {
                    if ($slabName == $razorArray['homepage']) {
                        $checked = 'checked';
                    }
                    $homepage.= "<input type='radio' name='homepage' value='$slabName' $checked ><label for='homepage'>".$slabTitles[$slabID]." </label>";  
                }
            } else {
                if ( !in_array( $slabName,array_keys($razorArray['ext_links']))) {
                    $homepage.= "<input type='radio' name='homepage' value='$slabName' $checked ><label for='homepage'>".$slabTitles[$slabID]." </label>";
                    if ($slabName == $razorArray['homepage']) {
                        $checked = 'checked';
                    }
                }
            }
        }
        // end //
        
        displaySettings($siteName,$siteSlogan,$copyrightFooter,$output2,$outcome,$homepage);
    }
    // end /////////////////////////////////

    // display all settings related info to screen //
    function displaySettings($siteName,$siteSlogan,$copyrightFooter,$output2,$outcome,$homepage) {
        echo '<h1>'.lt('Settings Manager').'</h1>';
        echo "<table class='settingsman'><form action='?action=settingsman&savesettings=true' method='post'>";
        echo "<input type='hidden' name='sitesettings' value='Website Settings'>
                <tr valign='top'>
                    <td>".lt('Website Name')." : </td>
                    <td><input class='w300' type='text' name='sitename' value='$siteName'></td>
                </tr>
                <tr valign='top'>
                    <td>".lt('Website Slogan')." : </td>
                    <td><input class='w300' type='text' name='siteslogan' value='$siteSlogan'></td>
                </tr>
                <tr valign='top'>
                    <td>".lt('Copyright Footer')." : </td>
                    <td><input class='w300' type='text' name='copyright' value='".stripslashes($copyrightFooter)."'></td>
                </tr>
                <tr valign='top'>
                    <td>".lt('Default Page Ext')." : </td>
                    <td>";
        echo $output2;
        echo "</td></tr>
                <tr valign='top'>
                    <td>".lt('Protect Catagories')." : </td>
                    <td>";
        echo $outcome;
        echo "</td></tr>
	         <tr valign='top'>
	            <td>".lt('Set Homepage')." : </td>
	            <td>";
        echo $homepage;
        echo "</td>
                </tr>
                <tr>
                    <td><input id='button' type='submit' value='Save' class='floatright'></td>
                </tr>
            </form></table>";

        // sockets for displaying new settings //
        BsocketB('admin-settings-display1');
        BsocketB('admin-settings-display2');
        BsocketB('admin-settings-display3');
        // end //

    }
    // end //////////////////////////////////////////
?>
