<?php
/**
 * \mainpage Moonmoth CMS
 *
 * This folder contains developer documentation for
 * <a href="http://felix.plesoianu.ro/moonmoth/">Moonmoth CMS</a>.
 *
 * \version 1.0.1 (2008-06-03)
 * \author Felix Pleşoianu <felixp7@yahoo.com>

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
*/
error_reporting(E_ALL);

/// Name of your website; will appear in the title bar and as default header.
$SITE_NAME = 'A Website';
/// Where are your HTML files located? Default is current directory.
$CONTENT_DIR = '.';
/// URL of external stylesheet, if any.
$CSS = null;
/// File to include as header, if any.
$HEADER = null;
/// File to include as footer, if any.
$FOOTER = null;
/// URL of companion newsfeed script, if installed and desired.
$NEWSFEED = null;
/// External template file, if any.
$TPL_FILE = null;
/// Declare extra boxes, if any.
$BOXES = array();

@include 'moonmoth-cfg.php';

$app_dir = dirname($_SERVER['SCRIPT_NAME']);
if ($app_dir == '/') $app_dir = '';
$tpl_vars = array(
	'self' => $_SERVER['SCRIPT_NAME'],
	'app-dir' => $app_dir,
	'site-name' => $SITE_NAME);

$TEMPLATE = <<<TPL
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
        "http://www.w3.org/TR/html4/loose.dtd">
<html>
 <head>
  <title>%%page-title%% | %%site-name%%</title>
  <meta http-equiv="Content-type" content="text/html; charset=utf-8" />
  <link href="%%self%%" rel="top" type="text/html" title="Home" />
  <link href="%%self%%/sitemap" rel="contents" type="text/html" title="Sitemap" />
  <style type="text/css">
body { Margin: 0; }
.header {
	Background-color: #e0e0e0; Color: #000000;
	Border-bottom: 1px outset #e0e0e0;
	Padding: 0.5em 1em;
}
.header h1 { Margin: 0; }
.header ul { Float: right; Margin: 0; Padding: 0; List-style: none; }
.header li { Float: left; Padding: 0.5em; }
.nav { Width: 20%; Float: right; Clear: right; Color: #000000; }
.nav ul {
	List-style: none; Margin: 1em; Padding: 0;
	Background-color: #e0e0e0;
	Border: 2px groove white;
}
.nav li { Border: 1px outset #e0e0e0; Padding: 0.5em 1em; Text-align: center; }
li.active { Font-weight: bold; }
.header a, .nav a { Display: block; Color: #0000ff; Text-decoration: none; }
.section { Width: 79%; Float: left; }
#content { Padding: 5%; }
#skip-nav { Display: none; }
.footer { Padding: 0.5em 1em; Clear: both; Border-top: 3px outset #e0e0e0; }
  </style>
%%meta%%
 </head>

 <body>
  <div class="header">
   %%header%%
   %%nav%%
  </div>

  <div class="section">
   <div id="content">%%content%%</div>
  </div>

  <div class="nav">
   %%peers%%
   %%subpages%%
   <ul>
    <li><a href="%%self%%" rel="home">Home</a></li>
    <li><a href="%%self%%/sitemap">Sitemap</a></li>
   </ul>
  </div>

  <div class="footer">
   %%footer%%
  </div>
 </body>
</html>
TPL;

if (!empty($TPL_FILE) && is_file($TPL_FILE) && is_readable($TPL_FILE)) {
	$tpl_text = file_get_contents($TPL_FILE);
} else {
	$tpl_text = $TEMPLATE;
}

$settings = array(
	'tpl-vars' => $tpl_vars,
	'template' => $tpl_text,
	'default_view' => 'page',
	'boxes' => array_merge(
		array('nav', 'subpages', 'peers', 'header', 'footer', 'meta'),
		$BOXES));

function page_view($path, $tpl_vars) {
	global $CONTENT_DIR;

	$pages = page_list($CONTENT_DIR);

	if (count($path) == 0) $path[0] = $pages[0];

	$pathname = implode(DIRECTORY_SEPARATOR, $path);
	$filename = $CONTENT_DIR . DIRECTORY_SEPARATOR . "$pathname.html";

	if (is_file($filename) && is_readable($filename)) {
		$content = file_get_contents($filename);
		$content = render($content, $tpl_vars);
	} else {
		$content = "Sorry, can't read " . $pathname;
	}

	return array('content' => $content, 'page-title' => $pathname);
}

function sitemap_view($path, $tpl_vars) {
	return array('content' => html_sitemap(), 'page-title' => 'Sitemap');
}

/// \defgroup boxes Boxes - blocks of content that appear on every page.
///
/// These functions are called indirectly from website().

/// \ingroup boxes
function nav_box($location, $tpl_vars) {
	global $CONTENT_DIR;

	$pages = page_list($CONTENT_DIR);

	if (count($location['data']) > 0) {
		$active = $location['data'][0];
	} else if (count($pages) > 0) {
		$active = $pages[0];
	} else {
		$active = '';
	}

	return page_list2html($pages, $active);
}

/// Render list of pages on the same level as the current page. \ingroup boxes
function peers_box($location, $tpl_vars) {
	global $CONTENT_DIR;

	if (count($location['data']) == 0) {
		$pages = page_list($CONTENT_DIR);
		$active = $pages[0];
	} else {
		$active = array_pop($location['data']);
	}

	$page_dir = implode(
		DIRECTORY_SEPARATOR,
		array_merge(array($CONTENT_DIR), $location['data']));

	if (is_dir($page_dir) && is_readable($page_dir)) {
		return page_list2html(
			page_list($page_dir), $active, $location['data']);
	}
}

/// \ingroup boxes
function subpages_box($location, $tpl_vars) {
	global $CONTENT_DIR;

	if (count($location['data']) == 0) {
		$pages = page_list($CONTENT_DIR);
		$location['data'][] = $pages[0];
	}

	$page_dir = implode(
		DIRECTORY_SEPARATOR,
		array_merge(array($CONTENT_DIR), $location['data']));

	if (is_dir($page_dir) && is_readable($page_dir)) {
		return page_list2html(
			page_list($page_dir), null, $location['data']);
	}
}

/// \ingroup boxes
function header_box($location, $tpl_vars) {
	global $HEADER;

	if (!empty($HEADER) && is_file($HEADER) && is_readable($HEADER)) {
		$header_text = file_get_contents($HEADER);
	} else {
		$header_text = '<h1>%%page-title%% | %%site-name%%</h1>';
	}

	return render($header_text, $tpl_vars);
}

/// \ingroup boxes
function footer_box($location, $tpl_vars) {
	global $FOOTER;

	if (!empty($FOOTER) && is_file($FOOTER) && is_readable($FOOTER)) {
		return render(file_get_contents($FOOTER), $tpl_vars);
	} else {
		return '';
	}
}

/// \ingroup boxes
function meta_box($location, $tpl_vars) {
	global $CSS, $NEWSFEED;

	$output = '';

	if (!empty($CSS)) {
		$tpl = '<link rel="stylesheet" type="text/css" href="%s"/>';
		$output .= sprintf($tpl . "\n", $CSS);
	}

	if (!empty($NEWSFEED)) {
		$tpl = '<link rel="alternate"'
			. ' type="application/rss+xml" href="%s"/>' . "\n";
		$output .= sprintf($tpl, $NEWSFEED);
	}

	return $output;
}

/// \defgroup util Utility functions

/// Generate list of pages on the specified level; uses caching. \ingroup util
function page_list($dir) {
	static $pages = array();

	if (isset($pages[$dir])) return $pages[$dir];

	$cwd = getcwd();
	if (!@chdir($dir)) return array();
	$files = glob('*.html');
	chdir($cwd);

	$matches = array();
	$pages = array();
	foreach ($files as $filename) {
		preg_match('/^(.*)\.html$/', $filename, $matches);
		$pages[$dir][] = $matches[1];
	}
	
	return $pages[$dir];
}

/// \ingroup util
function page_list2html($pages, $active, $location = array()) {
	static $link_tpl1 = "<li><a href=\"%s/page:%s\">%s</a></li>\n";
	static $link_tpl2 =
		"<li class=\"active\"><a href=\"%s/page:%s\">%s</a></li>";

	$output = "<ul>\n";
	foreach ($pages as $page) {
		$path = implode(':', array_merge($location, array($page)));
		if ($page == $active) {
			$output .= sprintf($link_tpl2,
				$_SERVER['SCRIPT_NAME'], $path, $page);
		} else {
			$output .= sprintf($link_tpl1,
				$_SERVER['SCRIPT_NAME'], $path, $page);
		}
	}
	$output .= "</ul>\n";

	return $output;
}

/// \ingroup util
function html_sitemap($location = array()) {
	global $CONTENT_DIR;
	static $link_tpl1 = "<li><a href=\"%s/page:%s\">%s</a></li>\n";

	$page_dir = implode(
		DIRECTORY_SEPARATOR,
		array_merge(array($CONTENT_DIR), $location));
	$pages = page_list($page_dir);

	$output = "<ul>\n";
	foreach ($pages as $page) {
		$output .= "<li>\n";

		$new_location = array_merge($location, array($page));
		$path = implode(':', $new_location);
		$output .= sprintf($link_tpl1,
			$_SERVER['SCRIPT_NAME'], $path, $page);
		$output .= html_sitemap($new_location);

		$output .= "</li>\n";
	}
	$output .= "</ul>\n";
	return $output;
}

/// \defgroup website Fcp.Website framework functions.

/// \ingroup website
function website($settings) {
	if (isset($settings['tpl-vars']) && is_array($settings['tpl-vars'])) {
		$T = $settings['tpl-vars'];
	} else {
		$T = array();
	}

	$location = parse_location($settings['default_view']);

	$T = array_merge($T, $location['view']($location['data'], $T));

	if (isset($settings['boxes']) && is_array($settings['boxes'])) {
		foreach ($settings['boxes'] as $box_name) {
			$box_func = $box_name . '_box';
			if (function_exists($box_func)) {
				$T[$box_name] =
					$box_func($location, $T);
			} else {
				$T[$box_name] = "(missing content: $box_name)";
			}
		}
	}

	print render($settings['template'], $T);
}

/// \ingroup website
function parse_location($default_view) {
	$url_split = explode('/', $_SERVER['REQUEST_URI']);
	$location = end($url_split);
	if ($location == basename($_SERVER['SCRIPT_NAME'])) {
		$location_data = array($default_view);
	} else if (empty($location)) {
		$location_data = array($default_view);
	} else {
		$location_data =
			array_map('urldecode', explode(':', $location));
	}
	$view_function = $location_data[0] . '_view';

	if (function_exists($view_function)) {
		return array(
			'view' => $view_function,
			'data' => array_slice($location_data, 1));
	} else {
		return array('view' => 'error_page', 'data' => array());
	}
}

/// Return $str with template variable delimiters. \ingroup website
function to_template_var($str) {
	return "%%$str%%";
}

/// \ingroup website
function render($template, $tpl_vars) {
	$replaced = str_replace(
		array_map('to_template_var', array_keys($tpl_vars)),
		array_values($tpl_vars),
		$template);
	// Clean up leftover template vars.
	return preg_replace('/%%[^%]*%%/', '', $replaced);
}

/// \ingroup website
function error_page($tpl_vars) {
	if (isset($tpl_vars['error']))
		$content = $tpl_vars['error'];
	else
		$content = 'Page not found';

	return array('page_title' => 'Error', 'content' => $content);
}

website($settings);
?>
