<?php
error_reporting(E_ALL);

/// Name of your website; will appear in the title bar and as default header.
$SITE_NAME = 'A Website';
/// Where are your HTML files located? Default is current directory.
$CONTENT_DIR = '.';
/// Base URL of the actual site (defaults to current server and directory).
$SITE_URL = '';
/// Description of your website; will appear in the newsfeed.
$SITE_DESC = 'Site Updates';
/// What to add between base URL and page title. 
$SCRIPT_PREFIX = '/index.php/page:';
/// Like \ref $SITE_DESC but for comment pages, if available.
$COMMENT_PREFIX = '';

@include 'moonmoth-cfg.php';

function page_list($dir) {
	$cwd = getcwd();
	if (!@chdir($dir)) return array();
	$files = glob('*.html');
	chdir($cwd);

	$matches = array();
	$pages = array();
	foreach ($files as $filename) {
		preg_match('/^(.*)\.html$/', $filename, $matches);
		$pages[$matches[1]] = filemtime(
			$dir . DIRECTORY_SEPARATOR . $filename);
	}

	return $pages;
}

function sitemap($location = array()) {
	global $CONTENT_DIR;

	$page_dir = implode(
		DIRECTORY_SEPARATOR,
		array_merge(array($CONTENT_DIR), $location));
	$pages = page_list($page_dir);

	$allpages = array();
	foreach ($pages as $page => $timestamp) {
		$new_location = array_merge($location, array($page));
		$path = implode(':', $new_location);
		$allpages[$path] = $timestamp;
		$allpages += sitemap($new_location);
	}
	return $allpages;
}

$pages = sitemap();
arsort($pages);

if (empty($SITE_URL)) {
	$SITE_URL = 'http://'
		. $_SERVER['SERVER_NAME']
		. dirname($_SERVER['SCRIPT_NAME']);
}

header('Content-type: application/rss+xml');
// A naked XML declaration causes trouble when short_open_tag is on.
print '<?xml version="1.0" encoding="utf-8"?>' . "\n";
?>
<rss version="2.0">
 <channel>
  <title><?php print $SITE_NAME; ?></title>
  <link><?php print $SITE_URL; ?></link>
  <description><?php print $SITE_DESC; ?></description>

  <?php foreach ($pages as $title => $timestamp): ?>
   <item>
    <title><?php print $title; ?></title>
    <pubDate><?php print date('D, F d Y H:i:s T', $timestamp); ?></pubDate>
    <link><?php print $SITE_URL . $SCRIPT_PREFIX . $title; ?></link>
<?php
	$filename = $CONTENT_DIR . DIRECTORY_SEPARATOR .
		str_replace(':', DIRECTORY_SEPARATOR, $title) . ".html";
?>
    <?php if (is_file($filename) && is_readable($filename)): ?>
     <description>
      <?php print htmlspecialchars(file_get_contents($filename)); ?>
     </description>
    <?php endif; ?>
    <?php if (!empty($COMMENT_PREFIX)): ?>
     <comments><?php print $SITE_URL . $COMMENT_PREFIX . $title; ?></comments>
    <?php endif; ?>
   </item>
  <?php endforeach; ?>
 </channel>
</rss>
