<?php
class Pages
{

  var $aPages = null;
  var $aPagesChildrens = null;
  var $aPagesParentsTypes = null;
  var $aPagesParents = null;
  var $aPageParents = null;
  var $mData = null;

  function &getInstance( ){  
    static $oInstance = null;
    if( !isset( $oInstance ) ){  
      $oInstance = new Pages( );  
    }  
    return $oInstance;  
  } // end function getInstance

  /**
  * Constructor
  * @return void
  */
  function Pages( ){
    $this->generateCache( );
  } // end function Pages

  /**
  * Return pages to menu
  * @return string
  * @param string $sFile
  * @param int    $iType
  * @param int    $iPageCurrent
  * @param int    $iDepthLimit
  */
  function throwMenu( $sFile, $iType, $iPageCurrent = null, $iDepthLimit = 1 ){

    if( !isset( $this->aPagesParentsTypes[$iType] ) )
      return null;
    $this->mData = null;
    
    if( isset( $iPageCurrent ) )
      $this->generatePageParents( $iPageCurrent );

    $this->generateMenuData( $iType, $iPageCurrent, $iDepthLimit, 0 );
    if( isset( $this->mData[0] ) ){
      $oTpl     =& TplParser::getInstance( );
      $content  = null;
      $i        = 0;
      $iCount   = count( $this->mData[0] );

      foreach( $this->mData[0] as $iPage => $bValue ){
        $aData = $this->aPages[$iPage];

        $aData['sSubContent'] = isset( $this->mData[$iPage] ) ? $this->throwSubMenu( $sFile, $iPage, $iPageCurrent, 1 ) : null;

        $aData['iStyle']    = ( $i % 2 ) ? 0: 1;
        $aData['sStyle']    = ( $i == ( $iCount - 1 ) ) ? 'L': $i + 1;
        $aData['iDepth']    = 0;
        $aData['sSelected'] = ( $aData['iPage'] == $iPageCurrent ) ? $oTpl->tbHtml( $sFile, 'SELECTED' ) : null;

        $oTpl->setVariables( 'aData', $aData );
        $content .= $oTpl->tbHtml( $sFile, 'LIST' );

        $i++;
      } // end foreach

      if( isset( $content ) ){
        $aData['sMenuType'] = $GLOBALS['aMenuTypes'][$iType];
        $oTpl->setVariables( 'aData', $aData );
        return $oTpl->tbHtml( $sFile, 'HEAD' ).$content.$oTpl->tbHtml( $sFile, 'FOOT' );
      }
    }
  } // end function throwMenu

  /**
  * Display sub menu
  * @return string
  * @param string $sFile
  * @param int    $iPageParent
  * @param int    $iPageCurrent
  * @param int    $iDepth
  */
  function throwSubMenu( $sFile, $iPageParent, $iPageCurrent, $iDepth = 1 ){
    if( isset( $this->mData[$iPageParent] ) ){
      $oTpl     =& TplParser::getInstance( );
      $content  = null;
      $i        = 0;
      $iCount   = count( $this->mData[$iPageParent] );

      foreach( $this->mData[$iPageParent] as $iPage => $bValue ){
        $aData = $this->aPages[$iPage];

        $aData['sSubContent'] = isset( $this->aPagesChildrens[$iPage] ) ? $this->throwSubMenu( $sFile, $iPage, $iPageCurrent, $iDepth + 1 ) : null;

        $aData['iStyle']    = ( $i % 2 ) ? 0: 1;
        $aData['sStyle']    = ( $i == ( $iCount - 1 ) ) ? 'L': $i + 1;
        $aData['iDepth']    = $iDepth;
        $aData['sSelected'] = ( $aData['iPage'] == $iPageCurrent ) ? $oTpl->tbHtml( $sFile, 'SELECTED' ) : null;

        $oTpl->setVariables( 'aData', $aData );
        $content .= $oTpl->tbHtml( $sFile, 'LIST' );
        $i++;
      }

      if( isset( $content ) ){
        return $oTpl->tbHtml( $sFile, 'HEAD_SUB' ).$content.$oTpl->tbHtml( $sFile, 'FOOT_SUB' );
      }
    }
  } // end function throwSubMenu

  /**
  * Return variable with menu
  * @return null
  * @param int    $iType
  * @param int    $iPageCurrent
  * @param int    $iDepthLimit
  * @param int    $iDepth
  * @param int    $iPageParent
  */
  function generateMenuData( $iType, $iPageCurrent, $iDepthLimit, $iDepth = 0, $iPageParent = null ){
    if( !isset( $this->mData ) ){
      $aData = $this->aPagesParentsTypes[$iType];
    }
    else{
      if( isset( $this->aPagesChildrens[$iPageParent] ) )
        $aData = $this->aPagesChildrens[$iPageParent];
    }

    if( isset( $aData ) ){
      foreach( $aData as $iKey => $iPage ){
        $this->mData[$this->aPages[$iPage]['iPageParent']][$iPage] = true;
        if( $iDepthLimit > $iDepth && ( $iPageCurrent == $iPage || isset( $this->aPageParents[$iPage] ) ) ){
        #if( $iDepthLimit > $iDepth ){
          $this->generateMenuData( $iType, $iPageCurrent, $iDepthLimit, $iDepth + 1, $iPage );
        }
      } // end foreach    
    }
  } // end function generateMenuData

  /**
  * Return page data
  * @return array
  * @param int  $iPage
  */
  function throwPage( $iPage ){
    if( isset( $this->aPages[$iPage] ) ){
      $aFile      = file( DB_PAGES_EXT );
      $iCount     = count( $aFile );
      $sFunction  = LANGUAGE.'_pages_ext';
      for( $i = 1; $i < $iCount; $i++ ){
        $aExp = explode( '$', $aFile[$i] );
        if( $aExp[0] == $iPage ){
          $aData = $sFunction( $aExp );
          break;
        }
      } // end for
      if( isset( $aData ) ){
        $aFile = null;
        if( defined( 'CUSTOMER_PAGE' ) && strstr( $aData['sDescriptionFull'], '[break]' ) ){
          $aExp = explode( '[break]', $aData['sDescriptionFull'] );
          if( isset( $GLOBALS['aActions']['o4'] ) && is_numeric( $GLOBALS['aActions']['o4'] ) )
            $iPageContent = $GLOBALS['aActions']['o4'];
          else
            $iPageContent = 1;

          if( isset( $aExp[$iPageContent - 1] ) ){
            $aData['sDescriptionFull'] = $aExp[$iPageContent - 1];
            $aData['sPages'] = countPages( count( $aExp ), 1, $iPageContent, $this->aPages[$iPage]['sLinkName'].',,', null, null, null, MAX_PAGES );
          }
        }

        return array_merge( $this->aPages[$iPage], $aData );
      }
    }
    else
      return null;
  } // end function throwPage

  /**
  * Return pages tree
  * @return string
  * @param int  $iPage
  * @param int  $iPageCurrent
  */
  function throwPagesTree( $iPage, $iPageCurrent = null ){
    if( !isset( $iPageCurrent ) ){
      $iPageCurrent = $iPage;
      $this->mData  = null;
    }

    if( isset( $this->aPagesParents[$iPage] ) && isset( $this->aPages[$this->aPagesParents[$iPage]] ) ){
      $this->mData[] = '<a href="'.$this->aPages[$this->aPagesParents[$iPage]]['sLinkName'].'">'.$this->aPages[$this->aPagesParents[$iPage]]['sName'].'</a>';
      return $this->throwPagesTree( $this->aPagesParents[$iPage], $iPageCurrent );
    }
    else{
      if( isset( $this->mData ) ){
        $aReturn = array_reverse( $this->mData );
        $this->mData = null;
        return implode( '&nbsp;&raquo;&nbsp;', $aReturn );
      }
    }
  } // end function throwPagesTree

  /**
  * Return all childrens
  * @return array
  * @param int  $iPage
  */
  function throwAllChildrens( $iPage ){
    $bFirst = !isset( $this->mData ) ? true : null;
    if( isset( $this->aPagesChildrens[$iPage] ) ){
      foreach( $this->aPagesChildrens[$iPage] as $iValue ){
        if( isset( $this->aPages[$iValue] ) ){
          $this->mData[] = $iValue;
          $this->throwAllChildrens( $iValue );
        }
      }
    }
    return isset( $bFirst ) ? $this->mData : null;
  } // end function throwAllChildrens

  /**
  * Return list of subpages
  * @return string
  * @param int    $iPage
  * @param string $sFile
  * @param int    $iType
  */
  function listSubpages( $iPage, $sFile, $iType ){

    if( isset( $this->aPagesChildrens[$iPage] ) ){
      if( $iType > 1 ){
        $oFile =& Files::getInstance( );
      }
      
      $iCount = count( $this->aPagesChildrens[$iPage] );
      $content= null;
      $oTpl   =& TplParser::getInstance( );
      
      for( $i = 0; $i < $iCount; $i++ ){
        $aData = $this->aPages[$this->aPagesChildrens[$iPage][$i]];
        $aData['iStyle'] = ( $i % 2 ) ? 0: 1;
        $aData['sStyle'] = ( $i == ( $iCount - 1 ) ) ? 'L': $i + 1;

        if( !empty( $aData['sDescriptionShort'] ) ){
          $aData['sDescriptionShort'] = changeTxt( $aData['sDescriptionShort'], 'nlNds' );
          $oTpl->setVariables( 'aData', $aData );
          $aData['sDescriptionShort'] = $oTpl->tbHtml( $sFile, 'SUBPAGES_DESCRIPTION_'.$iType );
        }

        $oTpl->setVariables( 'aData', $aData );

        if( isset( $oFile ) && isset( $oFile->aImagesDefault[1][$aData['iPage']] ) ){
          $aDataImage = $oFile->aFilesImages[1][$oFile->aImagesDefault[1][$aData['iPage']]];
          $oTpl->setVariables( 'aDataImage', $aDataImage );
          $aData['sImage'] = $oTpl->tbHtml( $sFile, 'SUBPAGES_IMAGE_'.$iType );
        }
        else{
          if( $iType > 1 ){
            $aData['sImage'] = $oTpl->tbHtml( $sFile, 'SUBPAGES_NO_IMAGE_'.$iType );
          }
        }

        $oTpl->setVariables( 'aData', $aData );
        $content .= $oTpl->tbHtml( $sFile, 'SUBPAGES_LIST_'.$iType );
      } // end for

      if( isset( $content ) ){
        return $oTpl->tbHtml( $sFile, 'SUBPAGES_HEAD_'.$iType ).$content.$oTpl->tbHtml( $sFile, 'SUBPAGES_FOOT_'.$iType );
      }
    }
  } // end function listSubpages

  /**
  * Generate cache variables
  * @return void
  */
  function generateCache( ){

    if( !is_file( DB_PAGES ) )
      return null;

    $aFile      = file( DB_PAGES );
    $iCount     = count( $aFile );
    $sFunction  = LANGUAGE.'_pages';
    $iStatus    = throwStatus( );
    
    $this->aPages             = null;
    $this->aPagesChildrens    = null;
    $this->aPagesParents      = null;
    $this->aPagesParentsTypes = null;

    for( $i = 1; $i < $iCount; $i++ ){
      $aExp = explode( '$', $aFile[$i] );
      if( isset( $aExp[5] ) && $aExp[5] >= $iStatus ){
        if( !is_numeric( $aExp[1] ) )
          $aExp[1] = 0;
        $this->aPages[$aExp[0]] = $sFunction( $aExp );
        $this->aPages[$aExp[0]]['sLinkName'] = '?'.change2Url( $this->aPages[$aExp[0]]['sName'] ).','.$aExp[0];
        if( $aExp[1] > 0 ){
          $this->aPagesChildrens[$aExp[1]][] = $aExp[0];
          $this->aPagesParents[$aExp[0]] = $aExp[1];
        }
        else{
          if( !empty( $aExp[7] ) )
            $this->aPagesParentsTypes[$aExp[7]][] = $aExp[0];
        }
      }
    } // end for
  } // end function generateCache

  /**
  * Generate page all parents
  * @return void
  * @param int  $iPage
  */
  function generatePageParents( $iPage ){
    if( isset( $this->aPagesParents[$iPage] ) ){
      $this->aPageParents[$this->aPagesParents[$iPage]] = true;
      $this->generatePageParents( $this->aPagesParents[$iPage] );
    }
  } // end function generatePageParents
};

?>