<?php
//error_reporting( E_ALL );
unset( $config, $aMenuTypes, $aPhotoTypes, $lang );

/*
* Directories 
*/
$config['dir_core']     = 'core/';
$config['dir_db']       = 'db/';
$config['dir_libraries']= 'libraries/';
$config['dir_lang']     = 'lang/';
$config['dir_templates']= 'templates/';
$config['dir_themes']   = $config['dir_templates'].'themes/';
$config['dir_files']    = 'files/';
$config['dir_plugins']  = 'plugins/';

$config['hidden_shows'] = false;

/*
* If You want embed PHP code in template files 
* set this variable true but it is not recommended and
* script will be slower
*/
$config['embed_php'] = false;

/*
* Administrator login and password 
*/
$config['login'] = "admin";
$config['pass'] = "admin";

/*
* Default language
*/
$config['default_lang'] = "en";

/*
* If should be use wysiwyg editor or default
*/
$config['wysiwyg'] = false;

/*
* Leave code below!
*/
$config['cookie_admin'] = defined( 'CUSTOMER_PAGE' ) ? null : 'A';

if( isset( $sLang ) && is_file( $config['dir_lang'].$sLang.'.php' ) && strlen( $sLang ) == 2 ){
  setCookie( 'sLanguage'.$config['cookie_admin'], $sLang, time( ) + 86400 );
  define( 'LANGUAGE', $sLang );
}
else{
  if( !empty( $_COOKIE['sLanguage'.$config['cookie_admin']] ) && is_file( $config['dir_lang'].$_COOKIE['sLanguage'.$config['cookie_admin']].'.php' ) && strlen( $_COOKIE['sLanguage'.$config['cookie_admin']] ) == 2 )
    define( 'LANGUAGE', $_COOKIE['sLanguage'.$config['cookie_admin']] );
  else
    define( 'LANGUAGE', $config['default_lang'] );
}

$config['config']       = 'config/general.php';
$config['config_lang']  = 'config/lang_'.LANGUAGE.'.php';

$config_db['pages']       = $config['dir_db'].LANGUAGE.'_pages.php';
$config_db['pages_ext']   = $config['dir_db'].LANGUAGE.'_pages_ext.php';
$config_db['pages_files'] = $config['dir_db'].LANGUAGE.'_pages_files.php';

$config['language']	= LANGUAGE;
$config['version']  = '2.1';

$config['pages_images_sizes'] = Array( 0 => 100, 1 => 150 );
$config['max_dimension_of_image'] = 900;
$config['display_all_files'] = true;
$config['change_files_names'] = false;

define( 'DIR_CORE',       $config['dir_core'] );
define( 'DIR_DB',         $config['dir_db'] );
define( 'DIR_FILES',      $config['dir_files'] );
define( 'DIR_LIBRARIES',  $config['dir_libraries'] );
define( 'DIR_PLUGINS',    $config['dir_plugins'] );
define( 'DIR_LANG',       $config['dir_lang'] );
define( 'DIR_TEMPLATES',  $config['dir_templates'] );
define( 'DIR_THEMES',     $config['dir_themes'] );

define( 'DB_PAGES',       $config_db['pages'] );
define( 'DB_PAGES_EXT',   $config_db['pages_ext'] );
define( 'DB_PAGES_FILES', $config_db['pages_files'] );

define( 'DB_CONFIG',      $config['config'] );
define( 'DB_CONFIG_LANG', $config['config_lang'] );

define( 'MAX_DIMENSION_OF_IMAGE', $config['max_dimension_of_image'] );

define( 'HIDDEN_SHOWS',   $config['hidden_shows'] );
define( 'WYSIWYG',   $config['wysiwyg'] );
define( 'VERSION',  $config['version'] );
?>