<?php
if( isset( $iContent ) && is_numeric( $iContent ) ){
  $aData = $oPage->throwPage( $iContent );
  if( isset( $aData ) ){
    if( !empty( $aData['sUrl'] ) ){
      header( 'Location: '.$aData['sUrl'] );
      exit;
    }

    if( !empty( $aData['sTemplate'] ) )
      $oTpl->setFileAlt( $config['default_pages_template'] );
    else
      $aData['sTemplate'] = $config['default_pages_template'];

    if( !empty( $aData['sTheme'] ) )
      $sTheme = $aData['sTheme'];
    if( !empty( $aData['sMetaKeywords'] ) )
      $sKeywords = $aData['sMetaKeywords'];
    if( !empty( $aData['sMetaDescription'] ) )
      $sDescription = $aData['sMetaDescription'];
    if( empty( $aData['sDescriptionFull'] ) )
      $aData['sDescriptionFull'] = $aData['sDescriptionShort'];

    $aData['sPagesTree'] = $oPage->throwPagesTree( $iContent );

    $sPagesTree = !empty( $aData['sPagesTree'] ) ? $oTpl->tbHtml( $aData['sTemplate'], 'PAGES_TREE' ) : null;
    $sPages     = isset( $aData['sPages'] ) ? $oTpl->tbHtml( $aData['sTemplate'], 'PAGES' ) : null;
    $sBanner    = !empty( $aData['sBanner'] ) ? $oTpl->tbHtml( $aData['sTemplate'], 'BANNER' ) : null;
    $sTitle     = strip_tags( ( !empty( $aData['sNameTitle'] ) ? $aData['sNameTitle'] : $aData['sName'] ).' - ' );
    $sSubpagesList = null;

    $aData['sDescriptionFull'] = changeTxt( $aData['sDescriptionFull'], 'nlNds' );

    if( $aData['iSubpagesShow'] > 0 ){
      if( $aData['iSubpagesShow'] < 3 )
        $sSubpagesList = $oPage->listSubpages( $iContent, $aData['sTemplate'], $aData['iSubpagesShow'] );
    }

    $aImages    = $oFile->listImagesByTypes( $aData['sTemplate'], $iContent );
    $sFilesList = $oFile->listFiles( $aData['sTemplate'], $iContent );

    $oTpl->unsetVariables( );
    $content .= $oTpl->tbHtml( $aData['sTemplate'], 'CONTAINER' );
  }
  else{
    $content .= $oTpl->tbHtml( 'messages.tpl', 'ERROR' );
  }
}
?>