<?

/*
 | This file is part of the Igloo Weblog system.
 | Igloo is available under the GNU General Public
 | License.  For details on the GNU General Public
 | License, read the COPYING or the LICENSE file
 | that you received with this distribution.  If
 | you did not receive one of these files with the
 | distribution, you can find more information at
 | http://www.gnu.org.
 |
 | Igloo is the creation of Brad Johnson.  It is not
 | based on any other works.  Brad Johnson is the
 | sole owner of the copyright, but he welcomes all
 | to take the software, use it, modify it, change
 | it, or to do whatever they can do with it under
 | the provisions of the GNU General Public License.
 |
 | This software is provided as-is, with no warranty
 | whatsoever.  The author is not responsible for
 | anything that may happen as a result of your
 | using this software unless you have purchased an
 | extended warranty.  If you would like to
 | purchase an extended warranty, please contact
 | Brad Johnson via e-mail at drj@mrpenguin.org.
 |
 | This software may destroy your system, date your
 | sister, drink your beer, eat the last of the
 | potato chips, cause Democrats to get elected,
 | kick your dog, burn your house, wreck your car,
 | cause nuclear war, force you to kiss your
 | grandmother, or make you eat brussel sprouts.
 | You have been warned.
 |
 | If it breaks, you may feel free to keep both
 | pieces.
 */

  /*
   *  functions used for submission pages
   *  (and I don't mean sexual submission)
   */

function submit_story_dialog() {

  print "<tr>\n";
  print "  <td colspan=\"2\">\n";
  print "    You're about to submit a story!  What does that entail?  Well,\n";
  print "    read below to find out.\n";
  print "  </td>\n";
  print "</tr>\n";
  print "<tr>\n";
  print "  <td colspan=\"2\">\n";
  print "    <h3>\n";
  print "      1.}  Submit something useful\n";
  print "    </h3>\n";
  print "  </td>\n";
  print "</tr>\n";
  print "<tr>\n";
  print "  <td colspan=\"2\">\n";
  print "    <blockquote>\n";
  print "      Submit something that you think other people will want to\n";
  print "      read.  Don't submit a story about Micro\$oft releasing a\n";
  print "      new service pack or something, unless it has some special\n";
  print "      significance to it.  Think about if you saw your story on\n";
  print "      some other news site.  Would you actually click through to\n";
  print "      read it?\n";
  print "    </blockquote>\n";
  print "  </td>\n";
  print "</tr>\n";
  print "<tr>\n";
  print "  <td colspan=\"2\">\n";
  print "    <h3>\n";
  print "      2.}  Be creative!\n";
  print "    </h3>\n";
  print "  </td>\n";
  print "</tr>\n";
  print "<tr>\n";
  print "  <td colspan=\"2\">\n";
  print "    <blockquote>\n";
  print "      As a general rule, don't submit any stories that you find\n";
  print "      on other sites.  If the story is generally interesting, and\n";
  print "      will provide a good discussion, then it may get posted.  If\n";
  print "      some other site turned down your submission, chances are\n";
  print "      higher that it will get posted here, because I've seen many\n";
  print "      good stories (ones that I've submitted and seen elsewhere)\n";
  print "      get turned down by those other weblogs.\n";
  print "    </blockquote>\n";
  print "  </td>\n";
  print "</tr>\n";
  print "<tr>\n";
  print "  <td colspan=\"2\">\n";
  print "    <h3>\n";
  print "      3.}  Make sure it makes sense!\n";
  print "    </h3>\n";
  print "  </td>\n";
  print "</tr>\n";
  print "<tr>\n";
  print "  <td colspan=\"2\">\n";
  print "    <blockquote>\n";
  print "      I'm a stickler for good grammer, but I won't hold you to that.\n";
  print "      However, you do need to make sure that your story is easily\n";
  print "      read and makes sense.  Also, make sure your spelling is at\n";
  print "      least close and your links work.\n";
  print "    </blockquote>\n";
  print "  </td>\n";
  print "</tr>\n";
  print "<tr>\n";
  print "  <td colspan=\"2\">\n";
  print "    &nbsp;\n";
  print "  </td>\n";
  print "</tr>\n";
  print "<tr>\n";
  print "  <td colspan=\"2\">\n";
  print "    <b>That being said, let's get on with the story submission!</b>\n";
  print "  </td>\n";
  print "</tr>\n";

}

function submit_story_form($story_array) {

  print "<form action=\"/ui/submit_story.php\" method=\"post\">\n";
  print "<tr>\n";
  print "  <td>\n";
  print "    The subject of your story:\n";
  print "  </td>\n";
  print "  <td>\n";
  print "    The category your story fits into:\n";
  print "  </td>\n";
  print "</tr>\n";
  print "<tr>\n";
  print "  <td>\n";
  print "    <input type=\"text\" name=\"subject\" value=\"$story_array[subject]\">\n";
  print "  </td>\n";
  print "  <td>\n";
  print "    <select name=\"category\">\n";
  $Results = do_mysql_query("SELECT * FROM story_topics")
    or die("I could not SELECT FROM the database\n");
  while ($Row = mysql_fetch_array($Results)) {
    print "      <option value=\"$Row[id]\">$Row[topic]</option>\n";
  }
  print "    </select>\n";
  print "  </td>\n";
  print "</tr>\n";
  print "<tr>\n";
  print "  <td>\n";
  print "    Your story:\n";
  print "  </td>\n";
  print "</tr>\n";
  print "<tr>\n";
  print "  <td colspan=\"2\">\n";
  print "    <textarea name=\"story\" cols=\"60\" rows=\"5\" wrap=\"virtual\">$story_array[story]</textarea>\n";
  print "  </td>\n";
  print "</tr>\n";
  print "<tr>\n";
  print "  <td>\n";
  print "    <input type=\"submit\" name=\"preview\" value=\"Preview\">\n";
  print "  </td>\n";
  print "  <td>\n";
  if ($story_array[preview]) {
    print "    <input type=\"submit\" name=\"submit\" value=\"Submit\">\n";
  } else {
    print "    You must preview your story at least once before you are allowed to submit!\n";
  }
  print "  </td>\n";
  print "</tr>\n";
  print "<tr>\n";
  print "  <td colspan=\"2\">\n";
  print "    If you want to post anonymously, you must first log out.\n";
  print "  </td>\n";
  print "</tr>\n";
  print "</form>\n";

}

function preview_story($story_array) {

  global $uid;
  if (!$uid) {
    $uid = 0;
  }
  $Results = do_mysql_query("SELECT * FROM users WHERE id='$uid'")
    or die("I could not SELECT FROM the database\n");
  $Row = mysql_fetch_array($Results);
  mysql_free_result($Results);
  $nickname = $Row[nickname];
  $fake_email = $Row[fake_email];

  $Results = do_mysql_query("SELECT * FROM story_topics WHERE id='$story_array[category]'")
    or die("I could not SELECT FROM the database\n");
  $Row = mysql_fetch_array($Results);
  mysql_free_result($Results);
  $topic = $Row[topic];

  $story_array[subject] = strip_entities($story_array[subject]);
  $story_array[story]   = strip_entities($story_array[story]);

  print "<tr>\n";
  print "  <th colspan=\"2\">\n";
  print "    $story_array[subject]\n";
  print "  </th>\n";
  print "</tr>\n";
  print "<tr>\n";
  print "  <td colspan=\"2\">\n";
  print "    <font size=\"2\">\n";
  print "      From the $topic department\n";
  print "    </font>\n";
  print "  </td>\n";
  print "</tr>\n";
  print "<tr>\n";
  print "  <td colspan=\"2\">\n";
  print "    <blockquote>\n";
  print "      <a href=\"mailto:$fake_email\">$nickname</a> wrote in to tell us: <i>$story_array[story]</i>\n";
  print "    </blockquote>\n";
  print "  </td>\n";
  print "</tr>\n";

}

function insert_into_queue($story_array) {

  global $uid;

  $Results = do_mysql_query("INSERT INTO pending_stories (headline, poster, story, tid)
    VALUES ('$story_array[subject]', '$uid', '$story_array[story]', $story_array[category])")
      or die("I could not INSERT INTO the database\n");

}

function story_queued() {

  $Results = do_mysql_query("SELECT count(*) FROM pending_stories")
    or die("I could not SELECT FROM the database\n");
  $Row = mysql_fetch_array($Results);
  mysql_free_result($Results);
  $pending = $Row[0];
  
  print "<tr>\n";
  print "  <td>\n";
  print "    Your story has been submitted into the story queue.  Currently,\n";
  print "    there are $pending stories in the queue.  The team behind $site_name\n";
  print "    will look over your story and if it is satisfactory, post it on the\n";
  print "    main page.  Be on the look out for it!\n";
  print "  </td>\n";
  print "</tr>\n";

}

?>
