<?

/*
 | This file is part of the Igloo Weblog system.
 | Igloo is available under the GNU General Public
 | License.  For details on the GNU General Public
 | License, read the COPYING or the LICENSE file
 | that you received with this distribution.  If
 | you did not receive one of these files with the
 | distribution, you can find more information at
 | http://www.gnu.org.
 |
 | Igloo is the creation of Brad Johnson.  It is not
 | based on any other works.  Brad Johnson is the
 | sole owner of the copyright, but he welcomes all
 | to take the software, use it, modify it, change
 | it, or to do whatever they can do with it under
 | the provisions of the GNU General Public License.
 |
 | This software is provided as-is, with no warranty
 | whatsoever.  The author is not responsible for
 | anything that may happen as a result of your
 | using this software unless you have purchased an
 | extended warranty.  If you would like to
 | purchase an extended warranty, please contact
 | Brad Johnson via e-mail at drj@mrpenguin.org.
 |
 | This software may destroy your system, date your
 | sister, drink your beer, eat the last of the
 | potato chips, cause Democrats to get elected,
 | kick your dog, burn your house, wreck your car,
 | cause nuclear war, force you to kiss your
 | grandmother, or make you eat brussel sprouts.
 | You have been warned.
 |
 | If it breaks, you may feel free to keep both
 | pieces.
 */

  require "config.inc";
  require "$config[private]/local.inc";
  require "$config[private]/pollfun.inc";

  common_header();

  $vote_msg = 0;
  $invalid_poll = 0;

  $ip = getenv('REMOTE_ADDR');

  if ($pid) {

    $status = validate_poll($pid);
    if ($status) {
      invalid_poll();
      display_poll_list();
    } else {
      if ($poll_option) {
        $status = validate_poll_option($pid, $poll_option);
        if ($status) {
          invalid_poll_option();
        } else {
          $status = validate_voter($ip, $pid);
          if ($status) {
            invalid_voter();
          } else {
            place_vote($pid, $poll_option);
            record_ip($pid, $ip);
          }
        }
      }
      display_poll_results($pid);
    }
  } else {
    display_poll_list();
  }

  common_footer();

?>
