<?php
//v1.5 www.exoops.info 2006/03 
// $Id: xoopspolllog.php,v 1.4 2003/03/19 07:02:44 half-dead Exp $
// ------------------------------------------------------------------------- //
//               E-Xoops: Content Management for the Masses                  //
//                       < http://www.e-xoops.com >                          //
// ------------------------------------------------------------------------- //
// Original Author: Kazumi Ono
// Author Website : http://www.mywebaddons.com/ , http://www.myweb.ne.jp
// License Type   : GPL: See /manual/LICENSES/GPL.txt
// ------------------------------------------------------------------------- //
include_once(XOOPS_ROOT_PATH."/class/xoopsobject.php");
class XoopsPollLog extends XoopsObject {
	function XoopsPollLog($id=NULL) {
	$this->XoopsObject();
	$this->initVar("log_id", "int", 0);
	$this->initVar("poll_id", "int", NULL, true);
	$this->initVar("option_id", "int", NULL, true);
	$this->initVar("ip", "other", NULL);
	$this->initVar("user_id", "int", 0);
	$this->initVar("time", "int", NULL);
	if ( !empty($id) ) {
		if ( is_array($id) ) {
			$this->set($id);
			} else {
				$this->load(intval($id));
			}
		}
	}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function store() {
global $db;
if ( !$this->isCleaned() ) {
	if ( !$this->cleanVars() ) {
		return false;
	}
}
foreach ( $this->cleanVars as $k=>$v ) {
	$$k = $v;
}
$log_id = $db->genId($db->prefix("xoopspoll_log")."_log_id_seq");
$sql = "
	INSERT INTO ".$db->prefix("xoopspoll_log")." SET
	log_id=$log_id,
	poll_id=$poll_id,
	option_id='$option_id',
	ip='$ip',
	user_id='$user_id',
	time=".time()."";
if ( !$result = $db->query($sql) ) {
	$this->setErrors(_NOTUPDATED);
	return false;
}
return $option_id;
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function load($id) {
global $db;
$sql   = "SELECT * FROM ".$db->prefix("xoopspoll_log")." WHERE log_id=".$id."";
$myrow = $db->fetchArray($db->query($sql));
$this->set($myrow);
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function delete() {
global $db;
$sql = "DELETE FROM ".$db->prefix("xoopspoll_log")." WHERE log_id=".$this->getVar("log_id")."";
if ( !$db->query($sql) ) {
	return false;
}
return true;
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function &getAllByPollId($poll_id, $orderby="time ASC") {
global $db;
$ret = array();
$sql = "SELECT * FROM ".$db->prefix("xoopspoll_log")." WHERE poll_id=".intval($poll_id)." ORDER BY $orderby";
$result = $db->query($sql);
while ( $myrow = $db->fetchArray($result) ) {
	$ret[] = new XoopsPollLog($myrow);
}
return $ret;
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function hasVoted($poll_id, $ip, $user_id=NULL) {
global $db;
$sql = "SELECT COUNT(*) FROM ".$db->prefix("xoopspoll_log")." WHERE poll_id=".intval($poll_id)." AND";
if ( !empty($user_id) ) {
	$sql .= " user_id=".intval($user_id);
	} else {
		$sql .= " ip='".$ip."'";
	}
list($count) = $db->fetchRow($db->query($sql));
if ( $count > 0 ) {
	return true;
}
return false;
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function deleteByPollId($poll_id) {
global $db;
$sql = "DELETE FROM ".$db->prefix("xoopspoll_log")." WHERE poll_id=".intval($poll_id);
if ( !$db->query($sql) ) {
	return false;
}
return true;
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function deleteByOptionId($option_id) {
global $db;
$sql = "DELETE FROM ".$db->prefix("xoopspoll_log")." WHERE option_id=".intval($option_id);
if ( !$db->query($sql) ) {
	return false;
}
return true;
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function getTotalVotersByPollId($poll_id) {
global $db;
$sql   = "SELECT DISTINCT user_id FROM ".$db->prefix("xoopspoll_log")." WHERE poll_id=".intval($poll_id)." AND user_id > 0";
$users = $db->getRowsNum($db->query($sql));
$sql   = "SELECT DISTINCT ip FROM ".$db->prefix("xoopspoll_log")." WHERE poll_id=".intval($poll_id)." AND user_id=0";
$anons = $db->getRowsNum($db->query($sql));
return $users+$anons;
	}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function getTotalVotesByPollId($poll_id) {
global $db;
$sql = "SELECT COUNT(*) FROM ".$db->prefix("xoopspoll_log")." WHERE poll_id = ".intval($poll_id);
list($votes) = $db->fetchRow($db->query($sql));
return $votes;
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function getTotalVotesByOptionId($option_id) {
global $db;
$sql = "SELECT COUNT(*) FROM ".$db->prefix("xoopspoll_log")." WHERE option_id = ".intval($option_id);
list($votes) = $db->fetchRow($db->query($sql));
return $votes;
}
//---------------------------------------------------------------------------------------//
}
?>
