# --------------------------------------------------------

#
# Table structure for table `comments`
#

CREATE TABLE comments (
  comment_id mediumint(8) unsigned NOT NULL auto_increment,
  pid mediumint(8) unsigned NOT NULL default '0',
  item_id mediumint(8) unsigned NOT NULL default '0',
  date int(10) unsigned NOT NULL default '0',
  user_id mediumint(8) unsigned NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  subject varchar(60) NOT NULL default '',
  comment text NOT NULL,
  allow_html tinyint(1) unsigned NOT NULL default '0',
  allow_smileys tinyint(1) unsigned NOT NULL default '0',
  allow_bbcode tinyint(1) unsigned NOT NULL default '0',
  type enum('admin','user') NOT NULL default 'user',
  icon varchar(255) NOT NULL default '',
  anonuser varchar(60) NOT NULL default '',
  PRIMARY KEY  (comment_id),
  KEY idx (item_id)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `stories`
#

CREATE TABLE stories (
  storyid mediumint(8) unsigned NOT NULL auto_increment,
  uid mediumint(8) unsigned NOT NULL default '0',
  title varchar(60) NOT NULL default '',
  created int(10) unsigned NOT NULL default '0',
  published int(10) unsigned NOT NULL default '0',
  hostname varchar(15) NOT NULL default '',
  allow_html tinyint(1) unsigned NOT NULL default '0',
  allow_smileys tinyint(1) unsigned NOT NULL default '0',
  allow_bbcode tinyint(1) unsigned NOT NULL default '1',
  hometext text NOT NULL,
  bodytext text,
  counter mediumint(8) unsigned NOT NULL default '0',
  topicid mediumint(8) unsigned NOT NULL default '1',
  ihome tinyint(1) unsigned NOT NULL default '0',
  notifypub tinyint(1) unsigned NOT NULL default '0',
  type enum('admin','user') NOT NULL default 'user',
  topicdisplay tinyint(1) unsigned NOT NULL default '0',
  topicalign enum('R','L','0') NOT NULL default '0',
  PRIMARY KEY  (storyid),
  KEY idx (topicid,published,ihome,created)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `topics`
#

CREATE TABLE topics (
  topic_id mediumint(8) unsigned NOT NULL auto_increment,
  topic_pid mediumint(8) unsigned NOT NULL default '0',
  topic_imgurl varchar(255) NOT NULL default '',
  topic_title varchar(60) NOT NULL default '',
  PRIMARY KEY  (topic_id),
  KEY idx (topic_pid)
) TYPE=MyISAM;
