<?php
//v1.5 www.exoops.info 2006/03 
// $Id: functions.php,v 1.4 2003/03/03 17:11:21 half-dead Exp $
// ------------------------------------------------------------------------- //
//               E-Xoops: Content Management for the Masses                  //
//                       < http://www.e-xoops.com >                          //
// ------------------------------------------------------------------------- //
// Based on:
// phpBB: http://www.phpBB.com
// License type: GPL
// ------------------------------------------------------------------------- //
//---------------------------------------------------------------------------------------//
/**
* Gets the total number of topics in a form
*
* @param type $var description
* @return type description
*/
function get_total_topics($forum_id="") {
global $db;
if ($forum_id) {
	$sql = "SELECT COUNT(*) AS total FROM ".$db->prefix("bb_topics")." WHERE forum_id = '$forum_id'";
	} else {
		$sql = "SELECT COUNT(*) AS total FROM ".$db->prefix("bb_topics")."";
	}
if (!$result = $db->query($sql)) {
	return(_ERROR);
}
if (!$myrow = $db->fetchArray($result)) {
	return(_ERROR);
}
return($myrow['total']);
}
//---------------------------------------------------------------------------------------//
/**
* Returns the total number of posts in the whole system, a forum, or a topic
* Also can return the number of users on the system.
*
* @param type $var description
* @return type description
*/
function get_total_posts($id, $type) {
global $db;
switch($type) {
case 'users':
	$sql = "SELECT COUNT(*) AS total FROM ".$db->prefix("users")." u WHERE (u.uid != 0) AND (level != -1)";
	break;
case 'all':
	$sql = "SELECT COUNT(*) AS total FROM ".$db->prefix("bb_posts")."";
	break;
case 'forum':
	$sql = "SELECT COUNT(*) AS total FROM ".$db->prefix("bb_posts")." WHERE forum_id = '$id'";
	break;
case 'topic':
	$sql = "SELECT COUNT(*) AS total FROM ".$db->prefix("bb_posts")." WHERE topic_id = '$id'";
	break;
// Old, we should never get this.
case 'user':
	die("Should be using the users.user_posts column for this.");
	break;
}
if (!$result = $db->query($sql)) {
	return("ERROR");
}
if (!$myrow = $db->fetchArray($result)) {
	return("0");
}
return($myrow['total']);
}
//---------------------------------------------------------------------------------------//
/**
* Returns the most recent post in a forum, or a topic
*
* @param type $var description
* @return type description
*/
function get_last_post($id, $type) {
global $db;
switch($type) {
case 'time_fix':
	$sql = "SELECT p.post_time FROM ".$db->prefix("bb_posts")." p WHERE p.topic_id = '$id' ORDER BY post_time DESC";
	break;
case 'forum':
	$sql = "SELECT p.post_time, p.uid, u.uname FROM ".$db->prefix("bb_posts")." p, ".$db->prefix("users")." u WHERE p.forum_id = '$id' AND p.uid = u.uid ORDER BY post_time DESC";
	break;
case 'topic':
	$sql = "SELECT p.post_time, u.uname FROM ".$db->prefix("bb_posts")." p, ".$db->prefix("users")." u WHERE p.topic_id = '$id' AND p.uid = u.uid ORDER BY post_time DESC";
	break;
case 'user':
	$sql = "SELECT p.post_time FROM ".$db->prefix("bb_posts")." p WHERE p.uid = '$id'";
	break;
}
if (!$result = $db->query($sql,1,0)) {
	return(_ERROR);
}
if (!$myrow = $db->fetchArray($result)) {
	return(_MD_NOPOSTS);
}
if (($type != 'user') && ($type != 'time_fix')) {
	$val = sprintf("%s <br /> %s %s", $myrow['post_time'], _MD_BY, $myrow['uname']);
	} else {
		$val = $myrow['post_time'];
	}
return($val);
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function list_moderators($forum_id=0) {
global $db, $myts;
$sql = "
	SELECT
	u.uid, u.uname
	FROM
	".$db->prefix("users")." u,
	".$db->prefix("bb_forum_mods")." f
	WHERE
	f.forum_id=$forum_id
	AND
	f.user_id=u.uid";
if ($result = $db->query($sql)) {
	if ($db->getRowsNum($result) > 1) {
		echo "
		<select class='select' name='moderators' onchange='top.location.href=\"".XOOPS_URL."/userinfo.php?uid=\" + this.options[this.options.selectedIndex].value + \"\";'>
		<option value='1'>------</option>";
		while (list($uid, $uname) = $db->fetchRow($result)) {
			echo "<option value='$uid'>".$myts->makeTboxData4Show($uname)."</option>";
		}
		echo "</select>";
		} else {
			list($uid, $uname) = $db->fetchRow($result);
			echo " <a href='".XOOPS_URL."/userinfo.php?uid=".$uid."'>".$myts->makeTboxData4Show($uname)."</a>";
		}
	} else {
		echo " ?";
	}
}
//---------------------------------------------------------------------------------------//
/**
* Checks if a user (user_id) is a moderator of a perticular forum (forum_id)
* Retruns 1 if TRUE, 0 if FALSE or Error
*
* @param type $var description
* @return type description
*/
function is_moderator($forum_id, $user_id) {
global $db;
$sql = "SELECT user_id FROM ".$db->prefix("bb_forum_mods")." WHERE forum_id = '$forum_id' AND user_id = '$user_id'";
if (!$result = $db->query($sql)) {
	return("0");
}
if (!$myrow = $db->fetchArray($result)) {
	return("0");
}
if ($myrow['user_id'] != '') {
	return("1");
	} else {
		return("0");
	}
}
//---------------------------------------------------------------------------------------//
/**
* Checks if a topic is locked
*
* @param type $var description
* @return type description
*/
function is_locked($topic) {
global $db;
$sql = "SELECT topic_status FROM ".$db->prefix("bb_topics")." WHERE topic_id = '$topic'";
if (!$r = $db->query($sql)) {
	return(FALSE);
}
if (!$m = $db->fetchArray($r)) {
	return(FALSE);
}
if ($m[topic_status] == 1) {
	return(TRUE);
	} else {
		return(FALSE);
	}
}
//---------------------------------------------------------------------------------------//
/**
* Checks if the given userid is allowed to log into the given (private) forumid.
* If the "is_posting" flag is true, checks if the user is allowed to post to that forum.
*
* @param type $var description
* @return type description
*/
function check_priv_forum_auth($userid, $forumid, $is_posting) {
global $db;
$sql = "SELECT count(*) AS user_count FROM ".$db->prefix("bb_forum_access")." WHERE (user_id = $userid) AND (forum_id = $forumid) ";
if ($is_posting) {
	$sql .= "AND (can_post = 1)";
}
if (!$result = $db->query($sql)) {
	// no good..
	return FALSE;
}
if (!$row = $db->fetchArray($result)) {
	return FALSE;
}
if ($row[user_count] <= 0) {
	return FALSE;
}
return TRUE;
}
//---------------------------------------------------------------------------------------//
/**
* Displays an error message and exits the script. Used in the posting files.
*
* @param type $var description
* @return type description
*/
function error_die($msg) {
global $bbWidth;
?>
<br />
<table border="0" cellpadding="1" cellspacing="0" align="center" valign="top" width="<?php echo $bbWidth;?>"><tr>
<td class="bg2">
<table border="0" cellpadding="1" cellspacing="1" width="100%"><tr class="bg3" align="left">
<td><p><ul><?php echo $msg;?></ul></p></td>
</tr></table>
</td></tr></table>
<br />
<?php
CloseTable();
include_once(XOOPS_ROOT_PATH . "/footer.php");
exit();
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function make_jumpbox() {
global $db, $myts, $xoopsUser, $xoopsModule;
?>
<form action="viewforum.php" method="get">
<select class="select" name="forum"><option value="-1"><?php echo _MD_SELFORUM;?></option>
<?php
$sql = "SELECT cat_id, cat_title FROM ".$db->prefix("bb_categories")." ORDER BY cat_order";
if ($result = $db->query($sql)) {
	$myrow = $db->fetchArray($result);
	$myrow['cat_title'] = $myts->makeTboxData4Show($myrow['cat_title']);
	do {
		echo "
		<option value='-1'>&nbsp;</option>
		<option value='-1'>".$myrow['cat_title']."</option>
		<option value='-1'>----------------</option>";
		$sub_sql = "SELECT forum_id, forum_name, forum_type FROM ".$db->prefix("bb_forums")." WHERE cat_id ='$myrow[cat_id]' ORDER BY forum_id";
		if ($res = $db->query($sub_sql)) {
			while (list($forum_id, $forum_name, $forum_type) = $db->fetchRow($res)) {
				if ($forum_type == 1) {
					if (!$xoopsUser) {
						continue;
						} elseif (!$xoopsUser->isAdmin($xoopsModule->mid()) && !check_priv_forum_auth($xoopsUser->uid(), $forum_row[$x]['forum_id'], 0)) {
							continue;
						}
					}
			$name = $myts->makeTboxData4Show($forum_name);
			echo "<option value='".$forum_id."'>$name</option>";
			}
			} else {
				echo "<option value='0'>Error Connecting to DB</option>";
			}
		} while ($myrow = $db->fetchArray($result));
	} else {
		echo "<option value='-1'>ERROR</option>";
	}
echo "</select> <input type='submit' class='button' value='"._GO."' /></form>";
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function sync($id, $type) {
global $db;
switch($type) {
case 'forum':
	$sql = "SELECT max(post_id) AS last_post FROM ".$db->prefix("bb_posts")." WHERE forum_id = $id";
	if (!$result = $db->query($sql)) {
		die("Could not get post ID");
	}
	if ($row = $db->fetchArray($result)) {
		$last_post = $row["last_post"];
	}
	$sql = "SELECT count(post_id) AS total FROM ".$db->prefix("bb_posts")." WHERE forum_id = $id";
	if (!$result = $db->query($sql)) {
		die("Could not get post count");
	}
	if ($row = $db->fetchArray($result)) {
		$total_posts = $row["total"];
	}
	$sql = "SELECT count(topic_id) AS total FROM ".$db->prefix("bb_topics")." WHERE forum_id = $id";
	if (!$result = $db->query($sql)) {
		die("Could not get topic count");
	}
	if ($row = $db->fetchArray($result)) {
		$total_topics = $row["total"];
	}
	$sql = "UPDATE ".$db->prefix("bb_forums")." SET forum_last_post_id = '$last_post', forum_posts = $total_posts, forum_topics = $total_topics WHERE forum_id = $id";
	if (!$result = $db->query($sql)) {
		die("Could not update forum $id");
	}
	break;
case 'topic':
	$sql = "SELECT max(post_id) AS last_post FROM ".$db->prefix("bb_posts")." WHERE topic_id = $id";
	if (!$result = $db->query($sql)) {
		die("Could not get post ID");
	}
	if ($row = $db->fetchArray($result)) {
		$last_post = $row["last_post"];
	}
	if ( $last_post > 0 ) {
		$sql = "SELECT count(post_id) AS total FROM ".$db->prefix("bb_posts")." WHERE topic_id = $id";
	if (!$result = $db->query($sql)) {
		die("Could not get post count");
	}
	if ($row = $db->fetchArray($result)) {
		$total_posts = $row["total"];
	}
	$total_posts -= 1;
	$sql = "UPDATE ".$db->prefix("bb_topics")." SET topic_replies = $total_posts, topic_last_post_id = $last_post WHERE topic_id = $id";
	if (!$result = $db->query($sql)) {
		die("Could not update topic $id");
	}
	}
	break;
case 'all forums':
	$sql = "SELECT forum_id FROM ".$db->prefix("bb_forums")."";
	if (!$result = $db->query($sql)) {
		die("Could not get forum IDs");
	}
	while ($row = $db->fetchArray($result)) {
		$id = $row["forum_id"];
		sync($id, "forum");
	}
	break;
case 'all topics':
	$sql = "SELECT topic_id FROM ".$db->prefix("bb_topics")."";
	if (!$result = $db->query($sql)) {
		die("Could not get topic ID's");
	}
	while ($row = $db->fetchArray($result)) {
		$id = $row["topic_id"];
		sync($id, "topic");
	}
	break;
}
return(TRUE);
}
?>
