# --------------------------------------------------------

#
# Table structure for table `mydownloads_broken`
#

CREATE TABLE mydownloads_broken (
  reportid mediumint(8) unsigned NOT NULL auto_increment,
  lid mediumint(8) unsigned NOT NULL default '0',
  sender mediumint(8) unsigned NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  PRIMARY KEY  (reportid)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `mydownloads_cat`
#

CREATE TABLE mydownloads_cat (
  cid mediumint(8) unsigned NOT NULL auto_increment,
  pid mediumint(8) unsigned NOT NULL default '0',
  title varchar(60) NOT NULL default '0',
  imgurl varchar(255) NOT NULL default '',
  description text,
  PRIMARY KEY  (cid),
  KEY idx (pid)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `mydownloads_downloads`
#

CREATE TABLE mydownloads_downloads (
  lid mediumint(8) unsigned NOT NULL auto_increment,
  cid mediumint(8) unsigned NOT NULL default '0',
  title varchar(60) NOT NULL default '',
  description text NOT NULL,
  url varchar(255) NOT NULL default '',
  homepage varchar(255) NOT NULL default '',
  version varchar(10) NOT NULL default '',
  size int(10) unsigned NOT NULL default '0',
  platform varchar(30) NOT NULL default '',
  logourl varchar(255) NOT NULL default '',
  submitter mediumint(8) unsigned NOT NULL default '0',
  status tinyint(1) unsigned NOT NULL default '0',
  date int(10) unsigned NOT NULL default '0',
  hits mediumint(8) unsigned NOT NULL default '0',
  rating float(3,2) unsigned NOT NULL default '0.00',
  votes smallint(5) unsigned NOT NULL default '0',
  comments smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (lid),
  KEY idx (status,cid)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `mydownloads_mod`
#

CREATE TABLE mydownloads_mod (
  requestid mediumint(8) unsigned NOT NULL auto_increment,
  lid mediumint(8) unsigned NOT NULL default '0',
  cid mediumint(8) unsigned NOT NULL default '0',
  title varchar(60) NOT NULL default '',
  url varchar(255) NOT NULL default '',
  homepage varchar(255) NOT NULL default '',
  version varchar(10) NOT NULL default '',
  size int(10) unsigned NOT NULL default '0',
  platform varchar(30) NOT NULL default '',
  logourl varchar(255) NOT NULL default '',
  description text NOT NULL,
  modifysubmitter mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (requestid)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `mydownloads_votedata`
#

CREATE TABLE mydownloads_votedata (
  ratingid mediumint(8) unsigned NOT NULL auto_increment,
  lid mediumint(8) unsigned NOT NULL default '0',
  ratinguser mediumint(8) unsigned NOT NULL default '0',
  rating float(3,2) unsigned NOT NULL default '0.00',
  ratinghostname varchar(15) NOT NULL default '',
  ratingtimestamp int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (ratingid),
  KEY idx (lid)
) TYPE=MyISAM;

# --------------------------------------------------------

#
# Table structure for table `comments`
#

CREATE TABLE mydownloads_comments (
  comment_id mediumint(8) unsigned NOT NULL auto_increment,
  pid mediumint(8) unsigned NOT NULL default '0',
  item_id mediumint(8) unsigned NOT NULL default '0',
  date int(10) unsigned NOT NULL default '0',
  user_id mediumint(8) unsigned NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  subject varchar(60) NOT NULL default '',
  comment text NOT NULL,
  allow_html tinyint(1) unsigned NOT NULL default '0',
  allow_smileys tinyint(1) unsigned NOT NULL default '0',
  allow_bbcode tinyint(1) unsigned NOT NULL default '0',
  type enum('admin','user') NOT NULL default 'user',
  icon varchar(255) NOT NULL default '',
  anonuser varchar(60) NOT NULL default '',
  PRIMARY KEY  (comment_id),
  KEY idx (item_id)
) TYPE=MyISAM;
