<?php
//v1.0.4 www.bcoos.net 2006/10 GPL
//v1.8 www.exoops.info 2006/03
// 
// ------------------------------------------------------------------------- //
//               E-Xoops: Content Management for the Masses                  //
//                       < http://www.e-xoops.com >                          //
// ------------------------------------------------------------------------- //
// Author of File: 							     //
// Kazumi Ono (http://www.mywebaddons.com/ , http://www.myweb.ne.jp/)        //
// ------------------------------------------------------------------------- //
class XoopsArbre{
	var $table;     //table with parent-child structure
	var $id;    //name of unique id for records in table $table
	var $pid;     // name of parent id used in table $table
	var $order;    //specifies the order of query results
	var $title;     // name of a field in table $table which will be used when  selection box and paths are generated
	var $db;
	//constructor of class XoopsTree
	//sets the names of table, unique id, and parend id
	function XoopsArbre($table_name, $id_name, $pid_name){
		$this->table = $table_name;
		$this->id = $id_name;
		$this->pid = $pid_name;
	}	
	// returns an array of first child objects for a given id($sel_id)
	function getFirstChild($sel_id, $order=""){
	global $db;
		$arr =array();
		$sql = "SELECT * FROM ".$this->table." WHERE ".$this->pid."=".$sel_id."";
		if ( $order != "" ) {
			$sql .= " ORDER BY $order";
		}
		$result = $db->query($sql);
		$count = $db->getRowsNum($result);
		if ( $count==0 ) {
			return $arr;
		}
		while ( $myrow = $db->fetchArray($result) ) {
			array_push($arr, $myrow);
		}
		return $arr;
	}
	// returns an array of all FIRST child ids of a given id($sel_id)
	function getFirstChildId($sel_id){
	global $db;
		$idarray =array();
		$result = $db->query("SELECT ".$this->id." FROM ".$this->table." WHERE ".$this->pid."=".$sel_id."");
		$count = $db->getRowsNum($result);
		if ( $count == 0 ) {
			return $idarray;
		}
		while ( list($id) = $db->fetchRow($result) ) {
			array_push($idarray, $id);
		}
		return $idarray;
	}
	//returns an array of ALL child ids for a given id($sel_id)
	function getAllChildId($sel_id,$order="",$idarray = array()){
	global $db;
		$sql = "SELECT ".$this->id." FROM ".$this->table." WHERE ".$this->pid."=".$sel_id."";
		if ( $order != "" ) {
			$sql .= " ORDER BY $order";
		}
		$result = $db->query($sql);
		$count = $db->getRowsNum($result);
		if ( $count==0 ) {
			return $idarray;
		}
		while ( list($r_id) = $db->fetchRow($result) ) {
			array_push($idarray, $r_id);
			$idarray = $this->getAllChildId($r_id,$order,$idarray);
		}
		return $idarray;
	}
	//returns an array of ALL parent ids for a given id($sel_id)
	function getAllParentId($sel_id,$order="",$idarray = array()){
	global $db;
		$sql = "SELECT ".$this->pid." FROM ".$this->table." WHERE ".$this->id."=".$sel_id."";
		if ( $order != "" ) {
			$sql .= " ORDER BY $order";
		}
		$result = $db->query($sql);
		list($r_id) = $db->fetchRow($result);
		if ( $r_id == 0 ) {
			return $idarray;
		}
		array_push($idarray, $r_id);
		$idarray = $this->getAllParentId($r_id,$order,$idarray);
		return $idarray;
	}
	//generates path from the root id to a given id($sel_id)
	// the path is delimetered with "/"
	function getPathFromId($sel_id, $title, $path=""){
	global $db, $myts;
		$result = $db->query("SELECT ".$this->pid.", ".$title." FROM ".$this->table." WHERE ".$this->id."=$sel_id");
		if ( $this->db->getRowsNum($result) == 0 ) {
			return $path;
		}
		list($parentid,$name) = $db->fetchRow($result);
		$name = $myts->makeTboxData4Show($name);
		$path = "/".$name.$path."";
		if ( $parentid == 0 ) {
			return $path;
		}
		$path = $this->getPathFromId($parentid, $title, $path);
		return $path;
	}
	//makes a nicely ordered selection box
	//$preset_id is used to specify a preselected item
	//set $none to 1 to add a option with value 0
	function makeMySelBox($title,$order="",$preset_id=0, $none=0, $sel_name="", $onchange=""){
	global $myts, $db;
		if ( $sel_name == "" ) {
			$sel_name = $this->id;
		}
		
		echo "<select name='".$sel_name."'";
		if ( $onchange != "" ) {
			echo " onchange='".$onchange."'";
		}
		echo " class=\"select\">\n";
		$sql = "SELECT ".$this->id.", ".$title." FROM ".$this->table." WHERE ".$this->pid."=0";
		if ( $order != "" ) {
			$sql .= " ORDER BY $order";
		}
		$result = $db->query($sql);
		if ( $none ) {
			echo "<option value='0'>"._CLA_BIGCAT."</option>\n";
		}
		while ( list($catid, $name) = $db->fetchRow($result) ) {
			if ( $catid == $preset_id ) {
				$sel = " selected='selected'";
			}
			echo "<option value='$catid'$sel>$name</option>\n";
			$sel = "";
			$arr = $this->getChildTreeArray($catid);
			foreach ( $arr as $option ) {
				$option['prefix'] = str_replace(".","--",$option['prefix']);
				$catpath = $option['prefix']."&nbsp;".$myts->makeTboxData4Show($option[$title]);
				if ( $option[$this->id] == $preset_id ) {
					$sel = " selected='selected'";
				}
				echo "<option value='".$option[$this->id]."'$sel>$catpath</option>\n";
				$sel = "";
			}
		}
		echo "</select>\n";
	}
	//generates nicely formatted linked path from the root id to a given id
	function getNicePathFromId($sel_id, $title, $funcURL, $path=""){
	global $db, $myts;
		$sql = "SELECT ".$this->pid.", ".$title." FROM ".$this->table." WHERE ".$this->id."=$sel_id";
		$result = $db->query($sql);
		if ( $db->getRowsNum($result) == 0 ) {
			return $path;
		}
		list($parentid,$name) = $db->fetchRow($result);
		
		$name = $myts->makeTboxData4Show($name);
		$path = "&nbsp;&raquo;&nbsp;<a href='".$funcURL."&".$this->id."=".$sel_id."'>".$name."</a>".$path."";
		if ( $parentid == 0 ) {
			return $path;
		}
		$path = $this->getNicePathFromId($parentid, $title, $funcURL, $path);
		return $path;
	}
	//generates id path from the root id to a given id
	// the path is delimetered with "/"
	function getIdPathFromId($sel_id, $path=""){
	global $db;
		$result = $db->query("SELECT ".$this->pid." FROM ".$this->table." WHERE ".$this->id."=$sel_id");
		if ( $db->getRowsNum($result) == 0 ) {
			return $path;
		}
		list($parentid) = $db->fetchRow($result);
		$path = "/".$sel_id.$path."";
		if ( $parentid == 0 ) {
			return $path;
		}
		$path = $this->getIdPathFromId($parentid, $path);
		return $path;
	}
	function getAllChild($sel_id=0,$order="",$parray = array()){
	global $db;
		$sql = "SELECT * FROM ".$this->table." WHERE ".$this->pid."=".$sel_id."";
		if ( $order != "" ) {
			$sql .= " ORDER BY $order";
		}
		$result = $db->query($sql);
		$count = $db->getRowsNum($result);
		if ( $count == 0 ) {
			return $parray;
		}
		while ( $row = $db->fetchArray($result) ) {
			array_push($parray, $row);
			$parray=$this->getAllChild($row[$this->id],$order,$parray);
		}
		return $parray;
	}
	function getChildTreeArray($sel_id=0,$order="",$parray = array(),$r_prefix=""){
	global $db;
		$sql = "SELECT * FROM ".$this->table." WHERE ".$this->pid."=".$sel_id."";
		if ( $order != "" ) {
			$sql .= " ORDER BY $order";
		}
		$result = $db->query($sql);
		$count = $db->getRowsNum($result);
		if ( $count == 0 ) {
			return $parray;
		}
		while ( $row = $db->fetchArray($result) ) {
			$row['prefix'] = $r_prefix.".";
			array_push($parray, $row);
			$parray = $this->getChildTreeArray($row[$this->id],$order,$parray,$row['prefix']);
		}
		return $parray;
	}
	
	
	//makes a nicely ordered selection box
	//$preset_id is used to specify a preselected item
	//set $none to 1 to add a option with value 0
	function makeMapSelBox($title,$order="",$preset_id=0, $none=0, $sel_name="", $onchange=""){
	global $classm, $myts, $db,$bcoosConfig;
		if ( $sel_name == "" ) {
			$sel_name = $this->id;
		}
		$sql = "SELECT ".$this->id.", ".$title.", ordre FROM ".$this->table." WHERE ".$this->pid."=0";
		if ( $order != "" ) {
			$sql .= " ORDER BY $order";
		}
		$result = $db->query($sql);
		while ( list($catid, $name, $ordre) = $db->fetchRow($result) ) {
			echo "<P><A HREF=\"gest-cat.php?op=AnnoncesNewCat&cid=$catid\"><IMG SRC=\"".XOOPS_URL."/images/icons/".$bcoosConfig['iconset']."menu_plus.gif\" BORDER=0 WIDTH=10 HEIGHT=10 alt=\""._ADDSUBCATEGORY."\"></A>&nbsp;<A HREF=\"gest-cat.php?op=AnnoncesModCat&cid=$catid\" title=\""._CLA_MODIFCAT."\">$name</A> ";
				if ($classm == "ordre") { echo "($ordre)"; }				
				echo "<BR>\n";
			$arr = $this->getChildTreeMapArray($catid, $order);
			foreach ( $arr as $option ) {
				$option['prefix'] = str_replace("."," --->",$option['prefix']);
				$catpath = $option['prefix']."&nbsp;<A HREF=\"gest-cat.php?op=AnnoncesNewCat&cid=".$option[$this->id]."\"><IMG SRC=\"".XOOPS_URL."/images/icons/".$bcoosConfig['iconset']."menu_plus.gif\" BORDER=0 WIDTH=10 HEIGHT=10 alt=\""._ADDSUBCATEGORY."\"></A>&nbsp;<A HREF=\"gest-cat.php?op=AnnoncesModCat&cid=".$option[$this->id]."\" title=\""._CLA_MODIFCAT."\">".$myts->makeTboxData4Show($option[$title]);
				$ordreS = $option['ordre'];
				echo "$catpath</A> ";
				if ($classm == "ordre") { echo "($ordreS)"; }				
				echo "<BR>\n";
			}
		}
		
	}
	
		function getChildTreeMapArray($sel_id=0,$order="",$parray = array(),$r_prefix=""){
		global $db;
		$sql = "SELECT * FROM ".$this->table." WHERE ".$this->pid."=".$sel_id."";
		if ( $order != "" ) {
			$sql .= " ORDER BY $order";
		}
		$result = $db->query($sql);
		$count = $db->getRowsNum($result);
		if ( $count == 0 ) {
			return $parray;
		}
		while ( $row = $db->fetchArray($result) ) {
			$row['prefix'] = $r_prefix.".";
			array_push($parray, $row);
			$parray = $this->getChildTreeMapArray($row[$this->id],$order,$parray,$row['prefix']);
		}
		return $parray;
	}
}
?>