<?php
//v1.0.4 www.bcoos.net 2006/10 GPL
//v1.8 www.bcoos.net 2006-08 GPL
//v1.7 www.exoops.info 2006/05 GPL
//v1.6 www.exoops.info 2006/03 GPL
// $Id: functions.php,v 1.54 2003/08/17 18:45:18 half-dead Exp $
// ------------------------------------------------------------------------- //
//               E-Xoops: Content Management for the Masses                  //
//                       < http://www.e-xoops.com >                          //
// ------------------------------------------------------------------------- //
// Original Author: Kazumi Ono
// Author Website : http://www.mywebaddons.com/ , http://www.myweb.ne.jp
// License Type   : GPL: See /manual/LICENSES/GPL.txt
// ------------------------------------------------------------------------- //
if (!defined("EXOOPS_FUNCTIONS_INCLUDED")) {
	define("EXOOPS_FUNCTIONS_INCLUDED", 1);
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function xoops_header($closehead=true) {
global $db, $bcoosConfig, $xoopsUser;
?><html>
<head>
<title><?php echo $bcoosConfig['title'];?></title>
<meta http-equiv="content-type" content="text/html; charset=<?php echo _CHARSET;?>">
<meta http-equiv="content-language" content="<?php echo _LANGCODE;?>">
<meta name="generator" content="<?php echo XOOPS_VERSION;?>">
<meta name="description" content="<?php echo $bcoosConfig['description'];?>">
<?php readfile(XOOPS_ROOT_PATH . "/modules/system/cache/header.php");?>
<link rel="icon" href="<?php echo XOOPS_URL."/icon.png";?>" type="image/png">
<link rel="shortcut icon" href="<?php echo XOOPS_URL."/icon.png";?>" type="image/png">
<link rel="alternate" type="application/rss+xml" title="News RSS - 0.92" href="<?php echo XOOPS_URL."/modules/news/cache/news.xml";?>">
<link rel="alternate" type="application/rss+xml" title="Downloads - 0.92" href="<?php echo XOOPS_URL."/modules/mydownloads/cache/downloads.xml";?>">
<link rel="alternate" type="application/rss+xml" title="Links - 0.92" href="<?php echo XOOPS_URL."/modules/mylinks/cache/links.xml";?>">
<link rel="alternate" type="application/rss+xml" title="Faq - 0.92" href="<?php echo XOOPS_URL."/modules/xoopsfaq/cache/faq.xml";?>">
<link rel="alternate" type="application/rss+xml" title="Sections - 0.92" href="<?php echo XOOPS_URL."/modules/mysections/cache/mysections.xml";?>">
<link rel="alternate" type="application/rss+xml" title="Addresses - 0.92" href="<?php echo XOOPS_URL."/modules/adresses/cache/adresses.xml";?>">
<?php include_once(XOOPS_ROOT_PATH ."/include/xoopsjs.php");?>
<link href="<?php echo XOOPS_URL;?>/include/style.css" rel="stylesheet" type="text/css" />
<?php
$themecss = getcss(getTheme());
if ($themecss) {
	echo "
	<style type='text/css' media='all'>
	<!-- @import url($themecss); -->
	</style>";
}
if ( $closehead ) {
	echo "</head><body>";
}
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function xoops_footer($debug=1) {
global $bcoosConfig;
if ($bcoosConfig['display_loading_img'] == 1) {
	CloseWaitBox();
}
site_cache("cache");
if ( !empty($bcoosConfig['debug_mode']) && !empty($debug) ) {
	debug_info($bcoosConfig['debug_mode']);
} else {
echo "<span style='font-size:15px;font-weight: bold;'&nbsp;&copy;<a href='http://www.bcoos.net/'>".XOOPS_VERSION." [GPL]</a>";
}
echo "</body></html>";
ob_end_flush();
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function site_cache($option) {
global $xoopsOption, $bcoosConfig, $xoopsUser;
$cache_time      = $bcoosConfig['cache_time'];
$browser_pattern = 'mozilla\/[0-9]|netscape|opera|konqueror|msie [0-9]|iweng|ncsa mosaic|lynx';
$r_uri           = _REQUEST_URI;
$u_agent         = _HTTP_USER_AGENT;
$r_method        = _REQUEST_METHOD;
if (
    $xoopsOption['nocache'] != 1
    && !empty($cache_time)
    && empty($xoopsUser)
    && $r_method == 'GET'
    && !empty($r_uri)
    && preg_match("/($browser_pattern)/i", $u_agent)
   ) {
$curr_time   = time();
$path        = XOOPS_ROOT_PATH.'/cache/system/';
$tmp_name    = preg_replace('/[^a-z0-9_-]/i', '', $r_uri);
$cache_file  = $path.'.'.$tmp_name.'.cache';
$last_cached = @filemtime($cache_file);
$last_cached ? $last_cached = $last_cached : $last_cached = 0;
$cached_size = @filesize($cache_file);
$cached_size ? $cached_size = $cached_size : $cached_size = 0;
if ( ($option == 'cache') && (($last_cached+$cache_time) < $curr_time) ) {
	$content = ob_get_contents();
	// Cleanup stale files that might have been generated by search engines, etc.
	if ( $handle = @opendir($path) ) {
		while (false !== ($file = @readdir($handle))) {
			if ( @is_file($path.$file) ) {
			$timestamp = @filemtime($path.$file);
				if ( (($timestamp+$cache_time) < $curr_time) ) {
					@unlink($path.$file);
				}
			}
		}
		closedir($handle);
	} // END Cleanup
	if ($fp = fopen($cache_file, 'w')) {
		fwrite($fp, $content.'</body></html>');
		fclose($fp);
		}
		} elseif ( ($option == 'read') && (($last_cached+$cache_time) > $curr_time) && ($cached_size > 5120) ) {
			if ( !headers_sent() ) {
				header('Last-Modified: '.gmdate("D, d M Y H:i:s", $last_cached).' GMT');
				header("Cache-Control: max-age=$cache_time, s-maxage=$cache_time, proxy-revalidate, post-check=$cache_time, pre-check=$cache_time");
				
			}
			readfile($cache_file);
			if ( !empty($bcoosConfig['debug_mode']) ) {
				debug_info($bcoosConfig['debug_mode']);
			}
			if (!headers_sent()) {
				header('ETag: '.md5(ob_get_length()));
			}
			ob_end_flush();
			exit();
		}
	} elseif (!headers_sent()) {
		header('ETag: '.md5(uniqid(ex_srand())));
		header('Expires: Sat, 18 Aug 2002 05:30:00 GMT');
		header('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
		header('Cache-Control: no-store, no-cache, max-age=1, s-maxage=1, must-revalidate, post-check=0, pre-check=0');
	} // END CACHE
}
//----------------------------------------------------------------------------------------//
/**
* Function to display formatted times in user timezone
*/
function formatTimestamp($time, $format="l", $timeoffset="") {
global $bcoosConfig, $xoopsUser;
if ($timeoffset == "") {
	if ($xoopsUser) {
		$timeoffset = $xoopsUser->getVar("timezone_offset");
		} else {
			$timeoffset = $bcoosConfig['default_TZ'];
		}
	}
if ( $format == "s" ) { $datestring = _SHORTDATESTRING;
} elseif ( $format == "m" ) { $datestring = _MEDIUMDATESTRING;
} elseif ( $format == "t") { $datestring = _TODAYDATESTRING;
} elseif ( $format == "l" ) { $datestring = _DATESTRING;
} elseif ( $format == "mysql" ) { $datestring = "Y-m-d H:i:s";
} elseif ( $format != "" ) { $datestring = $format;
} else { $datestring = _DATESTRING; }
$usertimestamp = ($time + (($timeoffset - ($bcoosConfig['server_TZ'] - date('I'))) * 3600));
$datetime = date($datestring, $usertimestamp);
$datetime = ucfirst($datetime);
return $datetime;
}
//----------------------------------------------------------------------------------------//
/**
* Function to calculate server timestamp from user entered time (timestamp)
*/
function userTimeToServerTime($timestamp, $userTZ=NULL) {
global $bcoosConfig;
if ( !isset($userTZ) ) {
	$userTZ = $bcoosConfig['default_TZ'];
}
$offset    = $userTZ - $bcoosConfig['server_TZ'];
$timestamp = $timestamp - ($offset * 3600);
return $timestamp;
}
// --------------------------------------------------------------------------------------//
/**
* Functions to display dhtml loading image box
*/
function OpenWaitBox() {
global $bcoosConfig;
if ($bcoosConfig['display_loading_img'] == 1) {
?>
	<div id="waitDiv" style="position:absolute; left:40%; top:50%; visibility:hidden; text-align:center;">
	<?php theme_waitbox();?>
	</div>
	<script type='text/javascript'>
	<!--
	toggle_visibility('waitDiv', 1);
	//-->
	</script>
<?php
}
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function CloseWaitBox()  {
?>
	<script type='text/javascript'>
	<!--
	toggle_visibility('waitDiv', 0);
	//-->
	</script>
<?php
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function ex_srand() {
	$seed = hexdec(substr(md5(microtime()), -8)) & 0x7fffffff;
	mt_srand($seed);
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function makepass() {
$consonents = "bcdfghjklmnpqrstvwxyz";
$voyelles   = "aeiou";
ex_srand();
for ($i=0; $i<4; $i++) {
	$makepass .= substr($consonents, mt_rand(0, strlen($consonents)-1), 1);
	$makepass .= substr($voyelles  , mt_rand(0, strlen($voyelles)-1)  , 1);
		}
return ($makepass);
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param array  $input An array of regular expressions
* @param string $match The string we are matching
* @return bool True/False based on matches
*/
function hasMatch($input=array(), $match=0) {
if ( !empty($input) && !empty($match) ) {
	foreach ($input as $entry) {
		$entry = trim($entry);
		if ( !empty($entry) && preg_match($entry, trim($match), $matches) ) {
			return $matches;
		}
		}
	}
return false;
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function checkIp($ip=0) {
global $xoopsBadIps;
return hasMatch($xoopsBadIps, $ip);
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function checkEmail($email) {
if ( empty($email) || !preg_match("/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+([\.][a-z0-9-]+)+$/i", $email) ) {
	return false;
	}
return true;
}
//---------------------------------------------------------------------------------------//
/**
* NOT DONE DONT USE
* Returns the GMT timestamp for now or a given offset
*
* @param type $var description
* @return type description
*/
function gmtime($time=0, $offset=0) {
if (empty($offset)) {
	return gmmktime();
	} else {
		return gmmktime(0, 0, 0, 0, 0, 0, intval($offset));
	}
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function formatURL($url='', $file='') {
if ( ($url != '') && !preg_match("'^((http|https|ftp|ftps|ed2k|ajsfp)://{1})$'i", $url) ) {
	if ($file != '') {
		if ( preg_match("'^((http|https|ftp|ftps|ed2k|ajsfp)://{1}.{3,})'i", $file) ) {
			return $file;
			} elseif (substr($url, -1) != '/') {
				$file = '/'.$file;
			}
	}
	if ( preg_match("'^((http|https|ftp|ftps|ed2k|ajsfp)://{1}.{3,})'i", $url) ) {
		return $url.$file;
		} else {
			return "http://".$url.$file;
		}
}
return NULL;
}
//----------------------------------------------------------------------------------------//
/**
* Prints allowed html tags on this site
*/
function get_allowed_html() {
global $xoopsUser, $xoopsModule, $bcoosConfig;
if ($xoopsUser) {
	$mid = $xoopsModule ? $xoopsModule->mid() : 0;
	if ($xoopsUser->isAdmin($mid)) {
		$html = $bcoosConfig['admin_html'];
		} else {
			$html = $bcoosConfig['user_html'];
		}
	$allowed = str_replace("|", "> <", "<".$html.">");
	$allowed = htmlspecialchars($allowed);
}
return $allowed;
}
//----------------------------------------------------------------------------------------//
/**
* DEPRACTED ..use getMailer()
*/
function xoops_mail($to, $subject, $message, $headers='') {
global $bcoosConfig;
$mail =& getMailer();
$mail->useMail();
$mail->setFromName($bcoosConfig['title']);
$mail->setFromEmail($bcoosConfig['adminmail']);
$mail->setToEmails($to);
$mail->setSubject($subject);
$mail->setBody($message);
$mail->send();
echo $mail->getSuccess();
echo $mail->getErrors();
}
//----------------------------------------------------------------------------------------//
/**
* Function to display banners in all pages
*/
function showbanner($display="N") {
if ( file_exists(XOOPS_ROOT_PATH .'/modules/banners/include/functions.php') ) {
	include_once(XOOPS_ROOT_PATH .'/modules/banners/include/functions.php');
	if ( function_exists('show_banner') ) {
		show_banner($display);
	}
}
}
//----------------------------------------------------------------------------------------//
/**
* Function to redirect a user to certain pages
*/
function redirect_header($url, $time=4, $message=_TAKINGBACK) {
global $bcoosConfig;
?>
<html><head>
<title><?php echo $bcoosConfig['title'];?></title>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo _CHARSET;?>" />
<meta http-equiv="Refresh" content="<?php echo $time;?>; url=<?php echo $url;?>" />
<style type="text/css">
	.redirect {
		width: 70%;
		margin: 50px;
		text-align: center;
		padding: 15px;
		border: 1px dashed;
	}
</style>
<?php
$themecss = getcss(getTheme());
if ($themecss) {
	echo "<link href='$themecss' rel='stylesheet' type='text/css' />";
}
?>
</head><body>
<div align="center">
<div class="redirect">
<h4><?php echo $message;?></h4>
<hr size="1" noshade="noshade" />
<b>
<?php
printf(_IFNOTRELOAD, $url);
?>
</b>
</div>
</div>
</body></html>
<?php
}
//----------------------------------------------------------------------------------------//
/**
* Function to get a user selected theme file
*/
function getTheme() {
global $bcoosConfig, $xoopsUser;
if (!$xoopsUser) {
	return $bcoosConfig['default_theme'];
	}
$themedir = XOOPS_ROOT_PATH . "/themes";
$theme    = $xoopsUser->getVar("theme");
if ( @file_exists("$themedir/$theme/theme.php") ) {
	return $theme;
	} else {
	return $bcoosConfig['default_theme'];
	}
}
//----------------------------------------------------------------------------------------//
/**
* Function to get css file for a certain theme
*/
function getcss($theme) {
global $xoopsModule;
$theme_dir = XOOPS_ROOT_PATH.'/themes/'.$theme.'/style';
$theme_url = XOOPS_URL.'/themes/'.$theme.'/style';
$mod_dir   = $xoopsModule ? $xoopsModule->dirname() : FALSE;
if ( preg_match('/(MSIE)|(Opera)/i', _HTTP_USER_AGENT) ) {
	if ( $mod_dir && @file_exists($theme_dir.'/'.$mod_dir.'_style.css') ) {
		return ($theme_url.'/'.$mod_dir.'_style.css');
		} elseif ( @file_exists($theme_dir.'/style.css') ) {
			return ($theme_url.'/style.css');
		}
	} else {
	if ( $mod_dir && @file_exists($theme_dir.'/'.$mod_dir.'_styleNN.css') ) {
		return ($theme_url.'/'.$mod_dir.'_styleNN.css');
		} elseif ( @file_exists($theme_dir.'/styleNN.css') ) {
			return ($theme_url.'/styleNN.css');
			} elseif ( $mod_dir && @file_exists($theme_dir.'/'.$mod_dir.'_style.css') ) {
				return ($theme_url.'/'.$mod_dir.'_style.css');
				} elseif ( @file_exists($theme_dir.'/style.css') ) {
					return ($theme_url.'/style.css');
				}
	}
}
//---------------------------------------------------------------------------------------//
/**
* Returns resized dimension values for a given image
* Copy this function if ya like, but dont use it ..will prolly be moved.
*
* Example:
* if ( $size = resizedImage("/images/image.gif", 50, "h") ) {
* 	$size = " height='$size[h]' width='$size[w]'";
* 	}
* echo "<img src='".XOOPS_URL."/images/image.gif' border='0'$size>";
*
* @param string $image File or URL path to image in question
* @param integer $maxsize Maximum size of image
* @param string $orientation What $maxsize applies to: height or width
* @return array An array containing the height/width values
*/
function resizedImage($image, $maxsize=150, $orientation="w" ) {
if ( $maxsize == 0 || !is_numeric($maxsize) ) {
	$maxsize = 150;
	}
if ( $orientation != "w" && $orientation != "h" ) {
	$orientation = "w";
	}
$size = @getimagesize($image);
if ( is_numeric($size[0]) && is_numeric($size[1]) ) {
	$img['w'] = $size[0];
	$img['h'] = $size[1];
	switch($orientation) {
	case "w":
		if ( $img['w'] > $maxsize ) {
			$img['h'] = round( ( $img['h'] / ($img['w'] / $maxsize) ) );
			$img['w'] = $maxsize;
		}
		break;
	case "h":
		if ( $img['h'] > $maxsize ) {
			$img['w'] = round( ( $img['w'] / ($img['h'] / $maxsize) ) );
			$img['h'] = $maxsize;
		}
		break;
	}
	return $img;
	} else {
		return(FALSE);
	}
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function avatarExists($uid) {
global $bcoosConfig,$db;
$result = $db->query("SELECT user_avatar FROM ".$db->prefix('users')." WHERE uid=".$uid."");
	if ($result) {
		$arrayresult = $db->fetchArray($result);
		return $arrayresult['user_avatar'];
	} else {
		return false;
	}
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function &getMailer() {
global $bcoosConfig;
if ( class_exists("xoopsmailer") ) {
	return new XoopsMailer();
	} else {
		include_once(XOOPS_ROOT_PATH."/class/xoopsmailer.php");
		return new XoopsMailer();
	}
}
//--------------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function cookie($name, $value='', $time=0, $path='/') {
$expire = gmdate("D, d-M-Y H:i:s", time()+$time);
$time ? header("Set-Cookie: $name=$value; expires=$expire GMT; path=$path") : header("Set-Cookie: $name=$value; path=$path");
}
// #################### Block functions from here ##################
//----------------------------------------------------------------------------------------//
/**
* Purpose : Builds the blocks on both sides
* Input   : $side = On wich side should the block are displayed?
* 0, l, left : On the left side
* 1, r, right: On the right side
*  other:   Only on one side (
* Call from theme.php makes all blocks on the left side
* and from theme.php for the right site)
*/
function make_sidebar($side) {
global $xoopsUser;
$xoopsblock = new XoopsBlock();
$arr = array();
if ($side == "left") {
	$side = XOOPS_SIDEBLOCK_LEFT;
	} elseif ( $side == "right" ) {
		$side = XOOPS_SIDEBLOCK_RIGHT;
		} else {
			$side = XOOPS_SIDEBLOCK_BOTH;
		}
if ($xoopsUser) {
	$arr =& $xoopsblock->getAllBlocksByGroup($xoopsUser->groups(), true, $side, XOOPS_BLOCK_VISIBLE);
	} else {
		$arr =& $xoopsblock->getAllBlocksByGroup(XoopsGroup::getByType("Anonymous"), true, $side, XOOPS_BLOCK_VISIBLE);
	}
foreach ( $arr as $myblock ) {
	$block = array();
	$block =& $myblock->buildBlock();
	if ($block) {
		if ($side == XOOPS_SIDEBLOCK_LEFT) { themesidebox_left($block['title'], $block['content']); }
		else { themesidebox_right($block['title'], $block['content']); }
	}
unset($myblock);
unset($block);
} // END FOREACH
}
//----------------------------------------------------------------------------------------//
/**
* Function to display center block
*/
function make_cblock($position='') {
global $xoopsUser, $xoopsOption;
$xoopsblock = new XoopsBlock();
$cc_block   = $cl_block = $cr_block = "";
$arr        = array();
if ( $xoopsUser ) {
	$arr =& $xoopsblock->getAllBlocksByGroup($xoopsUser->groups(), true, XOOPS_CENTERBLOCK_ALL, XOOPS_BLOCK_VISIBLE);
	} else {
		$arr =& $xoopsblock->getAllBlocksByGroup(XoopsGroup::getByType("Anonymous"), true, XOOPS_CENTERBLOCK_ALL, XOOPS_BLOCK_VISIBLE);
	}
$size = count($arr);
if ($size > 0) {
OpenTable();
	foreach ($arr as $myblock) {
		$block = array();
		$block =& $myblock->buildBlock();
	$nextblock++;
	$prevblock = ($nextblock-2);
	if ($prevblock >= 0) {
		$prev = $arr[$prevblock]->getVar("side");
		} else {
			$prev = false;
		}
	if ( $nextblock < count($arr) ) {
		$curr = $myblock->getVar("side");
		$next = $arr[$nextblock]->getVar("side");
		} else {
			$curr = $myblock->getVar("side");
			$next = false;
		}
if ($block) {
	if ($myblock->getVar("side") == XOOPS_CENTERBLOCK_LEFT) {
	if ($next == XOOPS_CENTERBLOCK_RIGHT) {
		echo "
		<table align='center' valign='top' width='100%' cellpadding='0' cellspacing='0' border='0'>
		<tr><td width='50%'>";
		themecenterbox_left($block['title'], $block['content']);
		echo "</td>";
		} else {
		echo "
		<table align='center' valign='top' width='100%' cellpadding='0' cellspacing='0' border='0'>
		<tr><td width='50%'>";
		themecenterbox_right($block['title'], $block['content']);
		echo "</td><td width='50%'>&nbsp;</td></tr></table>";
		}
	} elseif ( $myblock->getVar("side") == XOOPS_CENTERBLOCK_RIGHT ) {
	if ($prev == XOOPS_CENTERBLOCK_LEFT) {
		echo "<td width='50%'>";
		themecenterbox_right($block['title'], $block['content']);
		echo "</td></tr></table>";
		} else {
		echo "
		<table width='100%' cellpadding='0' cellspacing='0' border='0'>
		<tr><td width='50%'>&nbsp;</td><td width='50%'>";
		themecenterbox_left($block['title'], $block['content']);
		echo "</td></tr></table>";
		}
	} else {
		themecenterbox_center($block['title'], $block['content']);
	}
} // END $block
unset($myblock);
unset($block);
} // END FOREACH
CloseTable();
} // END count($arr)
}
//---------------------------------------------------------------------------------------//
/**
* Depracted
*/
function openThread($width="100%") {
}
//---------------------------------------------------------------------------------------//
/**
* Depracted
*/
function closeThread() {
}
//---------------------------------------------------------------------------------------//
/**
* Depracted & moved to theme :: use theme_post()
* Shows thread content for forum/comments
*/
function showThread($color_number, $subject_image, $subject, $text, $post_date, $ip_image, $reply_image, $edit_image, $delete_image, $username="", $rank_title="", $rank_image="", $avatar_image="", $reg_date="", $posts="", $user_from="", $online_image="", $profile_image="", $pm_image="", $email_image="", $www_image="", $icq_image="", $aim_image="", $yim_image="", $msnm_image="") {
	theme_post($subject, $text, $color_number, $subject_image, $post_date, $ip_image, $reply_image, $edit_image, $delete_image, $username, $rank_title, $rank_image, $avatar_image, $reg_date, $posts, $user_from, $online_image, $profile_image, $pm_image, $email_image, $www_image, $icq_image, $aim_image, $yim_image, $msnm_image);
	
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function ex_error_handler($errno='', $errstr='', $errfile='', $errline='') {
global $bcoosConfig;
$errortype = array (
			1    => _ERR_ERROR,
			2    => _ERR_WARNING,
			4    => _ERR_PARSE,
			8    => _ERR_NOTICE,
			16   => _ERR_CORE_ERROR,
			32   => _ERR_CORE_WARNING,
			64   => _ERR_COMPILE_ERROR,
			128  => _ERR_COMPILE_WARNING,
			256  => _ERR_USER_ERROR,
			512  => _ERR_USER_WARNING,
			1024 => _ERR_USER_NOTICE
			);
if (($bcoosConfig['debug_mode'] & 1) && (error_reporting() & $errno)) {
	$output .= '
		<div class="errhandler">
		'._ERR_NUMBER.': '.$errno.' ['.$errortype[$errno].']<br />
		'._ERR_MESSAGE.': <b>'.$errstr.'</b><br />
		'._ERR_FILE.': <a href="'.XOOPS_URL.'/class/debug/highlight.php?file='.$errfile.'&line='.$errline.'#'.$errline.'" title="'._ERR_SHOW.'" target="errcode">'.$errfile.'</a><br />
		'._ERR_LINE.': '.$errline.'
		</div><br />';
	echo $output;
}
}
//---------------------------------------------------------------------------------------//
}
?>
