<?php
//v1.0.4 www.bcoos.net 2006/10 GPL
//v1.5 www.exoops.info 2006/03 
// $Id: xoopslists.php,v 1.4 2003/03/19 06:58:01 half-dead Exp $
// ------------------------------------------------------------------------- //
//               E-Xoops: Content Management for the Masses                  //
//                       < http://www.e-xoops.com >                          //
// ------------------------------------------------------------------------- //
// Original Author: Kazumi Ono
// Author Website : http://www.mywebaddons.com/ , http://www.myweb.ne.jp
// License Type   : GPL: See /manual/LICENSES/GPL.txt
// ------------------------------------------------------------------------- //
if (!defined("XOOPS_XOOPSLISTS_INCLUDED")) {
	define("XOOPS_XOOPSLISTS_INCLUDED", 1);
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
class XoopsLists {
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function &getTimeZoneList() {
$time_zone_list = array ("-12" => _GMTM12, "-11" => _GMTM11, "-10" => _GMTM10, "-9" => _GMTM9, "-8" => _GMTM8, "-7" => _GMTM7, "-6" => _GMTM6, "-5" => _GMTM5, "-4" => _GMTM4, "-3.5" => _GMTM35, "-3" => _GMTM3, "-2" => _GMTM2, "-1" => _GMTM1, "0" => _GMT0, "1" => _GMTP1, "2" => _GMTP2, "3" => _GMTP3, "3.5" => _GMTP35, "4" => _GMTP4, "4.5" => _GMTP45, "5" => _GMTP5, "5.5" => _GMTP55, "6" => _GMTP6, "7" => _GMTP7, "8" => _GMTP8, "9" => _GMTP9, "9.5" => _GMTP95, "10" => _GMTP10, "11" => _GMTP11, "12" => _GMTP12);
return $time_zone_list;
}
//---------------------------------------------------------------------------------------//
/**
* gets list of themes folder from themes directory
*/
function &getThemesList() {
$themes_list = array();
$themes_list =& XoopsLists::getDirListAsArray(XOOPS_ROOT_PATH."/themes/");
return $themes_list;
}
//---------------------------------------------------------------------------------------//
/**
* gets list of name of directories inside a directory
*
* @param type $var description
* @return type description
*/
function &getDirListAsArray($dirname) {
$dirlist = array();
if ($handle = @opendir($dirname)) {
	while (false !== ($file = readdir($handle))) {
		if ( ($file != ".") && ($file != "..") ) {
			if ( @is_dir($dirname.$file) ) {
				$dirlist[$file] = $file;
			}
		}
	}
	closedir($handle);
	asort($dirlist);
	reset($dirlist);
}
return $dirlist;
}
//---------------------------------------------------------------------------------------//
/**
* gets list of image file names in a directory
*
* @param type $var description
* @return type description
*/
function &getImgListAsArray($dirname, $prefix="") {
$filelist = array();
if ($handle = @opendir($dirname)) {
	while (false !== ($file = readdir($handle))) {
		if ( preg_match("/\.(gif|jpg|png)$/i", $file) ) {
			$file = $prefix.$file;
			$filelist[$file] = $file;
		}
	}
	closedir($handle);
	asort($filelist);
	reset($filelist);
}
return $filelist;
}

//---------------------------------------------------------------------------------------//
/**
* gets list of Iconset names in a directory
*
* @param type $var description
* @return type description
*/
function &getImgIconsetAsArray($dirname, $prefix="") {
$filelist = array();
if ($handle = @opendir($dirname)) {
	while (false !== ($file = readdir($handle))) {
		$arrayname = explode("_",$file);
		if ($iconsetname !== $arrayname[0]) {
			if ( preg_match("/\.(gif|jpg|png)$/i", $file) ) { 
				$iconsetname = $arrayname[0]; 
				$filelist[$iconsetname] = $iconsetname;	
			}
		} else { if ( preg_match("/\.(gif|jpg|png|html|htm)$/i", $file) ) {  $iconsetname = $arrayname[0];  }	}		
	}
	closedir($handle);
	asort($filelist);
	reset($filelist);
}
return $filelist;
}

//---------------------------------------------------------------------------------------//
/**
* gets list of avatar file names in a certain directory
* if directory is not specified, default directory will be searched
*
* @param type $var description
* @return type description
*/
function &getAvatarsList($avatar_dir="") {
$avatars = array();
if ( $avatar_dir != "" ) {
	$avatars =& XoopsLists::getImgListAsArray(XOOPS_ROOT_PATH."/images/avatar/".$avatar_dir."/", $avatar_dir."/");
	} else {
		$avatars =& XoopsLists::getImgListAsArray(XOOPS_ROOT_PATH."/images/avatar/");
	}
return $avatars;
}
//---------------------------------------------------------------------------------------//
/**
* gets list of all avatar image files inside default avatars directory
*/
function &getAllAvatarsList() {
$avatars = array();
$dirlist = array();
$dirlist =& XoopsLists::getDirListAsArray(XOOPS_ROOT_PATH."/images/avatar/");
if ( count($dirlist) > 0 ) {
	foreach ( $dirlist as $dir ) {
		$avatars[$dir] =& XoopsLists::getImgListAsArray(XOOPS_ROOT_PATH."/images/avatar/".$dir."/", $dir."/");
	}
	} else {
		return false;
	}
return $avatars;
}
//---------------------------------------------------------------------------------------//
/**
* gets list of subject icon image file names in a certain directory
* if directory is not specified, default directory will be searched
*
* @param type $var description
* @return type description
*/
function &getSubjectsList($sub_dir="") {
$subjects = array();
if ($sub_dir != "") {
	$subjects =& XoopsLists::getImgListAsArray(XOOPS_ROOT_PATH."/images/subject/".$sub_dir, $sub_dir."/");
	} else {
		$subjects =& XoopsLists::getImgListAsArray(XOOPS_ROOT_PATH."/images/subject/");
	}
return $subjects;
}
//---------------------------------------------------------------------------------------//
/**
* gets list of language folders inside default language directory
*/
function &getLangList() {
$lang_list = array();
$lang_list =& XoopsLists::getDirListAsArray(XOOPS_ROOT_PATH."/language/");
return $lang_list;
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function &getHtmlList() {
$html_list = array (
	"a"          => "&lt;a&gt;",
	"abbr"       => "&lt;abbr&gt;",
	"acronym"    => "&lt;acronym&gt;",
	"address"    => "&lt;address&gt;",
	"applet"     => "&lt;applet&gt;",
	"area"       => "&lt;area&gt;",
	"b"          => "&lt;b&gt;",
	"base"       => "&lt;base&gt;",
	"basefont"   => "&lt;basefont&gt;",
	"bdo"        => "&lt;bdo&gt;",
	"big"        => "&lt;big&gt;",
	"blockquote" => "&lt;blockquote&gt;",
	"body"       => "&lt;body&gt;",
	"br"         => "&lt;br&gt;",
	"button"     => "&lt;button&gt;",
	"caption"    => "&lt;caption&gt;",
	"center"     => "&lt;center&gt;",
	"cite"       => "&lt;cite&gt;",
	"code"       => "&lt;code&gt;",
	"col"        => "&lt;col&gt;",
	"colgroup"   => "&lt;colgroup&gt;",
	"dd"         => "&lt;dd&gt;",
	"del"        => "&lt;del&gt;",
	"dfn"        => "&lt;dfn&gt;",
	"dir"        => "&lt;dir&gt;",
	"div"        => "&lt;div&gt;",
	"dl"         => "&lt;dl&gt;",
	"dt"         => "&lt;dt&gt;",
	"em"         => "&lt;em&gt;",
	"embed"      => "&lt;embed&gt;",
	"fieldset"   => "&lt;fieldset&gt;",
	"font"       => "&lt;font&gt;",
	"form"       => "&lt;form&gt;",
	"frame"      => "&lt;frame&gt;",
	"frameset"   => "&lt;frameset&gt;",
	"h1"         => "&lt;h1&gt;",
	"h2"         => "&lt;h2&gt;",
	"h3"         => "&lt;h3&gt;",
	"h4"         => "&lt;h4&gt;",
	"h5"         => "&lt;h5&gt;",
	"h6"         => "&lt;h6&gt;",
	"head"       => "&lt;head&gt;",
	"hr"         => "&lt;hr&gt;",
	"html"       => "&lt;html&gt;",
	"i"          => "&lt;i&gt;",
	"iframe"     => "&lt;iframe&gt;",
	"img"        => "&lt;img&gt;",
	"input"      => "&lt;input&gt;",
	"ins"        => "&lt;ins&gt;",
	"kbd"        => "&lt;kbd&gt;",
	"label"      => "&lt;label&gt;",
	"legend"     => "&lt;legend&gt;",
	"li"         => "&lt;li&gt;",
	"link"       => "&lt;link&gt;",
	"map"        => "&lt;map&gt;",
	"menu"       => "&lt;menu&gt;",
	"meta"       => "&lt;meta&gt;",
	"noframes"   => "&lt;noframes&gt;",
	"noscript"   => "&lt;noscript&gt;",
	"object"     => "&lt;object&gt;",
	"ol"         => "&lt;ol&gt;",
	"optgroup"   => "&lt;optgroup&gt;",
	"option"     => "&lt;option&gt;",
	"p"          => "&lt;p&gt;",
	"param"      => "&lt;param&gt;",
	"pre"        => "&lt;pre&gt;",
	"q"          => "&lt;q&gt;",
	"s"          => "&lt;s&gt;",
	"samp"       => "&lt;samp&gt;",
	"script"     => "&lt;script&gt;",
	"select"     => "&lt;select&gt;",
	"small"      => "&lt;small&gt;",
	"span"       => "&lt;span&gt;",
	"strike"     => "&lt;strike&gt;",
	"strong"     => "&lt;strong&gt;",
	"style"      => "&lt;style&gt;",
	"sub"        => "&lt;sub&gt;",
	"sup"        => "&lt;sup&gt;",
	"table"      => "&lt;table&gt;",
	"tbody"      => "&lt;tbody&gt;",
	"td"         => "&lt;td&gt;",
	"textarea"   => "&lt;textarea&gt;",
	"tfoot"      => "&lt;tfoot&gt;",
	"th"         => "&lt;th&gt;",
	"thead"      => "&lt;thead&gt;",
	"title"      => "&lt;title&gt;",
	"tr"         => "&lt;tr&gt;",
	"tt"         => "&lt;tt&gt;",
	"u"          => "&lt;u&gt;",
	"ul"         => "&lt;ul&gt;",
	"var"        => "&lt;var&gt;"
	);
asort($html_list);
reset($html_list);
return $html_list;
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function &getUserRankList() {
global $myts, $db;
$sql    = "SELECT rank_id, rank_title FROM ".$db->prefix("ranks")." WHERE rank_special = 1";
$ret    = array();
$result = $db->query($sql);
while ( $myrow = $db->fetchArray($result) ) {
	$ret[$myrow['rank_id']] = $myts->makeTboxData4Show($myrow['rank_title']);
}
return $ret;
}
//---------------------------------------------------------------------------------------//
} // END XOOPSLISTS
//---------------------------------------------------------------------------------------//
}
?>
