<?php
//v1.4 www.exoops.info 2006/03 
// $Id: xoopsgroup.php,v 1.3 2003/03/19 06:58:01 half-dead Exp $
// ------------------------------------------------------------------------- //
//               E-Xoops: Content Management for the Masses                  //
//                       < http://www.e-xoops.com >                          //
// ------------------------------------------------------------------------- //
// Original Author: Kazumi Ono
// Author Website : http://www.mywebaddons.com/ , http://www.myweb.ne.jp
// License Type   : GPL: See /manual/LICENSES/GPL.txt
// ------------------------------------------------------------------------- //
if (!defined("XOOPS_XOOPSGROUP_INCLUDED")) {
	define("XOOPS_XOOPSGROUP_INCLUDED", 1);
include_once(XOOPS_ROOT_PATH."/class/xoopsobject.php");
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
class XoopsGroup extends XoopsObject {
	var $admin_right_modules = array();
	var $read_right_modules  = array();
	var $read_right_blocks   = array();
	function XoopsGroup($id = NULL) {
	$this->XoopsObject();
	$this->initVar("groupid", "int", NULL, false);
	$this->initVar("name", "textbox", NULL, true, 100, false);
	$this->initVar("description", "textarea", NULL, true);
	$this->initVar("type", "other", NULL, false);
	if ( !empty($id) ) {
		if ( is_array($id) ) {
			$this->set($id);
			} else {
				$this->load(intval($id));
			}
		}
	}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function load($groupid) {
global $db;
$sql = "SELECT * FROM ".$db->prefix("groups")." WHERE groupid=".$groupid."";
$arr = $db->fetchArray($db->query($sql));
$this->set($arr);
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function setAdminRightModules($arr=array()) {
	sort($arr);
	$this->admin_right_modules = $arr;
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function setReadRightModules($arr=array()) {
	sort($arr);
	$this->read_right_modules = $arr;
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function setReadRightBlocks($arr=array()) {
	sort($arr);
	$this->read_right_blocks = $arr;
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function store() {
global $db;
if ( !$this->isCleaned() ) {
	if ( !$this->cleanVars() ) {
		return false;
	}
}
foreach ( $this->cleanVars as $k=>$v ) {
	$$k = $v;
}
if ( empty($type) ) {
	if ( is_array($this->admin_right_modules) && count($this->admin_right_modules)>0 ) {
		$type = "Admin";
		} else {
			$type = "Custom";
		}
	}
if ( empty($groupid) ) {
	$groupid = $db->genId($db->prefix("groups")."_groupid_seq");
	$sql     = "INSERT INTO ".$db->prefix("groups")." SET groupid=$groupid, name='".$name."', description='".$description."', type='".$type."'";
	} else {
		$sql = "DELETE FROM ".$db->prefix("groups_modules_link")." WHERE groupid=".$groupid."";
		if ( !$result = $db->query($sql) ) {
			exit();
		}
		$sql = "DELETE FROM ".$db->prefix("groups_blocks_link")." WHERE groupid=".$groupid."";
		if ( !$result = $db->query($sql) ) {
			exit();
		}
		$sql = "UPDATE ".$db->prefix("groups")." SET name='".$name."', description='".$description."', type='".$type."' WHERE groupid=".$groupid."";
	}
if ( !$result = $db->query($sql) ) {
	$this->setErrors("Could not store data in database.");
	return false;
}
if ( empty($groupid) ) {
	$groupid = $db->getInsertId();
}
foreach($this->admin_right_modules as $admin_right_module) {
	$sql = "INSERT INTO ".$db->prefix("groups_modules_link")." SET groupid=$groupid, mid=$admin_right_module, type='A'";
	$result = $db->query($sql);
	$sql = "INSERT INTO ".$db->prefix("groups_modules_link")." SET groupid=$groupid, mid=$admin_right_module, type='R'";
	$result = $db->query($sql);
}
foreach($this->read_right_modules as $read_right_module) {
	if ( !in_array($read_right_module, $this->admin_right_modules ) ) {
		$sql = "INSERT INTO ".$db->prefix("groups_modules_link")." SET groupid=$groupid, mid=$read_right_module, type='R'";
		$result = $db->query($sql);
	}
}
foreach($this->read_right_blocks as $read_right_block){
	$sql = "INSERT INTO ".$db->prefix("groups_blocks_link")." SET groupid=$groupid, block_id=$read_right_block, type='R'";
	$result = $db->query($sql);
}
return $groupid;
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function delete() {
global $db;
if ( !$result = $db->query("DELETE FROM ".$db->prefix("groups")." WHERE groupid=".$this->getVar("groupid")."") ) {
	exit();
}
$result = $db->query("DELETE FROM ".$db->prefix("groups_users_link")." WHERE groupid=".$this->getVar("groupid")."");
$result = $db->query("DELETE FROM ".$db->prefix("groups_modules_link")." WHERE groupid=".$this->getVar("groupid")."");
$result = $db->query("DELETE FROM ".$db->prefix("groups_blocks_link")." WHERE groupid=".$this->getVar("groupid")."");
return true;
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function checkRight($which, $id, $groupid=0, $type="R") {
global $db;
if ( $which == "module" ) {
	$table  = "groups_modules_link";
	$column = "mid";
	} elseif ( $which == "block" ) {
		$table  = "groups_blocks_link";
		$column = "block_id";
	}
$sql = "SELECT COUNT(*) FROM ".$db->prefix($table)." WHERE  type='".$type."'";
if ( !empty($id) ) {
	$sql .= " AND ".$column."=".$id."";
}
if ( is_array($groupid) ) {
	$sql .= " AND (groupid=".$groupid[0]."";
	$size = count($groupid);
	if ($size > 1) {
		for ($i=1; $i<$size; $i++) {
			$sql .= " OR groupid=".$groupid[$i]."";
		}
	}
	$sql .= ")";
	} elseif ($groupid != 0) {
		$sql .= " AND groupid=".$groupid."";
		} else {
			$grouparray = XoopsGroup::getByType("Anonymous");
			$sql .= " AND groupid=".$grouparray[0]."";
		}
list($count) = $db->fetchRow($db->query($sql));
if ($count > 0) {
	return true;
}
return false;
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function &getByUser(&$user, $asobject=false) {
global $db;
$ret = array();
if ( strtolower(get_class($user)) == "xoopsuser" ) {
	$sql    = "SELECT g.* FROM ".$db->prefix("groups")." g LEFT JOIN ".$db->prefix("groups_users_link")." l ON l.groupid=g.groupid WHERE l.uid=".$user->getVar("uid")."";
	$result = $db->query($sql);
	if ( !$db->getRowsNum($result) ) {
		$group_arr =& XoopsGroup::getByType("User", true);
		$group_arr[0]->addMember($user);
		if ( $asobject ) {
			$ret[] = $group_arr[0];
			} else {
				$ret[] = $group_arr[0]->getVar("groupid");
			}
		} else {
			while ( $myrow = $db->fetchArray($result) ) {
				if ( $asobject ) {
					$ret[] = new XoopsGroup($myrow);
					} else {
						$ret[] = $myrow['groupid'];
					}
			}
		}
	}
return $ret;
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function &getByType($type="", $asobject=false, $sort="groupid", $order="ASC") {
global $db;
$ret = array();
$where_query = "";
if ( !empty($type) ) {
	$where_query = " WHERE type='".$type."'";
}
if ( !$asobject ) {
	$sql = "SELECT groupid FROM ".$db->prefix("groups")."".$where_query." ORDER BY $sort $order";
	$result = $db->query($sql);
	while ( $myrow = $db->fetchArray($result) ) {
		$ret[] = $myrow['groupid'];
	}
	} else {
		$sql = "SELECT * FROM ".$db->prefix("groups")."".$where_query." ORDER BY $sort $order";
		$result = $db->query($sql);
		while ( $myrow = $db->fetchArray($result) ) {
			$ret[] = new XoopsGroup($myrow);
		}
	}
return $ret;
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function &getAllGroupsList($criteria=array(), $sort="groupid", $order="ASC") {
global $db;
$ret = array();
$where_query = "";
if ( is_array($criteria) && count($criteria) > 0 ) {
	$where_query = " WHERE";
	foreach ( $criteria as $c ) {
		$where_query .= " $c AND";
	}
	$where_query = substr($where_query, 0, -4);
}
$sql    = "SELECT groupid, name FROM ".$db->prefix("groups")."$where_query ORDER BY $sort $order";
$result = $db->query($sql);
while ( $myrow = $db->fetchArray($result) ) {
	$ret[$myrow['groupid']] = $myrow['name'];
}
return $ret;
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function &getMembers($asobject=false) {
global $db;
$ret = array();
if ( !$asobject ) {
	$sql    = "SELECT uid FROM ".$db->prefix("groups_users_link")." WHERE groupid=".$this->getVar("groupid")." GROUP BY uid";
	$result = $db->query($sql);
	while ( $myrow = $db->fetchArray($result) ) {
		$ret[] = $myrow['uid'];
	}
	} else {
		$sql = "
			SELECT u.* FROM
			".$db->prefix("groups_users_link")." l,
			".$db->prefix("users")." u
			WHERE
			l.groupid=".$this->getVar("groupid")."
			AND
			u.uid=l.uid";
		$result = $db->query($sql);
		while ( $myrow = $db->fetchArray($result) ) {
			$obj   = new XoopsUser($myrow);
			$ret[] = $obj;
		}
	}
return $ret;
}
//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function addMember(&$user) {
global $db;
if ( strtolower(get_class($user)) == "xoopsuser" ) {
	$db->query("INSERT INTO ".$db->prefix("groups_users_link")." SET groupid=".$this->getVar("groupid").", uid=".$user->getVar("uid")."");
	return true;
}
return false;
}
// ------------------------------------------------------------------------- //
} // END CLASS GROUP
// ------------------------------------------------------------------------- //
}
?>
