/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.DispatchThread;
import irc.EventItem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class EventDispatcher {
    private static Hashtable _cache = new Hashtable();
    private static DispatchThread _thread = null;
    private static boolean _warning = true;

    private static void ensureAlive() {
        if (_thread == null || !_thread.isAlive()) {
            _thread = new DispatchThread();
        }
    }

    private static boolean match(Class[] classArray, Class[] classArray2) {
        if (classArray.length != classArray2.length) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray2[i] == null || classArray[i].isAssignableFrom(classArray2[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Hashtable hashtable = _cache;
        synchronized (hashtable) {
            _cache.clear();
        }
    }

    public static void disableBadThreadWarning() {
        _warning = false;
    }

    public static void enableBadThreadWarning() {
        _warning = true;
    }

    public static Object dispatchEventSync(Object object, String string, Object[] objectArray) {
        try {
            return EventDispatcher.dispatchEventSyncEx(object, string, objectArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object dispatchEventSyncEx(Object object, String string, Object[] objectArray) throws Throwable {
        EventDispatcher.ensureAlive();
        if (_warning && !EventDispatcher.isEventThread()) {
            System.err.println("Event dispatch in wrong thread");
            System.err.println("expected thread was " + _thread);
            System.err.println("current thread is " + Thread.currentThread());
            System.err.println("please submit a bug report to plouf@pjirc.com with the following information :");
            Thread.dumpStack();
        }
        try {
            Class<?> clazz = object.getClass();
            Class[] classArray = _cache;
            synchronized (_cache) {
                int n;
                Method[] methodArray = (Method[])_cache.get(clazz);
                if (methodArray == null) {
                    methodArray = clazz.getMethods();
                    _cache.put(clazz, methodArray);
                }
                // ** MonitorExit[var5_6] (shouldn't be in output)
                classArray = new Class[objectArray.length];
                for (n = 0; n < objectArray.length; ++n) {
                    classArray[n] = objectArray[n] != null ? objectArray[n].getClass() : null;
                }
                for (n = 0; n < methodArray.length; ++n) {
                    if (!methodArray[n].getName().equals(string) || !EventDispatcher.match(methodArray[n].getParameterTypes(), classArray)) continue;
                    return methodArray[n].invoke(object, objectArray);
                }
                throw new NoSuchMethodException(string);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        catch (Throwable throwable) {
            System.err.println("internal error");
            System.err.println("please submit a bug report to plouf@pjirc.com with the following information :");
            throwable.printStackTrace();
            return null;
        }
    }

    public static void dispatchEventAsync(Object object, String string, Object[] objectArray) {
        EventDispatcher.ensureAlive();
        _thread.addEvent(object, string, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object dispatchEventAsyncAndWaitEx(Object object, String string, Object[] objectArray) throws InterruptedException, Throwable {
        if (EventDispatcher.isEventThread()) {
            return EventDispatcher.dispatchEventSyncEx(object, string, objectArray);
        }
        EventDispatcher.ensureAlive();
        EventItem eventItem = _thread.addEvent(object, string, objectArray);
        Object object2 = eventItem.endLock;
        synchronized (object2) {
            if (eventItem.resultAvailable) {
                return eventItem.result;
            }
            eventItem.endLock.wait();
            if (eventItem.resultException != null) {
                throw eventItem.resultException;
            }
            return eventItem.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object dispatchEventAsyncAndWait(Object object, String string, Object[] objectArray) throws InterruptedException {
        if (EventDispatcher.isEventThread()) {
            return EventDispatcher.dispatchEventSync(object, string, objectArray);
        }
        EventDispatcher.ensureAlive();
        EventItem eventItem = _thread.addEvent(object, string, objectArray);
        Object object2 = eventItem.endLock;
        synchronized (object2) {
            if (eventItem.resultAvailable) {
                return eventItem.result;
            }
            eventItem.endLock.wait();
            return eventItem.result;
        }
    }

    public static boolean isEventThread() {
        EventDispatcher.ensureAlive();
        return Thread.currentThread() == _thread;
    }
}

