/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.ChannelInterpretor;
import irc.ChannelListener;
import irc.IRCConfiguration;
import irc.IRCServer;
import irc.IRCSource;
import irc.ListenerGroup;
import irc.ModeHandler;
import irc.Nick;
import irc.ReplyServerListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class Channel
extends IRCSource
implements ReplyServerListener {
    private String _name;
    private String _topic;
    private ModeHandler _mode;
    private ListenerGroup _listeners;
    private Hashtable _nicks;

    public Channel(IRCConfiguration iRCConfiguration, String string, IRCServer iRCServer) {
        super(iRCConfiguration, iRCServer);
        this._name = string;
        this._topic = "";
        this._mode = new ModeHandler(iRCServer.getChannelModes(), iRCServer.getNickModes());
        this._listeners = new ListenerGroup();
        this._nicks = new Hashtable();
        iRCServer.addReplyServerListener(this);
        if (this._ircConfiguration.getASLMaster()) {
            this.getIRCServer().execute("WHO " + this._name);
        }
        this.setInterpretor(new ChannelInterpretor(iRCConfiguration));
    }

    public void release() {
        ((IRCServer)this._server).removeReplyServerListener(this);
        super.release();
    }

    public void addChannelListener(ChannelListener channelListener) {
        this._listeners.addListener(channelListener);
    }

    public void removeChannelListener(ChannelListener channelListener) {
        this._listeners.removeListener(channelListener);
    }

    public String getType() {
        return "Channel";
    }

    public String getName() {
        return this._name;
    }

    public boolean talkable() {
        return true;
    }

    public void leave() {
        this.getIRCServer().leaveChannel(this.getName());
    }

    public boolean hasNick(String string) {
        return this._nicks.get(string.toLowerCase(Locale.ENGLISH)) != null;
    }

    public void joinNick(String string, String string2) {
        this._nicks.put(string.toLowerCase(Locale.ENGLISH), new Nick(string, string2, this.getIRCServer().getChannelModes(), this.getIRCServer().getNickModes()));
        if (this._ircConfiguration.getASLMaster()) {
            this.getIRCServer().execute("WHO " + string);
        }
        this._listeners.sendEvent("nickJoin", string, string2, this);
    }

    public void setNicks(String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            this._nicks.put(stringArray[i].toLowerCase(Locale.ENGLISH), new Nick(stringArray[i], stringArray2[i], this.getIRCServer().getChannelModes(), this.getIRCServer().getNickModes()));
        }
        this._listeners.sendEvent("nickSet", stringArray, stringArray2, this);
    }

    public void partNick(String string, String string2) {
        this._nicks.remove(string.toLowerCase(Locale.ENGLISH));
        this._listeners.sendEvent("nickPart", string, string2, this);
    }

    public void kickNick(String string, String string2, String string3) {
        this._nicks.remove(string.toLowerCase(Locale.ENGLISH));
        this._listeners.sendEvent("nickKick", new Object[]{string, string2, string3, this});
    }

    public void quitNick(String string, String string2) {
        this._nicks.remove(string.toLowerCase(Locale.ENGLISH));
        this._listeners.sendEvent("nickQuit", string, string2, this);
    }

    public String[] getNicks() {
        String[] stringArray = new String[this._nicks.size()];
        Enumeration enumeration = this._nicks.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = ((Nick)enumeration.nextElement()).Name;
        }
        return stringArray;
    }

    public String getNickMode(String string) {
        Nick nick = (Nick)this._nicks.get(string.toLowerCase(Locale.ENGLISH));
        if (nick == null) {
            return null;
        }
        return nick.Mode.getMode();
    }

    public void setTopic(String string, String string2) {
        this._topic = string;
        this._listeners.sendEvent("topicChanged", string, string2, this);
    }

    public void applyUserMode(String string, String string2, String string3) {
        Nick nick = (Nick)this._nicks.get(string.toLowerCase(Locale.ENGLISH));
        if (nick != null) {
            nick.Mode.apply(string2);
        }
        this._listeners.sendEvent("nickModeApply", new Object[]{string, string2, string3, this});
    }

    public void applyMode(String string, String string2) {
        this._mode.apply(string);
        this._listeners.sendEvent("modeApply", string, string2, this);
    }

    public String getMode() {
        return this._mode.getMode();
    }

    public String getTopic() {
        return this._topic;
    }

    public void changeNick(String string, String string2) {
        Nick nick = (Nick)this._nicks.get(string.toLowerCase(Locale.ENGLISH));
        this._nicks.remove(string.toLowerCase(Locale.ENGLISH));
        nick.Name = string2;
        this._nicks.put(string2.toLowerCase(Locale.ENGLISH), nick);
        this._listeners.sendEvent("nickChanged", string, string2, this);
    }

    private void learn(String string, String string2) {
        Nick nick = (Nick)this._nicks.get(string.toLowerCase(Locale.ENGLISH));
        if (nick == null) {
            return;
        }
        nick.Whois = string2;
        this._listeners.sendEvent("nickWhoisUpdated", string, string2, this);
    }

    public String whois(String string) {
        Nick nick = (Nick)this._nicks.get(string.toLowerCase(Locale.ENGLISH));
        if (nick == null) {
            return "";
        }
        return nick.Whois;
    }

    public Boolean replyReceived(String string, String string2, String[] stringArray, IRCServer iRCServer) {
        if (string2.equals("352")) {
            String string3 = stringArray[stringArray.length - 1];
            int n = string3.indexOf(" ");
            if (n != -1) {
                string3 = string3.substring(n + 1);
            }
            String string4 = stringArray[5];
            this.learn(string4, string3);
        }
        return Boolean.FALSE;
    }
}

