/* Import plugin specific language pack */
tinyMCE.importPluginLanguagePack('mysave2', 'en'); // <- Add a comma separated list of all supported languages

/****
 * Steps for creating a plugin from this mysave2:
 *
 * 1. Change all "mysave2" to the name of your plugin.
 * 2. Remove all the callbacks in this file that you don't need.
 * 3. Remove the popup.htm file if you don't need any popups.
 * 4. Add your custom logic to the callbacks you needed.
 * 5. Write documentation in a readme.txt file on how to use the plugin.
 * 6. Upload it under the "Plugins" section at sourceforge.
 *
 ****/


/**
 * Gets executed when a editor needs to generate a button.
 */
function TinyMCE_mysave2_getControlHTML(control_name) {
	switch (control_name) {
		case "mysave2":
			return '<img id="{$editor_id}_mysave2" src="{$pluginurl}/images/mysave2.gif" title="{$lang_mysave2_desc}" width="20" height="20" class="mceButtonNormal" onmouseover="tinyMCE.switchClass(this,\'mceButtonOver\');" onmouseout="tinyMCE.restoreClass(this);" onmousedown="tinyMCE.restoreAndSwitchClass(this,\'mceButtonDown\');tinyMCE.execInstanceCommand(\'{$editor_id}\',\'mceTemplate\', true);" />';
	}

	return "";
}

/**
 * Gets executed when a command is called.
 */
function TinyMCE_mysave2_execCommand(editor_id, element, command, user_interface, value) {
	// Handle commands
	switch (command) {
		// Remember to have the "mce" prefix for commands so they don't intersect with built in ones in the browser.
		case "mceTemplate":
			tinyMCE.triggerSave();
			return true;
	}

	// Pass to next handler in chain
	return false;
}
