
tinyMCE.init({
		theme : "advanced",
		//language : "de",
		mode : "none",
		elements : "elm1,test_content",
		//insertlink_callback : "customInsertLink",
		//insertimage_callback : "customInsertImage",
		save_callback : "customSave",
		content_css : "micro_cms_files/default.css",
		extended_valid_elements : "a[href|target|name]",
		plugins : "table,iespell,mysave2,ibrowser,insertdatetime,searchreplace,paste",
		theme_advanced_layout_manager : "RowLayout",
		theme_advanced_containers : "top1,top2,top3,mceEditor,mceElementpath",
		theme_advanced_containers_default_class : "mceToolbar",
		theme_advanced_containers_default_align : "center",
		theme_advanced_container_top1_align : "center",
		theme_advanced_container_top2_align : "center",
		theme_advanced_container_top3_align : "center",
		theme_advanced_container_top1 : "mysave2,bold,italic,underline,strikethrough,styleselect,formatselect",

		theme_advanced_container_top2 : "iespell,undo,separator,redo,bullist,numlist,outdent,indent,separator,link,unlink,anchor,separator,image,hr,charmap,separator,removeformat",

		theme_advanced_container_top3 : "pastetext,pasteword,separator,table,row_props,cell_props,merge_cells,split_cells,separator,search,replace,sub,sup,separator,insertdate,inserttime,code",
		theme_advanced_container_top1_class : "mceToolbarTop",
		theme_advanced_container_top2_class : "mceToolbarTop",
		theme_advanced_container_top3_class : "mceToolbarTop",
		theme_advanced_container_top4_class : "mceToolbarTop",
		theme_advanced_container_mceElementpath_class : "mcePathBottom",
theme_advanced_container_bottom1 : "",
		theme_advanced_container_bottom1_align : "left",
		theme_advanced_container_bottom1_class :  "mceToolbarBottom",
		plugin_insertdate_dateFormat : "%Y-%m-%d",
		plugin_insertdate_timeFormat : "%I:%M %p",
		theme_advanced_resizing : true,		
		theme_advanced_resize_horizontal : false,
		paste_convert_headers_to_strong : true,
		//invalid_elements : "a",
		theme_advanced_styles : "<?php echo constructStyles(); ?>", // Theme specific setting CSS classes
		debug : false,
		height : "250"
	});
		
		
	// Custom save callback, gets called when the contents is to be submitted
	function customSave(id, content) {
		saveContent(content, id);
	}
	
	function removeTiny() {
		tinyMCE.removeTinyMCEFormElements();
	}
	var lastEditorId = '';
	var tinyMCEmode = false;
	function toogleEditorMode(sEditorID,to_save) {
		if (lastEditorId != '' && lastEditorId != sEditorID) {
			button_div = "button_div_" + lastEditorId;
			tinyMCE.removeMCEControl(tinyMCE.getEditorId(lastEditorId));
			tinyMCEmode = false;
			document.getElementById(button_div).innerHTML = '<input type="image" id="editbutton_' + lastEditorId + '" src="/micro_cms_files/cms/images/button-edit.gif" alt="Edits" title="Edit this content" onClick="toogleEditorMode(\'' + lastEditorId + '\');" />';
			hideRevertButtons(lastEditorId);
			//alert('Please remember to close one editor window before opening another one on the same page.' + lastEditorId);
			lastEditorId = '';
		}
		button_div = "button_div_" + sEditorID;
		try {
        if(tinyMCEmode) {
						hideRevertButtons(sEditorID);
						if (to_save == 1) {
							tinyMCE.triggerSave();
						}
            tinyMCE.removeMCEControl(tinyMCE.getEditorId(sEditorID));
            tinyMCEmode = false;
						document.getElementById(button_div).innerHTML = '<input type="image" id="editbutton_' + sEditorID + '" src="/micro_cms_files/cms/images/button-edit.gif" alt="Edit" title="Edit this content" onClick="toogleEditorMode(\'' + sEditorID + '\');" />';
					lastEditorId = '';
        } else {
						tinyMCE.addMCEControl(document.getElementById(sEditorID), sEditorID);
						lastEditorId = sEditorID;
            tinyMCEmode = true;
						document.getElementById(button_div).innerHTML = '<input type="image" id="editbutton_' + sEditorID + '" src="/micro_cms_files/cms/images/button-save-and-close.gif" alt="Close and Save" title="Click to close edit box and save content" onClick="toogleEditorMode(\'' + sEditorID + '\',1);" /> <input type="image" id="editbutton_' + sEditorID + '" src="/micro_cms_files/cms/images/button-close-without-saving.gif" alt="Close Without Saving" title="Click to close edit box without saving content" onClick="toogleEditorMode(\'' + sEditorID + '\',0);" />';
						hideRevertButtons(sEditorID);
        }
    } catch(e) {
        //error handling
    }
	}
	

	function saveContent(content, id) {
		subject_id = '';
		content = content.replace(/&/g,"*am*");
		content = content.replace(/=/g,"*eq*");
		content = content.replace(/\+/g,"*pl*");
		str_length = content.length;
		pages = Math.ceil(str_length / 1000);
		page_i = 1;
		while (page_i <= pages) {
			if (pages < 2) {
				alert('The content has been saved');
			} else {
				alert("Saving content - Part " + page_i + " of " + pages + "\n(Since the content is long, it must be saved in sections)");
			}
			start_str = page_i*1000 - 1000;
			end_str = start_str + 1000;
			content_part = content.substring(start_str,end_str);
			http.open("GET", "/micro_cms_files/cms/add-content.php?id=" + id + "&page=" + page_i + "&content=" + escape(content_part), true);
			http.onreadystatechange = handleHttpResponse;
			http.send(null);
			page_i++;
		}
	}
	
	var subject_id = '';
	
	function getButtons(version,id,type) {
		subject_id = "revert_buttons_" + id;
		http.open("GET", "micro_cms_files/cms/newer-older-buttons.php?id=" + id + "&version=" + version, true);
		http.onreadystatechange = handleHttpResponse;
		http.send(null);
		if (type != '') {
			revertContent(version, id, type);
		}
	}	
	
	function hideRevertButtons(id) {
		toggleLayerOn("revert_buttons_" + id);
	}
	
	function revertContent(version, id, type) {
		alert('Note: After reverting to a different version, you must save the content for the changes to be permanent.');
		subject_id = id;
		http.open("GET", "micro_cms_files/cms/revert-content.php?id=" + id + "&version=" + version + "&type=" + type, true);
		http.onreadystatechange = handleHttpResponse;
		http.send(null);
	}
