	tinyMCE.init({
		theme : "advanced",
		//language : "de",
		mode : "none",
		elements : "elm1,test_content",
		//insertlink_callback : "customInsertLink",
		//insertimage_callback : "customInsertImage",
		save_callback : "customSave",
		content_css : "../styles/default.css",
		extended_valid_elements : "a[href|target|name]",
		plugins : "table,iespell,mysave2",
		theme_advanced_buttons3_add_before : "tablecontrols,separator,iespell,mysave2",
		//invalid_elements : "a",
		theme_advanced_styles : "<?php echo constructStyles(); ?>", // Theme specific setting CSS classes
		debug : false,
		height : "250"
	});

	// Custom save callback, gets called when the contents is to be submitted
	function customSave(id, content) {
		saveContent(content, id);
	}
	
	function removeTiny() {
		tinyMCE.removeTinyMCEFormElements();
	}
	
	var tinyMCEmode = false;
	function toogleEditorMode(sEditorID,to_save) {
		button_div = "button_div_" + sEditorID;
		try {
        if(tinyMCEmode) {
						hideRevertButtons(sEditorID);
						if (to_save == 1) {
							tinyMCE.triggerSave();
						}
            tinyMCE.removeMCEControl(tinyMCE.getEditorId(sEditorID));
            tinyMCEmode = false;
						document.getElementById(button_div).innerHTML = '<input type="image" id="editbutton_' + sEditorID + '" src="/micro_cms_files/cms/images/button-edit.gif" alt="Edit" title="Edit this content" onclick="toogleEditorMode(\'' + sEditorID + '\');" />';
        } else {
						tinyMCE.addMCEControl(document.getElementById(sEditorID), sEditorID);
            tinyMCEmode = true;
						document.getElementById(button_div).innerHTML = '<input type="image" id="editbutton_' + sEditorID + '" src="/micro_cms_files/cms/images/button-save-and-close.gif" alt="Close and Save" title="Click to close edit box and save content" onclick="toogleEditorMode(\'' + sEditorID + '\',1);" /> <input type="image" id="editbutton_' + sEditorID + '" src="/micro_cms_files/cms/images/button-close-without-saving.gif" alt="Close Without Saving" title="Click to close edit box without saving content" onclick="toogleEditorMode(\'' + sEditorID + '\',0);" />';
						hideRevertButtons(sEditorID);
        }
    } catch(e) {
        //error handling
    }
	}
	

	function saveContent(content, id) {
		alert('The content for "' + id + '" has been saved');
		http.open("GET", "add-content.php?id=" + id + "&content=" + escape(content), true);
		http.onreadystatechange = handleHttpResponse(id);
		http.send(null);
	}
	
	var subject_id = '';
	
	function getButtons(version,id,type) {
		subject_id = "revert_buttons_" + id;
		http.open("GET", "cms/newer-older-buttons.php?id=" + id + "&version=" + version, true);
		http.onreadystatechange = handleHttpResponse;
		http.send(null);
		if (type != '') {
			revertContent(version, id, type);
		}
	}	
	
	function hideRevertButtons(id) {
		toggleLayerOn("revert_buttons_" + id);
	}
	
	function revertContent(version, id, type) {
		alert('Note: After reverting to a different version, you must save the content for the changes to be permanent.');
		subject_id = id;
		http.open("GET", "cms/revert-content.php?id=" + id + "&version=" + version + "&type=" + type, true);
		http.onreadystatechange = handleHttpResponse;
		http.send(null);
	}