<?php
  // Configurations

  // Folders status
  // 0 means they won't appear
  // 1 means they will appear
  $config['folders_status'] = 0;

  // Folders list
  $config['folders_list'] = array("./images","./temp");

  // Files status
  // 0 means they won't appear
  // 1 means they will appear
  $config['files_status'] = 1;

  // Files extention list
  $config['files_list'] = array(".html");

  // Do you want to save file?
  // 0 means site map generation will be displayed
  // 1 means site map generation will be saved
  // 2 means site map generation will be simply deposited in $sitemap_str variable
  $config['save'] = 1;

  // If you want to save it, what name would it be?
  // Use both relative path or absolute path
  $config['name'] = 'sitemap.html';


  // Stylesheet
  $sitemap_str .= '<style type="text/css">';
  $sitemap_str .= '.border-bottom { border-bottom: 1px solid #0099FF; }';
  $sitemap_str .= '.border-left { border-left: 1px solid #0099FF; }';
  $sitemap_str .= '.border-right { border-right: 1px solid #0099FF; }';
  $sitemap_str .= '.border-angle { border-bottom: 1px solid #0099FF; border-left: 1px solid #0099FF; }';
  $sitemap_str .= '</style>';

  // Begin Script
  $sitemap_str .= '<table width="100%" border="0" cellspacing="0" cellpadding="7">';
  $sitemap_str .= '<tr valign="middle"><td align="left">';

  $sitemap_i = 0;
  $sitemap_n = 0;
  $sitemap_dir[0] = ".";
  $sitemap_ref[0] = 0;
  
  // Folders search
  while ($sitemap_i <= $sitemap_n) {
	$sitemap_k = 1;
	if ($sitemap_handle = opendir($sitemap_dir[$sitemap_i])) {
	  while (($sitemap_file = readdir($sitemap_handle)) !== false) {
	    // Compare with forbidden folders
		$sitemap_file2 = $sitemap_dir[$sitemap_i].'/'.$sitemap_file;
		if ($config['folders_status']) {
		  $sitemap_ok = 0;
		  for (reset($config['folders_list']); (!$sitemap_ok) && ($sitemap_current = current($config['folders_list'])); next($config['folders_list']))
			if ($sitemap_current == $sitemap_file2) $sitemap_ok = 1;
		} else {
		  $sitemap_ok = 1;
		  for (reset($config['folders_list']); ($sitemap_ok) && ($sitemap_current = current($config['folders_list'])); next($config['folders_list']))
			if ($sitemap_current == $sitemap_file2) $sitemap_ok = 0;
		}

	    // Add folder to the array
	    if (is_dir($sitemap_file2) && ($sitemap_file != ".") && ($sitemap_file != "..") && ($sitemap_ok)) {
		  $sitemap_n++;
		  for ($sitemap_j = $sitemap_n; $sitemap_j > $sitemap_i + $sitemap_k; $sitemap_j--) {
		    $sitemap_dir[$sitemap_j] = $sitemap_dir[$sitemap_j - 1];
			$sitemap_ref[$sitemap_j] = $sitemap_ref[$sitemap_j - 1];
		  }
		  $sitemap_dir[$sitemap_i + $sitemap_k] = $sitemap_file2;
		  $sitemap_ref[$sitemap_i + $sitemap_k] = $sitemap_ref[$sitemap_i] + 1;
		  $sitemap_k++;
        }
	  }
      closedir($sitemap_handle);
    }
	$sitemap_i++;
  }

  // Files search
  for ($sitemap_i = 0; $sitemap_i <= $sitemap_n; $sitemap_i++) {
	// Folder name
	if ($sitemap_i) $sitemap_str_dir = basename($sitemap_dir[$sitemap_i]);
	else $sitemap_str_dir = 'Home';
	
	// Files table
	$sitemap_str .= '<table border-bottom="0" cellpadding="3" cellspacing="0">';
	$sitemap_str .= '<tr valign="middle">';
	if ($sitemap_ref[$sitemap_i]) $sitemap_str .= '<td width="22">&nbsp;</td>';
	for ($sitemap_j = 1; $sitemap_j < $sitemap_ref[$sitemap_i]; $sitemap_j++) $sitemap_str .= '<td width="22" class="border-left">&nbsp;</td>';
	$sitemap_str .= '<td class="border-angle" align="right"><img src="images/folder.gif" border-bottom="0"></td>';
	$sitemap_str .= '<td class="border-bottom" align="left"><a href="'.$sitemap_dir[$sitemap_i].'">'.$sitemap_str_dir.'</a></td>';
	$sitemap_str .= '<td>&nbsp;</td></tr>';

	if ($sitemap_handle = opendir($sitemap_dir[$sitemap_i])) {
	  while (($sitemap_file = readdir($sitemap_handle)) !== false) {
	    // Compare with extentions that are allowed
		$sitemap_name = explode(".",$sitemap_file);
		$sitemap_ext = '.'.end($sitemap_name);
		if ($config['files_status']) {
		  $sitemap_ok = 0;
		  for (reset($config['files_list']); (!$sitemap_ok) && ($sitemap_current = current($config['files_list'])); next($config['files_list']))
			if ($sitemap_current == $sitemap_ext) $sitemap_ok = 1;
		} else {
		  $sitemap_ok = 1;
		  for (reset($config['files_list']); ($sitemap_ok) && ($sitemap_current = current($config['files_list'])); next($config['files_list']))
			if ($sitemap_current == $sitemap_ext) $sitemap_ok = 0;
		}

	    // Add file to the array
		if (is_file($sitemap_dir[$sitemap_i].'/'.$sitemap_file) && ($sitemap_ok)) {
		  $sitemap_str .= '<tr valign="middle">';
		  $sitemap_str .= '<td width="22">&nbsp;</td>';
		  for ($sitemap_j = 0; $sitemap_j < $sitemap_ref[$sitemap_i]; $sitemap_j++) $sitemap_str .= '<td width="22" class="border-left">&nbsp;</td>';
		  $sitemap_str .= '<td class="border-angle" align="right"><img src="images/file.gif" border-bottom="0"></td>';
		  $sitemap_str .= '<td class="border-bottom" align="left"><a href="'.$sitemap_dir[$sitemap_i].'/'.$sitemap_file.'">'.basename($sitemap_file).'</a></td></tr>';
		}
	  }
	  closedir($sitemap_handle);
	}

	$sitemap_str .= '</table>';
  }

  $sitemap_str .= '</td></tr></table>';
  // End Script
  
  switch ($config['save']) {
    case 0: echo($sitemap_str); break;
	case 1:
	  $sitemap_fp = fopen($config['name'],'w');
	  if ($sitemap_fp) {
	    fwrite($sitemap_fp,$sitemap_str);
		fclose($sitemap_fp);
		echo('File saved!<br>');
		echo('Generation completed!<br>');
		echo('<a href="'.$config['name'].'">Find it here</a><br>');
	  } else {
		echo('File save failed!<br><br>');
	    echo($sitemap_str);
	  }
  }
?>
