<?
include ("protected_reg.php");

define ('REG_SECTION', '0');
define ('REG_KEY', '1');
define ('REG_PROTECTED', '2');

class REG_PROTECTED_VALUE {
	var $index;
	var $value;
}

//class REGISTER {
	$regval = array ();
	$_regman_sects = array(&$regval);
	$_regman_sects_count = 1;

	function regman_init () {
		global $regval, $regman;

		$regman = xml_parser_create ();
		xml_set_element_handler ($regman, regman_inizia_elemento, regman_fine_elemento);
		$regcode = file_get_contents ("register.xml");
		xml_parse ($regman, $regcode, true);
	}

	function regman_close () {
		global $regman;
		xml_parser_free ($regman);
	}

	function regman_inizia_elemento ($parser, $nome, $attributi) {
		global $_regman_sects, $_regman_sects_count, $protected_reg;
		if ($nome == "SECTION") {
			$_regman_sects[$_regman_sects_count-1][$attributi["NAME"]] = array();
			$_regman_sects[$_regman_sects_count] = &$_regman_sects[$_regman_sects_count-1][$attributi["NAME"]];
			$_regman_sects_count++;
		}
		elseif ($nome == "KEY") {
			$_regman_sects[$_regman_sects_count-1][$attributi["NAME"]] = $attributi["VALUE"];
		}
		elseif ($nome == "PROTECTED") {
			$_regman_sects[$_regman_sects_count-1][$attributi["NAME"]] = new REG_PROTECTED_VALUE();
			$_regman_sects[$_regman_sects_count-1][$attributi["NAME"]]->value = &$protected_reg[$attributi["VALUE"]];
			$_regman_sects[$_regman_sects_count-1][$attributi["NAME"]]->index = $attributi["VALUE"];
		}
	}

	function regman_fine_elemento ($parser, $nome) {
		global $_regman_sects_count;
		if ($nome == "SECTION") {
			$_regman_sects_count--;
		}
	}

	function regman_read_key ($path) {
		global $regval;

		if ($path == "") {
			$p = &$regval;
			return $p;
		}

		$path = explode ("", $path);
		$p = &$regval;

		for ($i=0;$i<=count($path);$i++) {
			if (is_array($p) && $i < count ($path)) {
				$p = &$p[$path[$i]];
				//if ($i == count($path)) return $p;
			}
			elseif (is_array($p)) {
				return $p;
			}
			elseif ($i == count($path)) {
				if (get_class($p) == "REG_PROTECTED_VALUE") {
					return $p->value;
				}
				else {
					return $p;
				}
			}
			else {
				trigger_error ("<b>WEBPORTAL</b>: Requested invalid register key in file ".__FILE__." at line ".__LINE__."<br>", E_USER_WARNING);
			}
		}
	}

	function regman_add_key ($path, $flags) {
		global $regval;


	}

	function regman_save () {
		global $protected_reg, $regval;

		$stream = fopen ("register.xml", "w");
		fwrite ($stream, "<register>\n");
		write_section ($stream, $regval);
		fwrite ($stream, "</register>\n");
		fclose ($stream);
		$stream = fopen ("protected_reg.php", "w");
		fwrite ($stream, "<?\n\$protected_reg = array (\n");
		for ($i=0;$i<count($protected_reg);$i++) {
			fwrite ($stream, "\"".$protected_reg[$i]."\"");
			if ($i<count($protected_reg)-1)
				fwrite ($stream, ",");
			fwrite ($stream, "\n");
		}
		fwrite ($stream, ");\n?>");
		fclose ($stream);
	}

	function write_section ($stream, $vettore) {
		$keys = array_keys ($vettore);
		for ($i=0;$i<count($keys);$i++) {
			if (is_array ($vettore[$keys[$i]])) {
				fwrite ($stream, "<section name=\"".$keys[$i]."\">\n");
				write_section ($stream, $vettore[$keys[$i]]);
				fwrite ($stream, "</section>\n");
			}
			elseif (get_class($vettore[$keys[$i]]) == "REG_PROTECTED_VALUE") {
				fwrite ($stream, "<protected name=\"".$keys[$i]."\" value=\"".$vettore[$keys[$i]]->index."\" />\n");
				$protected_reg[$vettore[$keys[$i]]->index] = $vettore[$keys[$i]]->value;
			}
			else {
				fwrite ($stream, "<key name=\"".$keys[$i]."\" value=\"".$vettore[$keys[$i]]."\" />\n");
			}
		}
	}
//}
?>