<?
//////////////////////////////////////////////
// Advanced Logging System by Ivano Culmine //
//////////////////////////////////////////////

/******************************************************************************/
/************************* Inizio delle impostazioni **************************/

// Cartella contenente il sistema di log
// essa pu essere assoluta o relativa, rispetto al percorso della pagina che lo utilizza
$logger_root = "logger/";

// Cartella contenente i files di log
// come la precedente, se relativo indica sempre il percorso a partire da quello della
// pagina che lo utilizza
$logger_data = $logger_root."data/";

// Tipo di log
// indica la quantit di dettaglio con cui il sistema logger qualsiasi pagina che lo
// utilizzer.
// E' possibile utilizzare uno dei seguenti valori:
// 0	- Nessuna azione verr loggata dal sistema
// 1	- Log semplice e conciso
// 2	- Come il precedente con l'indirizzo referenziatore
// 3	- Log completo, con report dei valori di tutte le sessioni, cookies, variabili
//		  get e post, definite
$log_quality = 3;

// Nome del file di log
// indica al logger come devono chiamarsi i files di log
// E' possibile inserire nella stringa i seguenti caratteri jolly:
// %y	- Anno corrente
// %m	- Mese corrente
// %d	- Giorno corrente
// %h	- Ora corrente
// %i	- Minuti correnti
// %s	- Secondi correnti
$log_file_name = "%y%m%d%h";


/************************** Fine delle impostazioni ***************************/
/******************************************************************************/

define (LOG_NONE, 0);
define (LOG_SIMPLE, 1);
define (LOG_REFERRER, 2);
define (LOG_FULL, 3);

include ($logger_root."functions.php");

global $log_line;
global $_COOKIE, $_SESSION, $_POST, $_FILES;

// Ricavo il nome del file di log
$log_file_name = format_string ($log_file_name);

if ($log_quality > LOG_NONE) {
	// Inserisco la forma pi basilare di log
	$log_line = date ("d/m/Y H:i:s - ");
	$log_line .= $REMOTE_ADDR;

	// Simple log
	if ($log_quality >= LOG_SIMPLE) {
		$log_line .= " - ".$REQUEST_URI;
		$log_line .= " - ".$HTTP_USER_AGENT;
	}
	if ($log_quality >= LOG_REFERRER) {
		$log_line .= " - ".$HTTP_REFERER;
	}
	// Full log
	if ($log_quality >= LOG_FULL) {
		// Inizio ad inserire le variabili POST
		$log_line .= " - POST BEGIN - ";
		log_array ($_POST);
		$log_line .= " - POST END";
		// Inizio ad inserire le variabili SESSION
		$log_line .= " - SESSION BEGIN - ";
		log_array ($_SESSION);
		$log_line .= " - SESSION END";
		// Inizio ad inserire le variabili COOKIES
		$log_line .= " - COOKIE BEGIN - ";
		log_array ($_COOKIE);
		$log_line .= " - COOKIE END";
		// Inizio ad inserire le variabili COOKIES
		$log_line .= " - FILES BEGIN - ";
		log_array ($_FILES);
		$log_line .= " - FILES END";
	}

	$log_line .= " - LOG END\n";
	log_add_line ($log_line);
}
?>