<?
/*
	WebPortal Package Reader v1.0

	This library reads WPP files created by wppacker utility version <= 1.0
	this library has been written for exclusive use with WebPortal CMS

	Library Author:
	Ivano Culmine
	ivanoculmi@libero.it
	http://ivano85.altervista.org
*/

library_load_file ("types.php", "wpp");
library_load_file ("functions.php", "wpp");

class WPP {
	var $supported = array (1);
	var $file;
	var $well_loaded;
	var $error;
	var $info_types = array (
		"Nome",
		"Autore",
		"Pagina Web",
		"E-mail",
		"Commento",
		"Descrizione"
	);

	var $stream;

	var $header;
	var $info = array();
	var $licenses = array();
	var $packs = array();
	var $depends = array();
	var $dirs = array();
	var $files = array();
	var $queries = array();

	var $queries_begin = 0;

	// Puntatori:
	var $next_info = 0;
	var $next_license = 0;
	var $next_pack = 0;
	var $next_depend = 0;
	var $next_query = 0;

	function WPP ($file) {
		$this->file = $file;
		$this->header = new WPP_Header();
		$this->stream = fopen($file, "r");
		if ($this->stream == false) {
			$this->well_loaded = false;
			$this->error = "Impossible to open the file $file";
			return;
		}
		$this->header->version = read_int8($this->stream);
		if ($this->header->version != 1) {
			$this->well_loaded = false;
			$this->error = "Package version of file '$file' not supported";
			$this->close ();
			return;
		}
		$this->header->num_info = read_int8($this->stream);
		$this->header->num_licenses = read_int8($this->stream);
		$this->header->num_packs = read_int8($this->stream);
		$this->header->num_depend = read_int8($this->stream);
		// Allineamento
		read_int8($this->stream);
		$this->header->num_dirs = read_int16($this->stream);
		$this->header->num_files = read_int16($this->stream);
		$this->header->num_queries = read_int16($this->stream);
		for ($i=0;$i<$this->header->num_info;$i++) {
			$new = count($this->info);
			$this->info[$new] = new WPP_Info();
			$this->info[$new]->type = read_int8($this->stream);
			// Allineamento
			read_int8($this->stream);
			$this->info[$new]->len = read_int16($this->stream);
			$this->info[$new]->data = read_data ($this->stream, $this->info[$new]->len);
		}
		for ($i=0;$i<$this->header->num_licenses;$i++) {
			$new = count ($this->licenses);
			$this->licenses[$new] = new WPP_License ();
			$this->licenses[$new]->id = read_int8($this->stream);
			// Allineamento
			read_int8($this->stream);
			$this->licenses[$new]->len = read_int16($this->stream);
			$this->licenses[$new]->text = read_data($this->stream, $this->licenses[$new]->len);
		}
		for ($i=0;$i<$this->header->num_packs;$i++) {
			$new = count ($this->packs);
			$this->packs[$new] = new WPP_Pack ();
			$this->packs[$new]->id = read_int8($this->stream);
			$this->packs[$new]->len = read_int8($this->stream);
			// Allineamento
			read_int16($this->stream);
			$this->packs[$new]->name = read_data($this->stream, $this->packs[$new]->len);
		}
		for ($i=0;$i<$this->header->num_depend;$i++) {
			$new = count ($this->depends);
			$this->depends[$new] = new WPP_License ();
			$this->depends[$new]->pack_id = read_int8($this->stream);
			$this->depends[$new]->len = read_int8($this->stream);
			// Allineamento
			read_int8($this->stream);
			read_int8($this->stream);
			$this->depends[$new]->name = read_data($this->stream, $this->depends[$new]->len);
		}
		for ($i=0;$i<$this->header->num_dirs;$i++) {
			$new = count ($this->dirs);
			$this->dirs[$new] = new WPP_Dir();
			$this->dirs[$new]->id = read_int16 ($this->stream);
			$this->dirs[$new]->pack_id = read_int8 ($this->stream);
			read_int8 ($this->stream);
			$this->dirs[$new]->mod = read_int16 ($this->stream);
			$this->dirs[$new]->len = read_int16 ($this->stream);
			$this->dirs[$new]->path = read_data ($this->stream, $this->dirs[$new]->len);
		}
		for ($i=0;$i<$this->header->num_files;$i++) {
			$new = count ($this->files);
			$this->files[$new] = new WPP_File();
			$this->files[$new]->pack_id = read_int8($this->stream);
			read_int8($this->stream);
			$this->files[$new]->parent = read_int16($this->stream);
			$this->files[$new]->mod = read_int16($this->stream);
			$this->files[$new]->len_name = read_int8($this->stream);
			read_int8($this->stream);
			$this->files[$new]->len_file = read_int32($this->stream);
			$this->files[$new]->name = read_data($this->stream, $this->files[$new]->len_name);
			$this->files[$new]->file = ftell($this->stream);
			fseek ($this->stream, $this->files[$new]->len_file, SEEK_CUR);
		}
		$this->queries_begin = ftell($this->stream);
		$this->next_query = $this->queries_begin;
		$this->well_loaded = true;
	}

	function close () {
		fclose ($this->stream);
	}

	function package_depends ($pack_id) {
		$depends = array ();
		for ($k=0;$k<$this->header->num_packs;$k++) {
			if ($this->packs[$k]->id != $pack_id)
				continue;
			for ($i=0;$i<$this->header->num_depend;$i++) {
				if ($this->depends[$i]->pack_id == $this->packs[$k]->id)
					$depends[] = $this->depends[$i]->name;
			}
			break;
		}
		return $depends;
	}

	function next_file_info () {
		if ($this->header->num_files == $this->next_file)
			return false;

	}

	function dir_path ($id) {
		for ($i=0;$i<$this->header->num_dirs;$i++) {
			if ($this->dirs[$i]->id == $id)
				return $this->dirs[$i]->path;
		}
		return 0;
	}

	function package_info ($type) {
		if ($type == 4) return false;
		for ($i=0;$i<$this->header->num_info;$i++) {
			if ($this->info[$i]->type == $type)
				return $this->info[$i]->data;
		}
		return false;
	}

	function query_reset () {
		$this->next_query = $this->queries_begin;
		fseek ($this->stream, $this->queries_begin, SEEK_SET);
	}

	function query_get ($pack_id) {
		while (!feof($this->stream)) {
			$pid = read_int8 ($this->stream);
			read_int8($this->stream);
			$len = read_int16($this->stream);
			$text = read_data($this->stream, $len);
			$this->next_query = ftell($this->stream);
			if ($pid == $pack_id)
				return $text;
		}
		return false;
	}

	function install_file ($id, $path) {
		$dest = fopen ($path."/".$this->files[$id]->name, "w");
		fseek ($this->stream, $this->files[$id]->file, SEEK_SET);
		$data = fread ($this->stream, $this->files[$id]->len_file);
		fwrite ($dest, $data, $this->files[$id]->len_file);
		fclose ($dest);
		chmod ($path."/".$this->files[$id]->name, $this->files[$id]->mod);
	}
}
?>