<?
/*
	Libreria di supporto per l'elaborazione di queries SQL, fornisce un pratico sostegno
	di base per altre librerie che vogliono gestire un database utilizzando il linguaggio
	SQL.

	Nome libreria: pre_sql_parser
	Versione: 0.1 beta
	Creatore: Ivano Culmine
	Data creazione: 03/03/2005
*/

// General constants
define ('SQL_STATUS_CODE', 0);
define ('SQL_STATUS_STRING', 1);
define ('SQL_STATUS_OPERATOR', 2);

// Parsing constants
define ('SQL_STATUS_BEGIN', 100);
define ('SQL_STATUS_TABLE', 101);
define ('SQL_STATUS_FIELD', 102);
define ('SQL_STATUS_DIRECTIVE', 103);
define ('SQL_STATUS_DIR_WHERE', 104);
define ('SQL_STATUS_DIR_ORDER', 105);
define ('SQL_STATUS_DIR_LIMIT', 106);

class SQL_Parser {
	//Properties
	var $backslash_quotes = false;
	var $let_structurize = true;

	// Parser variables
	var $version = "0.1";
	var $position = 0;

	var $reserveds = array (
		"SELECT", "FROM", "WHERE", "AND", "NOT", "OR",
		"CREATE", "TABLE", "DROP", "DATABASE", "UPDATE",
		"ORDER", "DESC", "ASC", "AS", "DEFAULT", "NULL",
		"INDEX_BLIST", "INDEX_NONE", "BIT", "REAL", "CHAR", "LONGTEXT",
		"TEXT", "DATE", "TIME", "FLOAT", "BIGINT", "DOUBLE",
		"STRING", "BINARY", "NUMERIC", "DECIMAL", "BOOLEAN",
		"TINYINT", "INTEGER", "VARCHAR", "CHAR", "INT", "SMALLINT",
		"VARBINARY", "TIMESTAMP", "LONGVARCHAR", "JAVA_OBJECT",
		"LONGVARBINARY", "CONSTRAINT", "KEY", "PRIMARY", "FOREIGN",
		"REFERENCES", "ON", "DELETE", "UNIQUE", "CHECK", "INITIALLY",
		"DEFERRED", "IMMEDIATE", "DEFERRABLE", "NO", "ACTION", "SET",
		"CASCADE", "ALTER", "COLUMN", "ADD",  "IF", "EXISTS", "VIEW",
		"SEQUENCE", "INCREMENT", "MINVALUE", "MAXVALUE", "START",
		"CACHE", "CYCLE", "COMPACT", "SCHEMA", "INSERT", "INTO", "VALUES",
		"LIMIT", "DISTINCT", "ALL", "GROUP", "HAVING", "BY", "LEFT",
		"OUTER", "JOIN", "RIGHT", "INNER", "COMMIT", "ROLLBACK", "USER",
		"PASSWORD", "GROUPS", "ACCOUNT", "LOCK", "UNLOCK", "GRANT", "TO",
		"PUBLIC", "WITH", "OPTION", "REVOKE", "FOR", "USAGE", "AUTO",
		"TRANSACTION", "ISOLATION", "LEVEL", "OFF", "SERIALIZABLE",
		"DESCRIBE", "SHOW", "TABLES", "CONNECTIONS", "STATUS", "SHUTDOWN"
	);

	var $types = array (
		"BIT", "REAL", "CHAR", "TEXT", "DATE", "TIME", "FLOAT", "BIGINT",
		"DOUBLE", "STRING", "BINARY", "NUMERIC", "DECIMAL", "BOOLEAN",
		"TINYINT", "INTEGER", "VARCHAR", "INT", "SMALLINT", "VARBINARY",
		"TIMESTAMP", "LONGVARCHAR", "JAVA_OBJECT", "LONGVARBINARY", "LONGTEXT"
	);

	var $operators = array ("<", ">", "=", "+", "-", "*", "/");

	function SQL_Parser ($backslash_quotes = false, $let_structurize = true) {
		$this->backslash_quotes = $backslash_quotes;
		$this->let_structurize = $let_structurize;
		return 1;
	}

	function parse ($query) {
		$status = SQL_STATUS_CODE;
		$word = "";
		$result = array ();
		$index = 0;
		$end_points = array (-1);

		for ($i=0;$i<strlen($query);$i++) {
			$char = substr($query, $i, 1);

			switch ($status) {
				// Sta analizzando il codice
				case SQL_STATUS_CODE:
					if ($char == " " || $char == "\n" || $char == "\r" || $char == "\t") {
						if ($word != "") $result[$index][] = $word;
						$word = "";
					}
					elseif ($char == "(" || $char == ")") {
						if ($word != "") $result[$index][] = $word;
						$result[$index][] = $char;
						$word = "";
					}
					elseif ($char == ",") {
						if ($word != "") $result[$index][] = $word;
						$result[$index][] = $char;
						$word = "";
					}
					elseif ($char == "'" || $char == "`") {
						$status = SQL_STATUS_STRING;
						//$result[$index][] = "'";
						$word = "";
					}
					elseif (in_array($char, $this->operators)) {
						$result[$index][] = $word;
						$word = "";
						$i--;
						$status = SQL_STATUS_OPERATOR;
					}
					elseif ($char == ";") {
						if ($word != "") $result[$index][] = $word;
							$word = "";
						$result[$index][] = $char;
						$index++;
						$end_points[] = $i;
						if ($i==strlen($query)-1)
							return $this->build_result ($this->normalize($result), $query, $end_points);
					}
					else {
						$word .= $char;
					}
					break;
				// Sta copiando una stringa
				case SQL_STATUS_STRING:
					if ($char == "\\") {
						$i++;
						$next = substr($query, $i, 1);
						if (($next == "'" || $next == "`" || $next == "\"") && $this->backslash_quotes)
							$word .= $char;
						$word .= $next;
					}
					elseif ($char == "'" || $char == "`") {
						$result[$index][] = $word;
						//$result[$index][] = "'";
						$word = "";
						$status = SQL_STATUS_CODE;
					}
					else {
						$word .= $char;
					}
					break;
				case SQL_STATUS_OPERATOR:
					if (in_array ($char, $this->operators)) {
						$word .= $char;
					}
					else {
						$i--;
						$status = SQL_STATUS_CODE;
						$result[$index][] = $word;
						$word = "";
					}
					break;
			}
		}
		trigger_error ("La query non  conclusa correttamente");
	}

	function build_result ($result, $query, $end_points) {
		$returning = array ();

		for ($i=0;$i<count($result);$i++) {
			switch ($result[$i][0]) {
				case "SELECT":
					$returning[$i]["command"] = "SELECT FROM";
					break;
				case "ALTER":
					$returning[$i]["command"] = "ALTER ".$result[$i][1];
					break;
				case "CREATE":
					$returning[$i]["command"] = "CREATE ".$result[$i][1];
					break;
				case "DROP":
					$returning[$i]["command"] = "DROP ".$result[$i][1];
					break;
				default:
					$returning[$i]["command"] = $result[$i][0];
					break;
			}
			$returning[$i]["query"] = substr ($query, $end_points[$i]+1, $end_points[$i+1]+1-$end_points[$i]);
			$returning[$i]["query"] = str_replace ("\r", "", str_replace ("\n", "", $returning[$i]["query"]));
			$returning[$i]["result"] = $result[$i];
			if ($this->let_structurize)
				$returning[$i]["struct"] = $this->structurize($result[$i]);
		}
		return $returning;
	}

	function is_reserved ($word) {
		return in_array (strtoupper($word), $this->reserveds);
	}

	function normalize ($result) {
		for ($i=0;$i<count($result);$i++) {
			for ($k=0;$k<count($result[$i]);$k++) {
				if ($this->is_reserved($result[$i][$k]))
					$result[$i][$k] = strtoupper ($result[$i][$k]);
			}
		}
		return $result;
	}

	function structurize ($result) {
		$this->position = 0;
		$status = SQL_STATUS_BEGIN;
		$return = array ();
		$fields = array();
		$conditions = array ();
		$order = array ();
		$limit = array ();

		for ($i=0;$i<count($result);$i++) {
			do {
				$element = $this->get_element ($result, $status);
				if ($element == ";") {
					$end = true;
					break;
				}
				switch ($status) {
					case SQL_STATUS_BEGIN:
						switch ($element) {
							case "SELECT":
								$command = $element;
								$status = SQL_STATUS_FIELD;
								break;
							case "INSERT":
								$command = $element;
								$status = SQL_STATUS_TABLE;
								break;
							case "DELETE":
								$command = $element;
								$status = SQL_STATUS_TABLE;
								break;
							case "DROP":
								$element = $this->get_element($result);
								switch ($element) {
									case "DATABASE":
										$command = "DROP DATABASE";
										$status = SQL_STATUS_DATABASE;
										break;
									case "TABLE":
										$command = "DROP TABLE";
										$status = SQL_STATUS_TABLE;
										break;
								}
								break;
							case "CREATE":
								$element = $this->get_element($result);
								switch ($element) {
									case "DATABASE":
										$command = "CREATE DATABASE";
										$status = SQL_STATUS_DATABASE;
										break;
									case "TABLE":
										$command = "CREATE TABLE";
										$status = SQL_STATUS_TABLE;
										break;
								}
								break;
							default:
								echo "Comando $element sconosciuto nella query";
								return 0;
								break;
						}
						break;
					case SQL_STATUS_TABLE:
						switch ($command) {
							case "SELECT":
								if (!($this->is_reserved ($element))) {
									$tbl_name = $element;
									$status = SQL_STATUS_DIRECTIVE;
								}
								else {
									echo "Errore nella query";
									return 0;
								}
								break;
							case "INSERT":
								break;
							case "DELETE":
								break;
						}
						break;
					case SQL_STATUS_FIELD:
						switch ($command) {
							case "SELECT":
								if (!($this->is_reserved($element)) && $element != ",")
									$fields[] = $element;
								elseif ($element == "FROM") {
									$status = SQL_STATUS_TABLE;
								}
								break;
						}
						break;
					case SQL_STATUS_DIRECTIVE:
						switch ($element) {
							case "WHERE":
								$status = SQL_STATUS_DIR_WHERE;
								break;
							case "ORDER":
								$status = SQL_STATUS_DIR_ORDER;
								break;
							case "LIMIT":
								$status = SQL_STATUS_DIR_LIMIT;
								break;
							default:
								echo "Direttiva $element sconosciuta";
								break;
						}
						break;
					case SQL_STATUS_DIR_WHERE:
						$where_index = count ($conditions);
						if ($element == "AND" || $element == "OR") {
							$conditions[$where_index] = $element;
						}
						else {
							$conditions[$where_index][0] = $element;
							$conditions[$where_index][1] = $this->get_element($result, $status);
							$conditions[$where_index][2] = $this->get_element($result, $status);
							if ($this->is_reserved($result[$this->position]) && $result[$this->position] != "AND" && $result[$this->position] != "OR")
								$status = SQL_STATUS_DIRECTIVE;
						}
						break;
					case SQL_STATUS_DIR_ORDER:
						$element = $this->get_element ($result);  // Tolgo il BY
						$order[0] = $element;
						if ($result[$this->position] == "DESC" || $result[$this->position] == "ASC") {
							$order[1] = $this->get_element($result);
						}
						if ($this->is_reserved($result[$this->position]))
							$status = SQL_STATUS_DIRECTIVE;
						break;
					case SQL_STATUS_DIR_LIMIT:
						$limit[0] = $element;
						if ($result[$this->position] == ",") {
							$this->get_element($result);
							$limit[1] = $this->get_element($result);
						}
						if ($this->is_reserved($result[$this->position]))
							$status = SQL_STATUS_DIRECTIVE;
						break;
				}
			} while ($element != ";");
			if ($end) break;
		}
		return array (
				"table" => $tbl_name,
				"fields" => $fields,
				"conditions" => $conditions,
				"order" => $order,
				"limit" => $limit
			);
	}

	function get_element ($query_result, $status = 0) {
		if ($this->position == count ($query_result)) die ("Fuori raggio");
		$element = $query_result[$this->position++];
		//echo "get_element(): ".$element." ($status) at ".($this->position-1)."\n";
		return $element;
	}
}

?>